/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.EventHubsProducerInstrumentation;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.implementation.EventHubReactorAmqpConnection;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsConsumerInstrumentation;
import java.io.Closeable;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

class EventHubAsyncClient
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(EventHubAsyncClient.class);
    private final MessageSerializer messageSerializer;
    private final ReactorConnectionCache<EventHubReactorAmqpConnection> connectionCache;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClose;
    private final String identifier;
    private final Tracer tracer;
    private final Meter meter;

    EventHubAsyncClient(ReactorConnectionCache<EventHubReactorAmqpConnection> connectionCache, MessageSerializer messageSerializer, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClose, String identifier, Meter meter, Tracer tracer) {
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.connectionCache = Objects.requireNonNull(connectionCache, "'recoverableConnection' cannot be null.");
        this.scheduler = Objects.requireNonNull(scheduler, "'scheduler' cannot be null");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.isSharedConnection = isSharedConnection;
        this.identifier = identifier;
        this.tracer = tracer;
        this.meter = meter;
    }

    String getFullyQualifiedNamespace() {
        return this.connectionCache.getFullyQualifiedNamespace();
    }

    String getEventHubName() {
        return this.connectionCache.getEntityPath();
    }

    Mono<EventHubProperties> getProperties() {
        return this.connectionCache.get().flatMap(connection -> connection.getManagementNode()).flatMap(EventHubManagementNode::getEventHubProperties);
    }

    Flux<String> getPartitionIds() {
        return this.getProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        return this.connectionCache.get().flatMap(connection -> connection.getManagementNode()).flatMap(node -> node.getPartitionProperties(partitionId));
    }

    EventHubProducerAsyncClient createProducer() {
        EventHubsProducerInstrumentation instrumentation = new EventHubsProducerInstrumentation(this.tracer, this.meter, this.connectionCache.getFullyQualifiedNamespace(), this.connectionCache.getEntityPath());
        return new EventHubProducerAsyncClient(this.connectionCache.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionCache, this.connectionCache.getRetryOptions(), this.messageSerializer, this.scheduler, this.isSharedConnection, this.onClientClose, this.identifier, instrumentation);
    }

    EventHubConsumerAsyncClient createConsumer(String consumerGroup, int prefetchCount, boolean isSync) {
        Objects.requireNonNull(consumerGroup, "'consumerGroup' cannot be null.");
        if (consumerGroup.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'consumerGroup' cannot be an empty string."));
        }
        EventHubsConsumerInstrumentation instrumentation = new EventHubsConsumerInstrumentation(this.tracer, this.meter, this.connectionCache.getFullyQualifiedNamespace(), this.connectionCache.getEntityPath(), consumerGroup, isSync);
        return new EventHubConsumerAsyncClient(this.connectionCache.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionCache, this.messageSerializer, consumerGroup, prefetchCount, this.isSharedConnection, this.onClientClose, this.identifier, instrumentation);
    }

    @Override
    public void close() {
        this.connectionCache.dispose();
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

