/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.implementation.MessageUtils;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsMetricsProvider;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import java.time.Instant;
import java.time.ZoneOffset;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.message.Message;

public class EventHubsConsumerInstrumentation {
    private static final Symbol ENQUEUED_TIME_UTC_ANNOTATION_NAME_SYMBOL = Symbol.valueOf((String)AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
    private final EventHubsTracer tracer;
    private final EventHubsMetricsProvider meter;
    private final boolean isSync;

    public EventHubsConsumerInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityName, String consumerGroup, boolean isSyncConsumer) {
        this.tracer = new EventHubsTracer(tracer, fullyQualifiedName, entityName);
        this.meter = new EventHubsMetricsProvider(meter, fullyQualifiedName, entityName, consumerGroup);
        this.isSync = isSyncConsumer;
    }

    public EventHubsTracer getTracer() {
        return this.tracer;
    }

    public Context asyncConsume(String spanName, Message message, String partitionId, Context parent) {
        if (!this.meter.isConsumerLagEnabled() && !this.tracer.isEnabled()) {
            return parent;
        }
        Instant enqueuedTime = MessageUtils.getEnqueuedTime(message.getMessageAnnotations().getValue(), ENQUEUED_TIME_UTC_ANNOTATION_NAME_SYMBOL);
        Context child = parent;
        if (this.tracer.isEnabled() && !this.isSync) {
            StartSpanOptions options = this.tracer.createStartOption(SpanKind.CONSUMER, EventHubsTracer.OperationName.PROCESS).setAttribute("messaging.eventhubs.message.enqueued_time", (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            if (message.getApplicationProperties() != null) {
                options.setRemoteParent(this.tracer.extractContext(message.getApplicationProperties().getValue()));
            }
            child = this.tracer.startSpan(spanName, options, parent);
        }
        this.meter.reportReceive(enqueuedTime, partitionId, child);
        return child;
    }
}

