/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.Meter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventHubsMetricsProvider {
    private static final String GENERIC_STATUS_KEY = "status";
    private final Meter meter;
    private final boolean isEnabled;
    private AttributeCache sendAttributeCacheSuccess;
    private AttributeCache sendAttributeCacheFailure;
    private AttributeCache receiveAttributeCache;
    private LongCounter sentEventsCounter;
    private DoubleHistogram consumerLag;

    public EventHubsMetricsProvider(Meter meter, String namespace, String entityName, String consumerGroup) {
        this.meter = meter;
        boolean bl = this.isEnabled = meter != null && meter.isEnabled();
        if (this.isEnabled) {
            HashMap<String, Object> commonAttributesMap = new HashMap<String, Object>(3);
            commonAttributesMap.put("hostName", namespace);
            commonAttributesMap.put("entityName", entityName);
            if (consumerGroup != null) {
                commonAttributesMap.put("consumerGroup", consumerGroup);
            }
            this.sendAttributeCacheSuccess = new AttributeCache("partitionId", new HashMap<String, Object>(commonAttributesMap));
            HashMap<String, Object> failureMap = new HashMap<String, Object>(commonAttributesMap);
            failureMap.put(GENERIC_STATUS_KEY, "error");
            this.sendAttributeCacheFailure = new AttributeCache("partitionId", failureMap);
            this.receiveAttributeCache = new AttributeCache("partitionId", commonAttributesMap);
            this.sentEventsCounter = meter.createLongCounter("messaging.eventhubs.events.sent", "Number of sent events", "events");
            this.consumerLag = meter.createDoubleHistogram("messaging.eventhubs.consumer.lag", "Difference between local time when event was received and the local time it was enqueued on broker.", "sec");
        }
    }

    public boolean isSendCountEnabled() {
        return this.isEnabled && this.sentEventsCounter.isEnabled();
    }

    public void reportBatchSend(int batchSize, String partitionId, Throwable throwable, Context context) {
        if (this.isEnabled && this.sentEventsCounter.isEnabled()) {
            AttributeCache cache = throwable == null ? this.sendAttributeCacheSuccess : this.sendAttributeCacheFailure;
            this.sentEventsCounter.add((long)batchSize, cache.getOrCreate(partitionId), context);
        }
    }

    public boolean isConsumerLagEnabled() {
        return this.isEnabled && this.consumerLag.isEnabled();
    }

    public void reportReceive(Instant enqueuedTime, String partitionId, Context context) {
        if (this.isEnabled && this.consumerLag.isEnabled()) {
            double diff = 0.0;
            if (enqueuedTime != null && (diff = (double)(Instant.now().toEpochMilli() - enqueuedTime.toEpochMilli())) < 0.0) {
                diff = 0.0;
            }
            this.consumerLag.record(diff / 1000.0, this.receiveAttributeCache.getOrCreate(partitionId), context);
        }
    }

    class AttributeCache {
        private final Map<String, TelemetryAttributes> attr = new ConcurrentHashMap<String, TelemetryAttributes>();
        private final TelemetryAttributes commonAttr;
        private final Map<String, Object> commonMap;
        private final String dimensionName;

        AttributeCache(String dimensionName, Map<String, Object> common) {
            this.dimensionName = dimensionName;
            this.commonMap = common;
            this.commonAttr = EventHubsMetricsProvider.this.meter.createAttributes(this.commonMap);
        }

        public TelemetryAttributes getOrCreate(String value) {
            if (value == null) {
                return this.commonAttr;
            }
            return this.attr.computeIfAbsent(value, this::create);
        }

        private TelemetryAttributes create(String value) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(this.commonMap);
            attributes.put(this.dimensionName, value);
            return EventHubsMetricsProvider.this.meter.createAttributes(attributes);
        }
    }
}

