/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.implementation.AmqpLinkProvider;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.Meter;
import com.azure.messaging.eventhubs.implementation.EventHubReactorAmqpConnection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

final class V2StackSupport {
    private static final String V2_STACK_KEY = "com.azure.messaging.eventhubs.v2";
    private static final ConfigurationProperty<Boolean> V2_STACK_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.eventhubs.v2").environmentVariableName("com.azure.messaging.eventhubs.v2").defaultValue((Object)false).shared(true).build();
    private final AtomicReference<Boolean> v2StackFlag = new AtomicReference();
    private static final String SESSION_CHANNEL_CACHE_KEY = "com.azure.core.amqp.cache";
    private static final ConfigurationProperty<Boolean> SESSION_CHANNEL_CACHE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.core.amqp.cache").environmentVariableName("com.azure.core.amqp.cache").defaultValue((Object)true).shared(true).build();
    private final AtomicReference<Boolean> sessionChannelCacheFlag = new AtomicReference();
    private final ClientLogger logger;

    V2StackSupport(ClientLogger logger) {
        this.logger = logger;
    }

    boolean isV2StackEnabled(Configuration configuration) {
        return this.isOptedIn(configuration, V2_STACK_PROPERTY, this.v2StackFlag);
    }

    boolean isSessionChannelCacheEnabled(Configuration configuration) {
        if (!this.isV2StackEnabled(configuration)) {
            return false;
        }
        return !this.isOptedOut(configuration, SESSION_CHANNEL_CACHE_PROPERTY, this.sessionChannelCacheFlag);
    }

    private boolean isOptedOut(Configuration configuration, ConfigurationProperty<Boolean> configProperty, AtomicReference<Boolean> choiceFlag) {
        boolean isOptedOut;
        Boolean flag = choiceFlag.get();
        if (flag != null) {
            return flag;
        }
        String propName = configProperty.getName();
        if (configuration != null) {
            isOptedOut = (Boolean)configuration.get(configProperty) == false;
        } else {
            assert (!CoreUtils.isNullOrEmpty((CharSequence)propName));
            isOptedOut = !CoreUtils.isNullOrEmpty((CharSequence)System.getenv(propName)) ? "false".equalsIgnoreCase(System.getenv(propName)) : (!CoreUtils.isNullOrEmpty((CharSequence)System.getProperty(propName)) ? "false".equalsIgnoreCase(System.getProperty(propName)) : false);
        }
        if (choiceFlag.compareAndSet(null, isOptedOut)) {
            this.logger.verbose("Selected configuration {}={}", new Object[]{propName, isOptedOut});
            if (isOptedOut) {
                String logMessage = "If your application fails to work without explicitly setting {} configuration to 'false', please file an urgent issue at https://github.com/Azure/azure-sdk-for-java/issues/new/choose";
                this.logger.info("If your application fails to work without explicitly setting {} configuration to 'false', please file an urgent issue at https://github.com/Azure/azure-sdk-for-java/issues/new/choose", new Object[]{propName});
            }
        }
        return choiceFlag.get();
    }

    private boolean isOptedIn(Configuration configuration, ConfigurationProperty<Boolean> configProperty, AtomicReference<Boolean> choiceFlag) {
        boolean isOptedIn;
        Boolean flag = choiceFlag.get();
        if (flag != null) {
            return flag;
        }
        String propName = configProperty.getName();
        if (configuration != null) {
            isOptedIn = (Boolean)configuration.get(configProperty);
        } else {
            assert (!CoreUtils.isNullOrEmpty((CharSequence)propName));
            isOptedIn = !CoreUtils.isNullOrEmpty((CharSequence)System.getenv(propName)) ? "true".equalsIgnoreCase(System.getenv(propName)) : (!CoreUtils.isNullOrEmpty((CharSequence)System.getProperty(propName)) ? "true".equalsIgnoreCase(System.getProperty(propName)) : false);
        }
        if (choiceFlag.compareAndSet(null, isOptedIn)) {
            this.logger.verbose("Selected configuration {}={}", new Object[]{propName, isOptedIn});
        }
        return choiceFlag.get();
    }

    ReactorConnectionCache<EventHubReactorAmqpConnection> createConnectionCache(ConnectionOptions connectionOptions, Supplier<String> eventHubNameSupplier, MessageSerializer serializer, Meter meter, boolean useSessionChannelCache) {
        Supplier<EventHubReactorAmqpConnection> connectionSupplier = () -> {
            String connectionId = StringUtil.getRandomString((String)"MF");
            AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getAuthorizationScope());
            ReactorProvider provider = new ReactorProvider();
            ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider, meter);
            AmqpLinkProvider linkProvider = new AmqpLinkProvider();
            return new EventHubReactorAmqpConnection(connectionId, connectionOptions, (String)eventHubNameSupplier.get(), provider, handlerProvider, linkProvider, (TokenManagerProvider)tokenManagerProvider, serializer, true, useSessionChannelCache);
        };
        String fullyQualifiedNamespace = connectionOptions.getFullyQualifiedNamespace();
        String entityPath = eventHubNameSupplier.get();
        AmqpRetryPolicy retryPolicy = RetryUtil.getRetryPolicy((AmqpRetryOptions)connectionOptions.getRetry());
        Map<String, String> loggingContext = Collections.singletonMap("entityPath", entityPath);
        return new ReactorConnectionCache(connectionSupplier, fullyQualifiedNamespace, entityPath, retryPolicy, loggingContext);
    }
}

