// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the ServiceBusManagementClient type. */
public final class ServiceBusManagementClientImpl {
    /** The proxy service used to perform REST calls. */
    private final ServiceBusManagementClientService service;

    /** The Service Bus fully qualified domain name. */
    private String endpoint;

    /**
     * Gets The Service Bus fully qualified domain name.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Sets The Service Bus fully qualified domain name.
     *
     * @param endpoint the endpoint value.
     * @return the service client itself.
     */
    ServiceBusManagementClientImpl setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /** Api Version. */
    private String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Sets Api Version.
     *
     * @param apiVersion the apiVersion value.
     * @return the service client itself.
     */
    ServiceBusManagementClientImpl setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    private final SerializerAdapter serializerAdapter;

    public SerializerAdapter getSerializerAdapter() {
        return serializerAdapter;
    }

    /** The QueuesImpl object to access its operations. */
    private final QueuesImpl queues;

    /**
     * Gets the QueuesImpl object to access its operations.
     *
     * @return the QueuesImpl object.
     */
    public QueuesImpl getQueues() {
        return this.queues;
    }

    /** Initializes an instance of ServiceBusManagementClient client. */
    ServiceBusManagementClientImpl() {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()).build());
    }

    /**
     * Initializes an instance of ServiceBusManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     */
    ServiceBusManagementClientImpl(HttpPipeline httpPipeline) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter());
    }

    /**
     * Initializes an instance of ServiceBusManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     */
    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.queues = new QueuesImpl(this);
        this.service = RestProxy.create(ServiceBusManagementClientService.class, this.httpPipeline, serializerAdapter);
    }

    /**
     * The interface defining all the services for ServiceBusManagementClient to be used by the proxy service to perform
     * REST calls.
     */
    @Host("https://{endpoint}")
    @ServiceInterface(name = "ServiceBusManagement")
    private interface ServiceBusManagementClientService {
        @Get("/$Resources/{entityType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ServiceBusManagementErrorException.class)
        Mono<Response<Object>> listEntities(
                @HostParam("endpoint") String endpoint,
                @PathParam("entityType") String entityType,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                Context context);
    }

    /**
     * Get the details about the entities of the given Service Bus namespace.
     *
     * @param entityType List all queues or all topics of the service bus. Value can be "queues" or "topics".
     * @param skip The skip parameter.
     * @param top The top parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ServiceBusManagementErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details about the entities of the given Service Bus namespace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> listEntitiesWithResponseAsync(
            String entityType, Integer skip, Integer top, Context context) {
        return service.listEntities(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), context);
    }
}
