// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;

/**
 * The ResponseTitle model.
 */
@JacksonXmlRootElement(localName = "ResponseTitle")
@Fluent
public final class ResponseTitle {
    /*
     * Type of value
     */
    @JacksonXmlProperty(localName = "type", isAttribute = true)
    private String type;

    /*
     * Contents of the title.
     */
    // There is no current way to represent an XML element with an attribute in Open API 2.0 or 3.0.
    // https://github.com/OAI/OpenAPI-Specification/issues/630. Consequently, we have to make this change so that
    // It will not wrap the element with another set of tags.
    @JacksonXmlText
    private String title;

    /**
     * Get the type property: Type of value.
     *
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of value.
     *
     * @param type the type value to set.
     *
     * @return the ResponseTitle object itself.
     */
    public ResponseTitle setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the title property: Contents of the title.
     *
     * @return the title value.
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * Set the title property: Contents of the title.
     *
     * @param title the title value to set.
     *
     * @return the ResponseTitle object itself.
     */
    public ResponseTitle setTitle(String title) {
        this.title = title;
        return this;
    }
}
