/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.implementation.Messages;
import java.util.Objects;
import java.util.UUID;

public interface MessageLockToken {
    public String getLockToken();

    public static MessageLockToken fromString(String lockToken) {
        return () -> {
            if (Objects.isNull(lockToken)) {
                throw new NullPointerException("'lockToken' cannot be null.");
            }
            if (lockToken.isEmpty()) {
                throw new IllegalArgumentException("'lockToken' cannot be empty.");
            }
            try {
                UUID.fromString(lockToken);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException(String.format(Messages.INVALID_LOCK_TOKEN_STRING, lockToken));
            }
            return lockToken;
        };
    }
}

