/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.models.ReceiveMode;
import java.time.Duration;

class ReceiverOptions {
    private final ReceiveMode receiveMode;
    private final int prefetchCount;
    private final String sessionId;
    private final boolean isRollingSessionReceiver;
    private final Integer maxConcurrentSessions;
    private final boolean isSessionReceiver;
    private final Duration maxAutoLockRenewalDuration;

    ReceiverOptions(ReceiveMode receiveMode, int prefetchCount, Duration maxAutoLockRenewalDuration) {
        this.receiveMode = receiveMode;
        this.prefetchCount = prefetchCount;
        this.maxAutoLockRenewalDuration = maxAutoLockRenewalDuration;
        this.sessionId = null;
        this.isRollingSessionReceiver = false;
        this.maxConcurrentSessions = null;
        this.isSessionReceiver = false;
    }

    ReceiverOptions(ReceiveMode receiveMode, int prefetchCount, Duration maxAutoLockRenewalDuration, String sessionId, boolean isRollingSessionReceiver, Integer maxConcurrentSessions) {
        this.receiveMode = receiveMode;
        this.prefetchCount = prefetchCount;
        this.maxAutoLockRenewalDuration = maxAutoLockRenewalDuration;
        this.sessionId = sessionId;
        this.isRollingSessionReceiver = isRollingSessionReceiver;
        this.maxConcurrentSessions = maxConcurrentSessions;
        this.isSessionReceiver = true;
    }

    boolean autoLockRenewalEnabled() {
        return this.maxAutoLockRenewalDuration != null && this.maxAutoLockRenewalDuration != Duration.ZERO;
    }

    ReceiveMode getReceiveMode() {
        return this.receiveMode;
    }

    String getSessionId() {
        return this.sessionId;
    }

    int getPrefetchCount() {
        return this.prefetchCount;
    }

    boolean isSessionReceiver() {
        return this.isSessionReceiver;
    }

    public boolean isRollingSessionReceiver() {
        return this.isRollingSessionReceiver;
    }

    public Integer getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public Duration getMaxAutoLockRenewalDuration() {
        return this.maxAutoLockRenewalDuration;
    }
}

