/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.CbsAuthorizationType;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusMessageSerializer;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.UnnamedSessionManager;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusAmqpConnection;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusReactorAmqpConnection;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import com.azure.messaging.servicebus.models.ReceiveMode;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@ServiceClientBuilder(serviceClients={ServiceBusReceiverAsyncClient.class, ServiceBusSenderAsyncClient.class, ServiceBusSenderClient.class, ServiceBusReceiverClient.class})
public final class ServiceBusClientBuilder {
    private static final String AZURE_SERVICE_BUS_CONNECTION_STRING = "AZURE_SERVICE_BUS_CONNECTION_STRING";
    private static final AmqpRetryOptions DEFAULT_RETRY = new AmqpRetryOptions().setTryTimeout(ServiceBusConstants.OPERATION_TIMEOUT);
    private static final String SERVICE_BUS_PROPERTIES_FILE = "azure-messaging-servicebus.properties";
    private static final String SUBSCRIPTION_ENTITY_PATH_FORMAT = "%s/subscriptions/%s";
    private static final int DEFAULT_PREFETCH_COUNT = 1;
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN = "UNKNOWN";
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("^[^:]+:\\d+");
    private final Object connectionLock = new Object();
    private final ClientLogger logger = new ClientLogger(ServiceBusClientBuilder.class);
    private final MessageSerializer messageSerializer = new ServiceBusMessageSerializer();
    private final TracerProvider tracerProvider = new TracerProvider(ServiceLoader.load(Tracer.class));
    private Configuration configuration;
    private ServiceBusConnectionProcessor sharedConnection;
    private String connectionStringEntityName;
    private TokenCredential credentials;
    private String fullyQualifiedNamespace;
    private ProxyOptions proxyOptions;
    private AmqpRetryOptions retryOptions;
    private Scheduler scheduler;
    private AmqpTransportType transport = AmqpTransportType.AMQP;
    private final AtomicInteger openClients = new AtomicInteger();

    public ServiceBusClientBuilder connectionString(String connectionString) {
        ServiceBusSharedKeyCredential tokenCredential;
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        try {
            tokenCredential = new ServiceBusSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ServiceBusConstants.TOKEN_VALIDITY);
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Could not create the ServiceBusSharedKeyCredential.", (Throwable)e));
        }
        this.fullyQualifiedNamespace = properties.getEndpoint().getHost();
        if (properties.getEntityPath() != null && !properties.getEntityPath().isEmpty()) {
            this.logger.info("Setting 'entityName' [{}] from connectionString.", new Object[]{properties.getEntityPath()});
            this.connectionStringEntityName = properties.getEntityPath();
        }
        return this.credential(properties.getEndpoint().getHost(), tokenCredential);
    }

    public ServiceBusClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, TokenCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    public ServiceBusClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ServiceBusClientBuilder retryOptions(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    ServiceBusClientBuilder scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ServiceBusClientBuilder transportType(AmqpTransportType transportType) {
        this.transport = transportType;
        return this;
    }

    public ServiceBusSenderClientBuilder sender() {
        return new ServiceBusSenderClientBuilder();
    }

    public ServiceBusReceiverClientBuilder receiver() {
        return new ServiceBusReceiverClientBuilder();
    }

    public ServiceBusSessionReceiverClientBuilder sessionReceiver() {
        return new ServiceBusSessionReceiverClientBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientClose() {
        Object object = this.connectionLock;
        synchronized (object) {
            int numberOfOpenClients = this.openClients.decrementAndGet();
            this.logger.info("Closing a dependent client. # of open clients: {}", new Object[]{numberOfOpenClients});
            if (numberOfOpenClients > 0) {
                return;
            }
            if (numberOfOpenClients < 0) {
                this.logger.warning("There should not be less than 0 clients. actual: {}", new Object[]{numberOfOpenClients});
            }
            this.logger.info("No more open clients, closing shared connection.");
            if (this.sharedConnection != null) {
                this.sharedConnection.dispose();
                this.sharedConnection = null;
            } else {
                this.logger.warning("Shared ServiceBusConnectionProcessor was already disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBusConnectionProcessor getOrCreateConnectionProcessor(MessageSerializer serializer) {
        if (this.retryOptions == null) {
            this.retryOptions = DEFAULT_RETRY;
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.elastic();
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.sharedConnection == null) {
                ConnectionOptions connectionOptions = this.getConnectionOptions();
                AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), "https://servicebus.azure.net/.default");
                ReactorProvider provider = new ReactorProvider();
                ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider);
                Map properties = CoreUtils.getProperties((String)SERVICE_BUS_PROPERTIES_FILE);
                String product = properties.getOrDefault(NAME_KEY, UNKNOWN);
                String clientVersion = properties.getOrDefault(VERSION_KEY, UNKNOWN);
                Flux connectionFlux = Mono.fromCallable(() -> ServiceBusClientBuilder.lambda$getOrCreateConnectionProcessor$0(connectionOptions, provider, handlerProvider, (TokenManagerProvider)tokenManagerProvider, serializer, product, clientVersion)).repeat();
                this.sharedConnection = (ServiceBusConnectionProcessor)connectionFlux.subscribeWith((Subscriber)new ServiceBusConnectionProcessor(connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getRetry()));
            }
        }
        int numberOfOpenClients = this.openClients.incrementAndGet();
        this.logger.info("# of open clients with shared connection: {}", new Object[]{numberOfOpenClients});
        return this.sharedConnection;
    }

    private ConnectionOptions getConnectionOptions() {
        Configuration configuration = this.configuration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        if (this.credentials == null) {
            String connectionString = this.configuration.get(AZURE_SERVICE_BUS_CONNECTION_STRING);
            if (CoreUtils.isNullOrEmpty((CharSequence)connectionString)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials have not been set. They can be set using: connectionString(String), connectionString(String, String), credentials(String, String, TokenCredential), or setting the environment variable 'AZURE_SERVICE_BUS_CONNECTION_STRING' with a connection string"));
            }
            this.connectionString(connectionString);
        }
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured() && this.transport != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot use a proxy when TransportType is not AMQP."));
        }
        if (this.proxyOptions == null) {
            this.proxyOptions = this.getDefaultProxyConfiguration(this.configuration);
        }
        CbsAuthorizationType authorizationType = this.credentials instanceof ServiceBusSharedKeyCredential ? CbsAuthorizationType.SHARED_ACCESS_SIGNATURE : CbsAuthorizationType.JSON_WEB_TOKEN;
        return new ConnectionOptions(this.fullyQualifiedNamespace, this.credentials, authorizationType, this.transport, this.retryOptions, this.proxyOptions, this.scheduler);
    }

    private ProxyOptions getDefaultProxyConfiguration(Configuration configuration) {
        String proxyAddress;
        ProxyAuthenticationType authentication = ProxyAuthenticationType.NONE;
        if (this.proxyOptions != null) {
            authentication = this.proxyOptions.getAuthentication();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)(proxyAddress = configuration.get("HTTP_PROXY")))) {
            return ProxyOptions.SYSTEM_DEFAULTS;
        }
        return this.getProxyOptions(authentication, proxyAddress);
    }

    private ProxyOptions getProxyOptions(ProxyAuthenticationType authentication, String proxyAddress) {
        if (HOST_PORT_PATTERN.matcher(proxyAddress.trim()).find()) {
            String[] hostPort = proxyAddress.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            String username = this.configuration.get("PROXY_USERNAME");
            String password = this.configuration.get("PROXY_PASSWORD");
            return new ProxyOptions(authentication, proxy, username, password);
        }
        com.azure.core.http.ProxyOptions coreProxyOptions = com.azure.core.http.ProxyOptions.fromConfiguration((Configuration)this.configuration);
        return new ProxyOptions(authentication, new Proxy(coreProxyOptions.getType().toProxyType(), coreProxyOptions.getAddress()), coreProxyOptions.getUsername(), coreProxyOptions.getPassword());
    }

    private static boolean isNullOrEmpty(String item) {
        return item == null || item.isEmpty();
    }

    private static MessagingEntityType validateEntityPaths(ClientLogger logger, String connectionStringEntityName, String topicName, String queueName) {
        MessagingEntityType entityType;
        boolean hasConnectionStringEntity;
        boolean hasTopicName = !ServiceBusClientBuilder.isNullOrEmpty(topicName);
        boolean hasQueueName = !ServiceBusClientBuilder.isNullOrEmpty(queueName);
        boolean bl = hasConnectionStringEntity = !ServiceBusClientBuilder.isNullOrEmpty(connectionStringEntityName);
        if (!(hasConnectionStringEntity || hasQueueName || hasTopicName)) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot build client without setting either a queueName or topicName."));
        }
        if (hasQueueName && hasTopicName) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Cannot build client with both queueName (%s) and topicName (%s) set.", queueName, topicName)));
        }
        if (hasQueueName) {
            if (hasConnectionStringEntity && !queueName.equals(connectionStringEntityName)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("queueName (%s) is different than the connectionString's EntityPath (%s).", queueName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.QUEUE;
        } else if (hasTopicName) {
            if (hasConnectionStringEntity && !topicName.equals(connectionStringEntityName)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) is different than the connectionString's EntityPath (%s).", topicName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.SUBSCRIPTION;
        } else {
            entityType = MessagingEntityType.UNKNOWN;
        }
        return entityType;
    }

    private static String getEntityPath(ClientLogger logger, MessagingEntityType entityType, String queueName, String topicName, String subscriptionName) {
        String entityPath;
        switch (entityType) {
            case QUEUE: {
                entityPath = queueName;
                break;
            }
            case SUBSCRIPTION: {
                if (ServiceBusClientBuilder.isNullOrEmpty(subscriptionName)) {
                    throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) must have a subscriptionName associated with it.", topicName)));
                }
                entityPath = String.format(Locale.ROOT, SUBSCRIPTION_ENTITY_PATH_FORMAT, topicName, subscriptionName);
                break;
            }
            default: {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
            }
        }
        return entityPath;
    }

    private static /* synthetic */ ServiceBusAmqpConnection lambda$getOrCreateConnectionProcessor$0(ConnectionOptions connectionOptions, ReactorProvider provider, ReactorHandlerProvider handlerProvider, TokenManagerProvider tokenManagerProvider, MessageSerializer serializer, String product, String clientVersion) throws Exception {
        String connectionId = StringUtil.getRandomString((String)"MF");
        return new ServiceBusReactorAmqpConnection(connectionId, connectionOptions, provider, handlerProvider, tokenManagerProvider, serializer, product, clientVersion);
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusReceiverClientBuilder {
        private int prefetchCount = 1;
        private String queueName;
        private ReceiveMode receiveMode = ReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewalDuration;

        private ServiceBusReceiverClientBuilder() {
        }

        public ServiceBusReceiverClientBuilder maxAutoLockRenewalDuration(Duration maxAutoLockRenewalDuration) {
            this.maxAutoLockRenewalDuration = maxAutoLockRenewalDuration;
            return this;
        }

        public ServiceBusReceiverClientBuilder prefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusReceiverClientBuilder receiveMode(ReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusReceiverAsyncClient buildAsyncClient() {
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.logger, ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(ServiceBusClientBuilder.this.logger, entityType, this.queueName, this.topicName, this.subscriptionName);
            if (this.prefetchCount < 1) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("prefetchCount (%s) cannot be less than 1.", this.prefetchCount)));
            }
            if (this.maxAutoLockRenewalDuration != null && this.maxAutoLockRenewalDuration.isNegative()) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("maxAutoLockRenewalDuration (%s) cannot be negative.", this.maxAutoLockRenewalDuration)));
            }
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            ReceiverOptions receiverOptions = new ReceiverOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewalDuration);
            return new ServiceBusReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, ServiceBusClientBuilder.this.tracerProvider, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose);
        }

        public ServiceBusReceiverClient buildClient() {
            return new ServiceBusReceiverClient(this.buildAsyncClient(), ServiceBusClientBuilder.this.retryOptions.getTryTimeout());
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusSessionReceiverClientBuilder {
        private Integer maxConcurrentSessions = null;
        private int prefetchCount = 1;
        private String queueName;
        private ReceiveMode receiveMode = ReceiveMode.PEEK_LOCK;
        private String sessionId;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewalDuration;

        private ServiceBusSessionReceiverClientBuilder() {
        }

        public ServiceBusSessionReceiverClientBuilder maxAutoLockRenewalDuration(Duration maxAutoLockRenewalDuration) {
            this.maxAutoLockRenewalDuration = maxAutoLockRenewalDuration;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder maxConcurrentSessions(int maxConcurrentSessions) {
            if (maxConcurrentSessions < 1) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("maxConcurrentSessions cannot be less than 1."));
            }
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder prefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder receiveMode(ReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusReceiverAsyncClient buildAsyncClient() {
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.logger, ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(ServiceBusClientBuilder.this.logger, entityType, this.queueName, this.topicName, this.subscriptionName);
            if (this.prefetchCount < 1) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("prefetchCount (%s) cannot be less than 1.", this.prefetchCount)));
            }
            if (this.maxAutoLockRenewalDuration != null && this.maxAutoLockRenewalDuration.isNegative()) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("maxAutoLockRenewalDuration (%s) cannot be negative.", this.maxAutoLockRenewalDuration)));
            }
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            ReceiverOptions receiverOptions = new ReceiverOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewalDuration, this.sessionId, this.isRollingSessionReceiver(), this.maxConcurrentSessions);
            if (CoreUtils.isNullOrEmpty((CharSequence)this.sessionId)) {
                UnnamedSessionManager sessionManager = new UnnamedSessionManager(entityPath, entityType, connectionProcessor, connectionProcessor.getRetryOptions().getTryTimeout(), ServiceBusClientBuilder.this.tracerProvider, ServiceBusClientBuilder.this.messageSerializer, receiverOptions);
                return new ServiceBusReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, ServiceBusClientBuilder.this.tracerProvider, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, sessionManager);
            }
            return new ServiceBusReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, ServiceBusClientBuilder.this.tracerProvider, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose);
        }

        public ServiceBusReceiverClient buildClient() {
            return new ServiceBusReceiverClient(this.buildAsyncClient(), ServiceBusClientBuilder.this.retryOptions.getTryTimeout());
        }

        private boolean isRollingSessionReceiver() {
            if (this.maxConcurrentSessions == null) {
                return false;
            }
            if (this.maxConcurrentSessions < 1) {
                throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Maximum number of concurrent sessions must be positive."));
            }
            return CoreUtils.isNullOrEmpty((CharSequence)this.sessionId);
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusSenderClient.class, ServiceBusSenderAsyncClient.class})
    public final class ServiceBusSenderClientBuilder {
        private String queueName;
        private String topicName;

        private ServiceBusSenderClientBuilder() {
        }

        public ServiceBusSenderClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSenderClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusSenderAsyncClient buildAsyncClient() {
            String entityName;
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.logger, ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            switch (entityType) {
                case QUEUE: {
                    entityName = this.queueName;
                    break;
                }
                case SUBSCRIPTION: {
                    entityName = this.topicName;
                    break;
                }
                case UNKNOWN: {
                    entityName = ServiceBusClientBuilder.this.connectionStringEntityName;
                    break;
                }
                default: {
                    throw ServiceBusClientBuilder.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
                }
            }
            return new ServiceBusSenderAsyncClient(entityName, entityType, connectionProcessor, ServiceBusClientBuilder.this.retryOptions, ServiceBusClientBuilder.this.tracerProvider, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose);
        }

        public ServiceBusSenderClient buildClient() {
            return new ServiceBusSenderClient(this.buildAsyncClient(), ServiceBusClientBuilder.this.retryOptions.getTryTimeout());
        }
    }
}

