/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.implementation.QueuesImpl;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.implementation.models.CreateQueueBodyContent;
import com.azure.messaging.servicebus.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementError;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.models.QueueDescription;
import com.azure.messaging.servicebus.models.QueueRuntimeInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ServiceBusManagementAsyncClient {
    private static final String SERVICE_BUS_TRACING_NAMESPACE_VALUE = "Microsoft.ServiceBus";
    private static final String CONTENT_TYPE = "application/xml";
    private static final String QUEUES_ENTITY_TYPE = "queues";
    private static final int NUMBER_OF_ELEMENTS = 10;
    private final ServiceBusManagementClientImpl managementClient;
    private final QueuesImpl queuesClient;
    private final ClientLogger logger = new ClientLogger(ServiceBusManagementAsyncClient.class);
    private final ServiceBusManagementSerializer serializer;

    ServiceBusManagementAsyncClient(ServiceBusManagementClientImpl managementClient, ServiceBusManagementSerializer serializer) {
        this.managementClient = Objects.requireNonNull(managementClient, "'managementClient' cannot be null.");
        this.queuesClient = managementClient.getQueues();
        this.serializer = serializer;
    }

    public Mono<QueueDescription> createQueue(QueueDescription queue) {
        return this.createQueueWithResponse(queue).map(Response::getValue);
    }

    public Mono<Response<QueueDescription>> createQueueWithResponse(QueueDescription queue) {
        return FluxUtil.withContext(context -> this.createQueueWithResponse(queue, (Context)context));
    }

    public Mono<Void> deleteQueue(String queueName) {
        return this.deleteQueueWithResponse(queueName).then();
    }

    public Mono<Response<Void>> deleteQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.deleteQueueWithResponse(queueName, (Context)context));
    }

    public Mono<QueueDescription> getQueue(String queueName) {
        return this.getQueueWithResponse(queueName).map(Response::getValue);
    }

    public Mono<Response<QueueDescription>> getQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueWithResponse(queueName, (Context)context));
    }

    public Mono<QueueRuntimeInfo> getQueueRuntimeInfo(String queueName) {
        return this.getQueueWithResponse(queueName).map(response -> new QueueRuntimeInfo((QueueDescription)response.getValue()));
    }

    public Mono<Response<QueueRuntimeInfo>> getQueueRuntimeInfoWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueRuntimeInfoWithResponse(queueName, (Context)context));
    }

    public PagedFlux<QueueDescription> listQueues() {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listQueuesFirstPage((Context)context)), token -> FluxUtil.withContext(context -> this.listQueuesNextPage((String)token, (Context)context)));
    }

    public Mono<QueueDescription> updateQueue(QueueDescription queue) {
        return this.updateQueueWithResponse(queue).map(Response::getValue);
    }

    public Mono<Response<QueueDescription>> updateQueueWithResponse(QueueDescription queue) {
        return FluxUtil.withContext(context -> this.updateQueueWithResponse(queue, (Context)context));
    }

    Mono<Response<QueueDescription>> createQueueWithResponse(QueueDescription queue, Context context) {
        if (queue == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        if (queue.getName() == null || queue.getName().isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queue.getName' cannot be null or empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(queue);
        CreateQueueBody createEntity = new CreateQueueBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.queuesClient.putWithResponseAsync(queue.getName(), createEntity, null, withTracing).onErrorMap(ServiceBusManagementAsyncClient::mapException).map(this::deserializeQueue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteQueueWithResponse(String queueName, Context context) {
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null"));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.queuesClient.deleteWithResponseAsync(queueName, withTracing).onErrorMap(ServiceBusManagementAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueRuntimeInfo>> getQueueRuntimeInfoWithResponse(String queueName, Context context) {
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null"));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.queuesClient.getWithResponseAsync(queueName, true, withTracing).onErrorMap(ServiceBusManagementAsyncClient::mapException).map(response -> {
                Response<QueueDescription> deserializeQueue = this.deserializeQueue((Response<Object>)response);
                QueueRuntimeInfo runtimeInfo = deserializeQueue.getValue() != null ? new QueueRuntimeInfo((QueueDescription)deserializeQueue.getValue()) : null;
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)runtimeInfo);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueDescription>> getQueueWithResponse(String queueName, Context context) {
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null"));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.queuesClient.getWithResponseAsync(queueName, true, withTracing).onErrorMap(ServiceBusManagementAsyncClient::mapException).map(this::deserializeQueue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PagedResponse<QueueDescription>> listQueuesFirstPage(Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.listQueues(0, 10, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<QueueDescription>> listQueuesNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
            int skip = Integer.parseInt(continuationToken);
            return this.listQueues(skip, 10, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<QueueDescription>> updateQueueWithResponse(QueueDescription queue, Context context) {
        if (queue == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        if (queue.getName() == null || queue.getName().isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queue.getName' cannot be null or empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(queue);
        CreateQueueBody createEntity = new CreateQueueBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)SERVICE_BUS_TRACING_NAMESPACE_VALUE);
        try {
            return this.queuesClient.putWithResponseAsync(queue.getName(), createEntity, "*", withTracing).onErrorMap(ServiceBusManagementAsyncClient::mapException).map(response -> this.deserializeQueue((Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private <T> T deserialize(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String contents = String.valueOf(object);
        if (contents.isEmpty()) {
            return null;
        }
        try {
            return this.serializer.deserialize(contents, clazz);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Exception while deserializing. Body: [%s]. Class: %s", contents, clazz), e));
        }
    }

    private <T> Response<T> deserialize(Response<Object> response, Class<T> clazz) {
        T deserialize = this.deserialize(response.getValue(), clazz);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), deserialize);
    }

    private Response<QueueDescription> deserializeQueue(Response<Object> response) {
        QueueDescriptionEntry entry = this.deserialize(response.getValue(), QueueDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        QueueDescription result = entry.getContent().getQueueDescription().setName(entry.getTitle().getTitle());
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private <TResult, TFeed> FeedPage<TResult> extractPage(Response<TFeed> response, List<TResult> entities, List<ResponseLink> responseLinks) throws MalformedURLException, UnsupportedEncodingException {
        Optional<ResponseLink> nextLink = responseLinks.stream().filter(link -> link.getRel().equalsIgnoreCase("next")).findFirst();
        if (!nextLink.isPresent()) {
            return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
        }
        URL url = new URL(nextLink.get().getHref());
        String decode = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.name());
        Optional<Integer> skipParameter = Arrays.stream(decode.split("&amp;|&")).map(part -> part.split("=", 2)).filter(parts -> parts[0].equalsIgnoreCase("$skip") && ((String[])parts).length == 2).map(parts -> Integer.valueOf(parts[1])).findFirst();
        if (skipParameter.isPresent()) {
            return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities, skipParameter.get());
        }
        this.logger.warning("There should have been a skip parameter for the next page.");
        return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
    }

    private Mono<PagedResponse<QueueDescription>> listQueues(int skip, int top, Context context) {
        return this.managementClient.listEntitiesWithResponseAsync(QUEUES_ENTITY_TYPE, skip, top, context).onErrorMap(ServiceBusManagementAsyncClient::mapException).flatMap(response -> {
            Response<QueueDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, QueueDescriptionFeed.class);
            QueueDescriptionFeed feed = (QueueDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                this.logger.warning("Could not deserialize QueueDescriptionFeed. skip {}, top: {}", new Object[]{skip, top});
                return Mono.empty();
            }
            List entities = feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getQueueDescription() != null).map(e -> {
                String queueName = e.getTitle().getTitle();
                return e.getContent().getQueueDescription().setName(queueName);
            }).collect(Collectors.toList());
            try {
                return Mono.just(this.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<QueueDescription>", error));
            }
        });
    }

    private static Throwable mapException(Throwable exception) {
        if (!(exception instanceof ServiceBusManagementErrorException)) {
            return exception;
        }
        ServiceBusManagementErrorException managementError = (ServiceBusManagementErrorException)((Object)exception);
        ServiceBusManagementError error = managementError.getValue();
        switch (error.getCode()) {
            case 401: {
                return new ClientAuthenticationException(error.getDetail(), managementError.getResponse(), exception);
            }
            case 404: {
                return new ResourceNotFoundException(error.getDetail(), managementError.getResponse(), exception);
            }
            case 409: {
                return new ResourceExistsException(error.getDetail(), managementError.getResponse(), exception);
            }
            case 412: {
                return new ResourceModifiedException(error.getDetail(), managementError.getResponse(), exception);
            }
        }
        return new HttpResponseException(error.getDetail(), managementError.getResponse(), exception);
    }

    private static final class FeedPage<T>
    implements PagedResponse<T> {
        private final int statusCode;
        private final HttpHeaders header;
        private final HttpRequest request;
        private final IterableStream<T> entries;
        private final String continuationToken;

        private FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = null;
        }

        private FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries, int skip) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = String.valueOf(skip);
        }

        public IterableStream<T> getElements() {
            return this.entries;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.header;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void close() {
        }
    }
}

