/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.messaging.servicebus.ServiceBusManagementAsyncClient;
import com.azure.messaging.servicebus.models.QueueDescription;
import com.azure.messaging.servicebus.models.QueueRuntimeInfo;
import java.util.Objects;

public final class ServiceBusManagementClient {
    private final ServiceBusManagementAsyncClient asyncClient;

    ServiceBusManagementClient(ServiceBusManagementAsyncClient asyncClient) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
    }

    public QueueDescription createQueue(QueueDescription queue) {
        return (QueueDescription)this.asyncClient.createQueue(queue).block();
    }

    public Response<QueueDescription> createQueueWithResponse(QueueDescription queue, Context context) {
        return (Response)this.asyncClient.createQueueWithResponse(queue, context).block();
    }

    public void deleteQueue(String queueName) {
        this.asyncClient.deleteQueue(queueName).block();
    }

    public Response<Void> deleteQueueWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.deleteQueueWithResponse(queueName, context).block();
    }

    public QueueDescription getQueue(String queueName) {
        return (QueueDescription)this.asyncClient.getQueue(queueName).block();
    }

    public Response<QueueDescription> getQueueWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.getQueueWithResponse(queueName, context).block();
    }

    public QueueRuntimeInfo getQueueRuntimeInfo(String queueName) {
        return (QueueRuntimeInfo)this.asyncClient.getQueueRuntimeInfo(queueName).block();
    }

    public Response<QueueRuntimeInfo> getQueueRuntimeInfoWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.getQueueRuntimeInfoWithResponse(queueName, context).block();
    }

    public PagedIterable<QueueDescription> listQueues() {
        return new PagedIterable(this.asyncClient.listQueues());
    }

    public PagedIterable<QueueDescription> listQueues(Context context) {
        PagedFlux pagedFlux = new PagedFlux(() -> this.asyncClient.listQueuesFirstPage(context), continuationToken -> this.asyncClient.listQueuesNextPage((String)continuationToken, context));
        return new PagedIterable(pagedFlux);
    }

    public QueueDescription updateQueue(QueueDescription queue) {
        return (QueueDescription)this.asyncClient.updateQueue(queue).block();
    }

    public Response<QueueDescription> updateQueueWithResponse(QueueDescription queue, Context context) {
        return (Response)this.asyncClient.updateQueueWithResponse(queue, context).block();
    }
}

