/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.Context;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ServiceBusMessage {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final byte[] body;
    private Context context;
    private String contentType;
    private String correlationId;
    private String label;
    private String messageId;
    private String partitionKey;
    private String replyTo;
    private String replyToSessionId;
    private Instant scheduledEnqueueTime;
    private String sessionId;
    private Duration timeToLive;
    private String to;
    private String viaPartitionKey;

    public ServiceBusMessage(String body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").getBytes(StandardCharsets.UTF_8));
    }

    public ServiceBusMessage(byte[] body) {
        this.body = Objects.requireNonNull(body, "'body' cannot be null.");
        this.context = Context.NONE;
    }

    public ServiceBusMessage(ServiceBusReceivedMessage receivedMessage) {
        this.body = receivedMessage.getBody();
        this.context = Context.NONE;
        this.setMessageId(receivedMessage.getMessageId());
        this.setScheduledEnqueueTime(receivedMessage.getScheduledEnqueueTime());
        this.setContentType(receivedMessage.getContentType());
        this.setCorrelationId(receivedMessage.getCorrelationId());
        this.setLabel(receivedMessage.getLabel());
        this.setPartitionKey(receivedMessage.getPartitionKey());
        this.setReplyTo(receivedMessage.getReplyTo());
        this.setReplyToSessionId(receivedMessage.getReplyToSessionId());
        this.setTimeToLive(receivedMessage.getTimeToLive());
        this.setTo(receivedMessage.getTo());
        this.setSessionId(receivedMessage.getSessionId());
        this.setViaPartitionKey(receivedMessage.getViaPartitionKey());
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServiceBusMessage setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public ServiceBusMessage setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public ServiceBusMessage setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public ServiceBusMessage setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public ServiceBusMessage setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public ServiceBusMessage setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public ServiceBusMessage setTo(String to) {
        this.to = to;
        return this;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public ServiceBusMessage setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public Instant getScheduledEnqueueTime() {
        return this.scheduledEnqueueTime;
    }

    public ServiceBusMessage setScheduledEnqueueTime(Instant scheduledEnqueueTime) {
        this.scheduledEnqueueTime = scheduledEnqueueTime;
        return this;
    }

    public String getReplyToSessionId() {
        return this.replyToSessionId;
    }

    public ServiceBusMessage setReplyToSessionId(String replyToSessionId) {
        this.replyToSessionId = replyToSessionId;
        return this;
    }

    public String getViaPartitionKey() {
        return this.viaPartitionKey;
    }

    public ServiceBusMessage setViaPartitionKey(String viaPartitionKey) {
        this.viaPartitionKey = viaPartitionKey;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ServiceBusMessage setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    Context getContext() {
        return this.context;
    }

    public ServiceBusMessage addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }
}

