/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.messaging.servicebus.ServiceBusMessage;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Signal;

public final class ServiceBusMessageBatch {
    private final ClientLogger logger = new ClientLogger(ServiceBusMessageBatch.class);
    private final Object lock = new Object();
    private final int maxMessageSize;
    private final ErrorContextProvider contextProvider;
    private final MessageSerializer serializer;
    private final List<ServiceBusMessage> serviceBusMessageList;
    private final byte[] eventBytes;
    private int sizeInBytes;
    private final TracerProvider tracerProvider;

    ServiceBusMessageBatch(int maxMessageSize, ErrorContextProvider contextProvider, TracerProvider tracerProvider, MessageSerializer serializer) {
        this.maxMessageSize = maxMessageSize;
        this.contextProvider = contextProvider;
        this.serializer = serializer;
        this.serviceBusMessageList = new LinkedList<ServiceBusMessage>();
        this.sizeInBytes = maxMessageSize / 65536 * 1024;
        this.eventBytes = new byte[maxMessageSize];
        this.tracerProvider = tracerProvider;
    }

    public int getCount() {
        return this.serviceBusMessageList.size();
    }

    public int getMaxSizeInBytes() {
        return this.maxMessageSize;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAdd(ServiceBusMessage serviceBusMessage) {
        int size;
        if (serviceBusMessage == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("message cannot be null"));
        }
        ServiceBusMessage serviceBusMessageUpdated = this.tracerProvider.isEnabled() ? this.traceMessageSpan(serviceBusMessage) : serviceBusMessage;
        try {
            size = this.getSize(serviceBusMessageUpdated, this.serviceBusMessageList.isEmpty());
        }
        catch (BufferOverflowException exception) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", this.maxMessageSize / 1024), this.contextProvider.getErrorContext()));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.sizeInBytes + size > this.maxMessageSize) {
                return false;
            }
            this.sizeInBytes += size;
        }
        this.serviceBusMessageList.add(serviceBusMessageUpdated);
        return true;
    }

    List<ServiceBusMessage> getMessages() {
        return this.serviceBusMessageList;
    }

    private ServiceBusMessage traceMessageSpan(ServiceBusMessage serviceBusMessage) {
        Optional eventContextData = serviceBusMessage.getContext().getData((Object)"span-context");
        if (eventContextData.isPresent()) {
            return serviceBusMessage;
        }
        Context eventSpanContext = this.tracerProvider.startSpan(serviceBusMessage.getContext(), ProcessKind.MESSAGE);
        Optional eventDiagnosticIdOptional = eventSpanContext.getData((Object)"diagnostic-id");
        if (eventDiagnosticIdOptional.isPresent()) {
            serviceBusMessage.getProperties().put("diagnostic-id", eventDiagnosticIdOptional.get().toString());
            this.tracerProvider.endSpan(eventSpanContext, Signal.complete());
            serviceBusMessage.addContext("span-context", eventSpanContext);
        }
        return serviceBusMessage;
    }

    private int getSize(ServiceBusMessage serviceBusMessage, boolean isFirst) {
        Objects.requireNonNull(serviceBusMessage, "'serviceBusMessage' cannot be null.");
        Message amqpMessage = this.serializer.serialize((Object)serviceBusMessage);
        int eventSize = amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        }
        return eventSize;
    }
}

