/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.exception.AmqpResponseCode;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RequestResponseUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.MessageWithLockToken;
import com.azure.messaging.servicebus.implementation.Messages;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.message.Message;

class ServiceBusMessageSerializer
implements MessageSerializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String ENQUEUED_TIME_UTC_NAME = "x-opt-enqueued-time";
    private static final String SCHEDULED_ENQUEUE_TIME_NAME = "x-opt-scheduled-enqueue-time";
    private static final String SEQUENCE_NUMBER_NAME = "x-opt-sequence-number";
    private static final String LOCKED_UNTIL_NAME = "x-opt-locked-until";
    private static final String PARTITION_KEY_NAME = "x-opt-partition-key";
    private static final String VIA_PARTITION_KEY_NAME = "x-opt-via-partition-key";
    private static final String DEAD_LETTER_SOURCE_NAME = "x-opt-deadletter-source";
    private static final String DEAD_LETTER_DESCRIPTION = "DeadLetterErrorDescription";
    private static final String DEAD_LETTER_REASON = "DeadLetterReason";
    private static final String ENQUEUED_SEQUENCE_NUMBER = "x-opt-enqueue-sequence-number";
    private final ClientLogger logger = new ClientLogger(ServiceBusMessageSerializer.class);

    ServiceBusMessageSerializer() {
    }

    public int getSize(Message amqpMessage) {
        int size;
        Map map;
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = ServiceBusMessageSerializer.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            map = messageAnnotations.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = ServiceBusMessageSerializer.sizeof(entry.getKey()) + ServiceBusMessageSerializer.sizeof(entry.getValue());
                annotationsSize += size;
            }
        }
        if (applicationProperties != null) {
            map = applicationProperties.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = ServiceBusMessageSerializer.sizeof(entry.getKey()) + ServiceBusMessageSerializer.sizeof(entry.getValue());
                applicationPropertiesSize += size;
            }
        }
        return annotationsSize + applicationPropertiesSize + payloadSize;
    }

    public <T> Message serialize(T object) {
        String viaPartitionKey;
        String partitionKey;
        Objects.requireNonNull(object, "'object' to serialize cannot be null.");
        if (!(object instanceof ServiceBusMessage)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot serialize object that is not ServiceBusMessage. Clazz: " + object.getClass()));
        }
        ServiceBusMessage brokeredMessage = (ServiceBusMessage)object;
        Message amqpMessage = Proton.message();
        byte[] body = brokeredMessage.getBody();
        amqpMessage.setBody((Section)new Data(new Binary(body)));
        if (brokeredMessage.getProperties() != null) {
            amqpMessage.setApplicationProperties(new ApplicationProperties(brokeredMessage.getProperties()));
        }
        if (brokeredMessage.getTimeToLive() != null) {
            amqpMessage.setTtl(brokeredMessage.getTimeToLive().toMillis());
        }
        if (amqpMessage.getProperties() == null) {
            amqpMessage.setProperties(new Properties());
        }
        amqpMessage.setMessageId((Object)brokeredMessage.getMessageId());
        amqpMessage.setContentType(brokeredMessage.getContentType());
        amqpMessage.setCorrelationId((Object)brokeredMessage.getCorrelationId());
        amqpMessage.setSubject(brokeredMessage.getLabel());
        amqpMessage.getProperties().setTo(brokeredMessage.getTo());
        amqpMessage.setReplyTo(brokeredMessage.getReplyTo());
        amqpMessage.setReplyToGroupId(brokeredMessage.getReplyToSessionId());
        amqpMessage.setGroupId(brokeredMessage.getSessionId());
        HashMap<Symbol, Object> messageAnnotationsMap = new HashMap<Symbol, Object>();
        if (brokeredMessage.getScheduledEnqueueTime() != null) {
            messageAnnotationsMap.put(Symbol.valueOf((String)SCHEDULED_ENQUEUE_TIME_NAME), Date.from(brokeredMessage.getScheduledEnqueueTime()));
        }
        if ((partitionKey = brokeredMessage.getPartitionKey()) != null && !partitionKey.isEmpty()) {
            messageAnnotationsMap.put(Symbol.valueOf((String)PARTITION_KEY_NAME), brokeredMessage.getPartitionKey());
        }
        if ((viaPartitionKey = brokeredMessage.getViaPartitionKey()) != null && !viaPartitionKey.isEmpty()) {
            messageAnnotationsMap.put(Symbol.valueOf((String)VIA_PARTITION_KEY_NAME), viaPartitionKey);
        }
        amqpMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotationsMap));
        return amqpMessage;
    }

    public <T> T deserialize(Message message, Class<T> clazz) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz == ServiceBusReceivedMessage.class) {
            return (T)this.deserializeMessage(message);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, clazz)));
    }

    public <T> List<T> deserializeList(Message message, Class<T> clazz) {
        if (clazz == ServiceBusReceivedMessage.class) {
            return this.deserializeListOfMessages(message);
        }
        if (clazz == Instant.class) {
            return this.deserializeListOfInstant(message);
        }
        if (clazz == Long.class) {
            return this.deserializeListOfLong(message);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, clazz)));
    }

    private List<Long> deserializeListOfLong(Message amqpMessage) {
        Map responseBody;
        Object expirationListObj;
        AmqpValue amqpValue;
        if (amqpMessage.getBody() instanceof AmqpValue && (amqpValue = (AmqpValue)amqpMessage.getBody()).getValue() instanceof Map && (expirationListObj = (responseBody = (Map)amqpValue.getValue()).get("sequence-numbers")) instanceof long[]) {
            return Arrays.stream((long[])expirationListObj).boxed().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Instant> deserializeListOfInstant(Message amqpMessage) {
        Map responseBody;
        Object expirationListObj;
        AmqpValue amqpValue;
        if (amqpMessage.getBody() instanceof AmqpValue && (amqpValue = (AmqpValue)amqpMessage.getBody()).getValue() instanceof Map && (expirationListObj = (responseBody = (Map)amqpValue.getValue()).get("expirations")) instanceof Date[]) {
            return Arrays.stream((Date[])expirationListObj).map(Date::toInstant).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<ServiceBusReceivedMessage> deserializeListOfMessages(Message amqpMessage) {
        ArrayList<ServiceBusReceivedMessage> messageList = new ArrayList<ServiceBusReceivedMessage>();
        AmqpResponseCode statusCode = RequestResponseUtils.getStatusCode((Message)amqpMessage);
        if (statusCode != AmqpResponseCode.OK) {
            this.logger.warning("AMQP response did not contain OK status code. Actual: {}", new Object[]{statusCode});
            return Collections.emptyList();
        }
        Object responseBodyMap = ((AmqpValue)amqpMessage.getBody()).getValue();
        if (responseBodyMap == null) {
            this.logger.warning("AMQP response did not contain a body.");
            return Collections.emptyList();
        }
        if (!(responseBodyMap instanceof Map)) {
            this.logger.warning("AMQP response body is not correct instance. Expected: {}. Actual: {}", new Object[]{Map.class, responseBodyMap.getClass()});
            return Collections.emptyList();
        }
        Object messages = ((Map)responseBodyMap).get("messages");
        if (messages == null) {
            this.logger.warning("Response body did not contain key: {}", new Object[]{"messages"});
            return Collections.emptyList();
        }
        if (!(messages instanceof Iterable)) {
            this.logger.warning("Response body contents is not the correct type. Expected: {}. Actual: {}", new Object[]{Iterable.class, messages.getClass()});
            return Collections.emptyList();
        }
        for (Object message : (Iterable)messages) {
            if (!(message instanceof Map)) {
                this.logger.warning("Message inside iterable of message is not correct type. Expected: {}. Actual: {}", new Object[]{Map.class, message.getClass()});
                continue;
            }
            Message responseMessage = Message.Factory.create();
            Binary messagePayLoad = (Binary)((Map)message).get("message");
            responseMessage.decode(messagePayLoad.getArray(), messagePayLoad.getArrayOffset(), messagePayLoad.getLength());
            ServiceBusReceivedMessage receivedMessage = this.deserializeMessage(responseMessage);
            if (((Map)message).containsKey("lock-token")) {
                receivedMessage.setLockToken((UUID)((Map)message).get("lock-token"));
            }
            messageList.add(receivedMessage);
        }
        return messageList;
    }

    private ServiceBusReceivedMessage deserializeMessage(Message amqpMessage) {
        Map messageAnnotationsMap;
        Properties properties;
        ServiceBusReceivedMessage brokeredMessage;
        Section body = amqpMessage.getBody();
        if (body != null) {
            if (body instanceof Data) {
                Binary messageData = ((Data)body).getValue();
                byte[] bytes = messageData.getArray();
                brokeredMessage = new ServiceBusReceivedMessage(bytes);
            } else {
                this.logger.warning(String.format(Messages.MESSAGE_NOT_OF_TYPE, body.getType()));
                brokeredMessage = new ServiceBusReceivedMessage(EMPTY_BYTE_ARRAY);
            }
        } else {
            this.logger.warning(String.format(Messages.MESSAGE_NOT_OF_TYPE, "null"));
            brokeredMessage = new ServiceBusReceivedMessage(EMPTY_BYTE_ARRAY);
        }
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        if (applicationProperties != null) {
            Map propertiesValue = applicationProperties.getValue();
            brokeredMessage.getProperties().putAll(propertiesValue);
            if (propertiesValue.containsKey(DEAD_LETTER_REASON)) {
                brokeredMessage.setDeadLetterReason(String.valueOf(propertiesValue.get(DEAD_LETTER_REASON)));
            }
            if (propertiesValue.containsKey(DEAD_LETTER_DESCRIPTION)) {
                brokeredMessage.setDeadLetterDescription(String.valueOf(propertiesValue.get(DEAD_LETTER_DESCRIPTION)));
            }
        }
        brokeredMessage.setTimeToLive(Duration.ofMillis(amqpMessage.getTtl()));
        brokeredMessage.setDeliveryCount(amqpMessage.getDeliveryCount());
        Object messageId = amqpMessage.getMessageId();
        if (messageId != null) {
            brokeredMessage.setMessageId(messageId.toString());
        }
        brokeredMessage.setContentType(amqpMessage.getContentType());
        Object correlationId = amqpMessage.getCorrelationId();
        if (correlationId != null) {
            brokeredMessage.setCorrelationId(correlationId.toString());
        }
        if ((properties = amqpMessage.getProperties()) != null) {
            brokeredMessage.setTo(properties.getTo());
        }
        brokeredMessage.setLabel(amqpMessage.getSubject());
        brokeredMessage.setReplyTo(amqpMessage.getReplyTo());
        brokeredMessage.setReplyToSessionId(amqpMessage.getReplyToGroupId());
        brokeredMessage.setSessionId(amqpMessage.getGroupId());
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        if (messageAnnotations != null && (messageAnnotationsMap = messageAnnotations.getValue()) != null) {
            block20: for (Map.Entry entry : messageAnnotationsMap.entrySet()) {
                String key = ((Symbol)entry.getKey()).toString();
                Object value = entry.getValue();
                switch (key) {
                    case "x-opt-enqueued-time": {
                        brokeredMessage.setEnqueuedTime(((Date)value).toInstant());
                        continue block20;
                    }
                    case "x-opt-scheduled-enqueue-time": {
                        brokeredMessage.setScheduledEnqueueTime(((Date)value).toInstant());
                        continue block20;
                    }
                    case "x-opt-sequence-number": {
                        brokeredMessage.setSequenceNumber((Long)value);
                        continue block20;
                    }
                    case "x-opt-locked-until": {
                        brokeredMessage.setLockedUntil(((Date)value).toInstant());
                        continue block20;
                    }
                    case "x-opt-partition-key": {
                        brokeredMessage.setPartitionKey((String)value);
                        continue block20;
                    }
                    case "x-opt-via-partition-key": {
                        brokeredMessage.setViaPartitionKey((String)value);
                        continue block20;
                    }
                    case "x-opt-deadletter-source": {
                        brokeredMessage.setDeadLetterSource((String)value);
                        continue block20;
                    }
                    case "x-opt-enqueue-sequence-number": {
                        continue block20;
                    }
                }
                this.logger.info("Unrecognised key: {}, value: {}", new Object[]{key, value});
            }
        }
        if (amqpMessage instanceof MessageWithLockToken) {
            brokeredMessage.setLockToken(((MessageWithLockToken)amqpMessage).getLockToken());
        }
        return brokeredMessage;
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        Section bodySection = msg.getBody();
        if (bodySection instanceof AmqpValue) {
            return ServiceBusMessageSerializer.sizeof(((AmqpValue)bodySection).getValue());
        }
        if (bodySection instanceof AmqpSequence) {
            return ServiceBusMessageSerializer.sizeof(((AmqpSequence)bodySection).getValue());
        }
        if (bodySection instanceof Data) {
            Data payloadSection = (Data)bodySection;
            Binary payloadBytes = payloadSection.getValue();
            return ServiceBusMessageSerializer.sizeof(payloadBytes);
        }
        return 0;
    }

    private static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return obj.toString().length() << 1;
        }
        if (obj instanceof Symbol) {
            return ((Symbol)obj).length() << 1;
        }
        if (obj instanceof Byte || obj instanceof UnsignedByte) {
            return 1;
        }
        if (obj instanceof Integer || obj instanceof UnsignedInteger) {
            return 4;
        }
        if (obj instanceof Long || obj instanceof UnsignedLong || obj instanceof Date) {
            return 8;
        }
        if (obj instanceof Short || obj instanceof UnsignedShort) {
            return 2;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Character) {
            return 4;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof UUID) {
            return 16;
        }
        if (obj instanceof Decimal32) {
            return 4;
        }
        if (obj instanceof Decimal64) {
            return 8;
        }
        if (obj instanceof Decimal128) {
            return 16;
        }
        if (obj instanceof Binary) {
            return ((Binary)obj).getLength();
        }
        if (obj instanceof Declare) {
            return 7;
        }
        if (obj instanceof Discharge) {
            Discharge discharge = (Discharge)obj;
            return 12 + discharge.getTxnId().getLength();
        }
        if (obj instanceof Map) {
            int size = 8;
            Map map = (Map)obj;
            for (Object value : map.keySet()) {
                size += ServiceBusMessageSerializer.sizeof(value);
            }
            for (Object value : map.values()) {
                size += ServiceBusMessageSerializer.sizeof(value);
            }
            return size;
        }
        if (obj instanceof Iterable) {
            int size = 8;
            for (Object innerObject : (Iterable)obj) {
                size += ServiceBusMessageSerializer.sizeof(innerObject);
            }
            return size;
        }
        if (obj.getClass().isArray()) {
            int size = 8;
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                size += ServiceBusMessageSerializer.sizeof(Array.get(obj, i));
            }
            return size;
        }
        throw new IllegalArgumentException(String.format(Locale.US, "Encoding Type: %s is not supported", obj.getClass()));
    }
}

