/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.MessageLockToken;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ServiceBusReceivedMessage
implements MessageLockToken {
    private UUID lockToken;
    private long sequenceNumber;
    private long deliveryCount;
    private Instant enqueuedTime;
    private Instant lockedUntil;
    private String deadLetterSource;
    private final Map<String, Object> properties;
    private final byte[] body;
    private String contentType;
    private String correlationId;
    private String label;
    private String messageId;
    private String partitionKey;
    private String replyTo;
    private String replyToSessionId;
    private Instant scheduledEnqueueTime;
    private String sessionId;
    private Duration timeToLive;
    private String to;
    private String viaPartitionKey;
    private String deadLetterReason;
    private String deadLetterDescription;

    ServiceBusReceivedMessage(byte[] body) {
        this.body = Objects.requireNonNull(body, "'body' cannot be null.");
        this.properties = new HashMap<String, Object>();
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getDeadLetterDescription() {
        return this.deadLetterDescription;
    }

    public String getDeadLetterReason() {
        return this.deadLetterReason;
    }

    public String getDeadLetterSource() {
        return this.deadLetterSource;
    }

    public long getDeliveryCount() {
        return this.deliveryCount;
    }

    public Instant getEnqueuedTime() {
        return this.enqueuedTime;
    }

    public Instant getExpiresAt() {
        Duration timeToLive = this.getTimeToLive();
        return this.enqueuedTime != null && timeToLive != null ? this.enqueuedTime.plus(timeToLive) : null;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLockToken() {
        return this.lockToken.toString();
    }

    public Instant getLockedUntil() {
        return this.lockedUntil;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getReplyToSessionId() {
        return this.replyToSessionId;
    }

    public Instant getScheduledEnqueueTime() {
        return this.scheduledEnqueueTime;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public String getTo() {
        return this.to;
    }

    public String getViaPartitionKey() {
        return this.viaPartitionKey;
    }

    void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    void setDeadLetterDescription(String deadLetterDescription) {
        this.deadLetterDescription = deadLetterDescription;
    }

    void setDeadLetterReason(String deadLetterReason) {
        this.deadLetterReason = deadLetterReason;
    }

    void setDeadLetterSource(String deadLetterSource) {
        this.deadLetterSource = deadLetterSource;
    }

    void setDeliveryCount(long deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    void setEnqueuedTime(Instant enqueuedTime) {
        this.enqueuedTime = enqueuedTime;
    }

    void setLabel(String label) {
        this.label = label;
    }

    void setLockToken(UUID lockToken) {
        this.lockToken = lockToken;
    }

    void setLockedUntil(Instant lockedUntil) {
        this.lockedUntil = lockedUntil;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    void setScheduledEnqueueTime(Instant scheduledEnqueueTime) {
        this.scheduledEnqueueTime = scheduledEnqueueTime;
    }

    void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    void setReplyToSessionId(String replyToSessionId) {
        this.replyToSessionId = replyToSessionId;
    }

    void setTo(String to) {
        this.to = to;
    }

    void setViaPartitionKey(String viaPartitionKey) {
        this.viaPartitionKey = viaPartitionKey;
    }
}

