/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.MessageLockToken;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.SynchronousMessageSubscriber;
import com.azure.messaging.servicebus.SynchronousReceiveWork;
import com.azure.messaging.servicebus.models.DeadLetterOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public final class ServiceBusReceiverClient
implements AutoCloseable {
    private final ClientLogger logger = new ClientLogger(ServiceBusReceiverClient.class);
    private final AtomicInteger idGenerator = new AtomicInteger();
    private final ServiceBusReceiverAsyncClient asyncClient;
    private final Duration operationTimeout;
    private final AtomicReference<SynchronousMessageSubscriber> synchronousMessageSubscriber = new AtomicReference();

    ServiceBusReceiverClient(ServiceBusReceiverAsyncClient asyncClient, Duration operationTimeout) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.operationTimeout = Objects.requireNonNull(operationTimeout, "'operationTimeout' cannot be null.");
    }

    public String getFullyQualifiedNamespace() {
        return this.asyncClient.getFullyQualifiedNamespace();
    }

    public String getEntityPath() {
        return this.asyncClient.getEntityPath();
    }

    public void abandon(MessageLockToken lockToken) {
        this.asyncClient.abandon(lockToken).block(this.operationTimeout);
    }

    public void abandon(MessageLockToken lockToken, Map<String, Object> propertiesToModify) {
        this.asyncClient.abandon(lockToken, propertiesToModify).block(this.operationTimeout);
    }

    public void abandon(MessageLockToken lockToken, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.abandon(lockToken, propertiesToModify, transactionContext).block(this.operationTimeout);
    }

    public void abandon(MessageLockToken lockToken, Map<String, Object> propertiesToModify, String sessionId) {
        this.asyncClient.abandon(lockToken, propertiesToModify, sessionId).block(this.operationTimeout);
    }

    public void abandon(MessageLockToken lockToken, Map<String, Object> propertiesToModify, String sessionId, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.abandon(lockToken, propertiesToModify, sessionId, transactionContext).block(this.operationTimeout);
    }

    public void complete(MessageLockToken lockToken) {
        this.asyncClient.complete(lockToken).block(this.operationTimeout);
    }

    public void complete(MessageLockToken lockToken, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.complete(lockToken, transactionContext).block(this.operationTimeout);
    }

    public void complete(MessageLockToken lockToken, String sessionId) {
        this.asyncClient.complete(lockToken, sessionId).block(this.operationTimeout);
    }

    public void complete(MessageLockToken lockToken, String sessionId, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.complete(lockToken, sessionId, transactionContext).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken) {
        this.asyncClient.defer(lockToken).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken, String sessionId) {
        this.asyncClient.defer(lockToken, sessionId).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken, Map<String, Object> propertiesToModify) {
        this.asyncClient.defer(lockToken, propertiesToModify).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.defer(lockToken, propertiesToModify, transactionContext).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken, Map<String, Object> propertiesToModify, String sessionId) {
        this.asyncClient.defer(lockToken, propertiesToModify, sessionId).block(this.operationTimeout);
    }

    public void defer(MessageLockToken lockToken, Map<String, Object> propertiesToModify, String sessionId, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.defer(lockToken, propertiesToModify, sessionId, transactionContext).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken) {
        this.asyncClient.deadLetter(lockToken).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken, String sessionId) {
        this.asyncClient.deadLetter(lockToken, sessionId).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken, DeadLetterOptions deadLetterOptions) {
        this.asyncClient.deadLetter(lockToken, deadLetterOptions).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken, DeadLetterOptions deadLetterOptions, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.deadLetter(lockToken, deadLetterOptions, transactionContext).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken, DeadLetterOptions deadLetterOptions, String sessionId) {
        this.asyncClient.deadLetter(lockToken, deadLetterOptions, sessionId).block(this.operationTimeout);
    }

    public void deadLetter(MessageLockToken lockToken, DeadLetterOptions deadLetterOptions, String sessionId, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.deadLetter(lockToken, deadLetterOptions, sessionId, transactionContext).block(this.operationTimeout);
    }

    public byte[] getSessionState(String sessionId) {
        return (byte[])this.asyncClient.getSessionState(sessionId).block(this.operationTimeout);
    }

    public ServiceBusReceivedMessage peek() {
        return (ServiceBusReceivedMessage)this.asyncClient.peek().block(this.operationTimeout);
    }

    public ServiceBusReceivedMessage peek(String sessionId) {
        return (ServiceBusReceivedMessage)this.asyncClient.peek(sessionId).block(this.operationTimeout);
    }

    public ServiceBusReceivedMessage peekAt(long sequenceNumber) {
        return (ServiceBusReceivedMessage)this.asyncClient.peekAt(sequenceNumber).block(this.operationTimeout);
    }

    public ServiceBusReceivedMessage peekAt(long sequenceNumber, String sessionId) {
        return (ServiceBusReceivedMessage)this.asyncClient.peekAt(sequenceNumber, sessionId).block(this.operationTimeout);
    }

    public IterableStream<ServiceBusReceivedMessage> peekBatch(int maxMessages) {
        if (maxMessages <= 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxMessages' cannot be less than or equal to 0. maxMessages: " + maxMessages));
        }
        Flux messages = this.asyncClient.peekBatch(maxMessages).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public IterableStream<ServiceBusReceivedMessage> peekBatch(int maxMessages, String sessionId) {
        if (maxMessages <= 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxMessages' cannot be less than or equal to 0. maxMessages: " + maxMessages));
        }
        Flux messages = this.asyncClient.peekBatch(maxMessages, sessionId).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public IterableStream<ServiceBusReceivedMessage> peekBatchAt(int maxMessages, long sequenceNumber) {
        if (maxMessages <= 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxMessages' cannot be less than or equal to 0. maxMessages: " + maxMessages));
        }
        Flux messages = this.asyncClient.peekBatchAt(maxMessages, sequenceNumber).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public IterableStream<ServiceBusReceivedMessage> peekBatchAt(int maxMessages, long sequenceNumber, String sessionId) {
        if (maxMessages <= 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxMessages' cannot be less than or equal to 0. maxMessages: " + maxMessages));
        }
        Flux messages = this.asyncClient.peekBatchAt(maxMessages, sequenceNumber, sessionId).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public IterableStream<ServiceBusReceivedMessageContext> receive(int maxMessages) {
        return this.receive(maxMessages, this.operationTimeout);
    }

    public IterableStream<ServiceBusReceivedMessageContext> receive(int maxMessages, Duration maxWaitTime) {
        if (maxMessages <= 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxMessages' cannot be less than or equal to 0. maxMessages: " + maxMessages));
        }
        if (Objects.isNull(maxWaitTime)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'maxWaitTime' cannot be null."));
        }
        if (maxWaitTime.isNegative() || maxWaitTime.isZero()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxWaitTime' cannot be zero or less. maxWaitTime: " + maxWaitTime));
        }
        Flux messages = Flux.create(emitter -> this.queueWork(maxMessages, maxWaitTime, (FluxSink<ServiceBusReceivedMessageContext>)emitter));
        return new IterableStream(messages);
    }

    public ServiceBusReceivedMessage receiveDeferredMessage(long sequenceNumber) {
        return (ServiceBusReceivedMessage)this.asyncClient.receiveDeferredMessage(sequenceNumber).block(this.operationTimeout);
    }

    public ServiceBusReceivedMessage receiveDeferredMessage(long sequenceNumber, String sessionId) {
        return (ServiceBusReceivedMessage)this.asyncClient.receiveDeferredMessage(sequenceNumber, sessionId).block(this.operationTimeout);
    }

    public IterableStream<ServiceBusReceivedMessage> receiveDeferredMessageBatch(Iterable<Long> sequenceNumbers) {
        Flux messages = this.asyncClient.receiveDeferredMessageBatch(sequenceNumbers).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public IterableStream<ServiceBusReceivedMessage> receiveDeferredMessageBatch(Iterable<Long> sequenceNumbers, String sessionId) {
        Flux messages = this.asyncClient.receiveDeferredMessageBatch(sequenceNumbers, sessionId).timeout(this.operationTimeout);
        messages.subscribe();
        return new IterableStream(messages);
    }

    public Instant renewMessageLock(MessageLockToken lockToken) {
        return (Instant)this.asyncClient.renewMessageLock(lockToken).block(this.operationTimeout);
    }

    public Instant renewSessionLock(String sessionId) {
        return (Instant)this.asyncClient.renewSessionLock(sessionId).block(this.operationTimeout);
    }

    public void setSessionState(String sessionId, byte[] sessionState) {
        this.asyncClient.setSessionState(sessionId, sessionState).block(this.operationTimeout);
    }

    public ServiceBusTransactionContext createTransaction() {
        return (ServiceBusTransactionContext)this.asyncClient.createTransaction().block(this.operationTimeout);
    }

    public void commitTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.commitTransaction(transactionContext).block(this.operationTimeout);
    }

    public void rollbackTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.rollbackTransaction(transactionContext).block(this.operationTimeout);
    }

    @Override
    public void close() {
        this.asyncClient.close();
        SynchronousMessageSubscriber messageSubscriber = this.synchronousMessageSubscriber.getAndSet(null);
        if (messageSubscriber != null && !messageSubscriber.isDisposed()) {
            messageSubscriber.dispose();
        }
    }

    private void queueWork(int maximumMessageCount, Duration maxWaitTime, FluxSink<ServiceBusReceivedMessageContext> emitter) {
        long id = this.idGenerator.getAndIncrement();
        SynchronousReceiveWork work = new SynchronousReceiveWork(id, maximumMessageCount, maxWaitTime, emitter);
        SynchronousMessageSubscriber messageSubscriber = this.synchronousMessageSubscriber.get();
        if (messageSubscriber == null) {
            long prefetch = this.asyncClient.getReceiverOptions().getPrefetchCount();
            SynchronousMessageSubscriber newSubscriber = new SynchronousMessageSubscriber(prefetch, work);
            if (!this.synchronousMessageSubscriber.compareAndSet(null, newSubscriber)) {
                newSubscriber.dispose();
                SynchronousMessageSubscriber existing = this.synchronousMessageSubscriber.get();
                existing.queueWork(work);
            } else {
                this.asyncClient.receive().subscribeWith((Subscriber)newSubscriber);
            }
        } else {
            messageSubscriber.queueWork(work);
        }
        this.logger.verbose("[{}] Receive request queued up.", new Object[]{work.getId()});
    }
}

