/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusMessageBatch;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.CreateBatchOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class ServiceBusSenderClient
implements AutoCloseable {
    private final ServiceBusSenderAsyncClient asyncClient;
    private final Duration tryTimeout;

    ServiceBusSenderClient(ServiceBusSenderAsyncClient asyncClient, Duration tryTimeout) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.tryTimeout = Objects.requireNonNull(tryTimeout, "'tryTimeout' cannot be null.");
    }

    public void cancelScheduledMessage(long sequenceNumber) {
        this.asyncClient.cancelScheduledMessage(sequenceNumber).block(this.tryTimeout);
    }

    public ServiceBusMessageBatch createBatch() {
        return (ServiceBusMessageBatch)this.asyncClient.createBatch().block(this.tryTimeout);
    }

    public ServiceBusMessageBatch createBatch(CreateBatchOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return (ServiceBusMessageBatch)this.asyncClient.createBatch(options).block(this.tryTimeout);
    }

    public String getEntityPath() {
        return this.asyncClient.getEntityPath();
    }

    public String getFullyQualifiedNamespace() {
        return this.asyncClient.getFullyQualifiedNamespace();
    }

    public void send(ServiceBusMessage message) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        this.asyncClient.send(message).block(this.tryTimeout);
    }

    public void send(Iterable<ServiceBusMessage> messages) {
        this.asyncClient.send(messages).block(this.tryTimeout);
    }

    public void send(ServiceBusMessageBatch batch) {
        Objects.requireNonNull(batch, "'batch' cannot be null.");
        this.asyncClient.send(batch).block(this.tryTimeout);
    }

    public void send(ServiceBusMessage message, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.send(message, transactionContext).block(this.tryTimeout);
    }

    public void send(Iterable<ServiceBusMessage> messages, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.send(messages, transactionContext).block(this.tryTimeout);
    }

    public void send(ServiceBusMessageBatch batch, ServiceBusTransactionContext transactionContext) {
        this.asyncClient.send(batch, transactionContext).block(this.tryTimeout);
    }

    public Long scheduleMessage(ServiceBusMessage message, Instant scheduledEnqueueTime) {
        return (Long)this.asyncClient.scheduleMessage(message, scheduledEnqueueTime).block(this.tryTimeout);
    }

    public Long scheduleMessage(ServiceBusMessage message, Instant scheduledEnqueueTime, ServiceBusTransactionContext transactionContext) {
        return (Long)this.asyncClient.scheduleMessage(message, scheduledEnqueueTime, transactionContext).block(this.tryTimeout);
    }

    @Override
    public void close() {
        this.asyncClient.close();
    }

    public ServiceBusTransactionContext createTransaction() {
        return (ServiceBusTransactionContext)this.asyncClient.createTransaction().block(this.tryTimeout);
    }

    public void commitTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.commitTransaction(transactionContext).block(this.tryTimeout);
    }

    public void rollbackTransaction(ServiceBusTransactionContext transactionContext) {
        this.asyncClient.rollbackTransaction(transactionContext).block(this.tryTimeout);
    }
}

