/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.SynchronousReceiveWork;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

class SynchronousMessageSubscriber
extends BaseSubscriber<ServiceBusReceivedMessageContext> {
    private final ClientLogger logger = new ClientLogger(SynchronousMessageSubscriber.class);
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicInteger wip = new AtomicInteger();
    private final Queue<SynchronousReceiveWork> workQueue = new ConcurrentLinkedQueue<SynchronousReceiveWork>();
    private final Queue<ServiceBusReceivedMessageContext> bufferMessages = new ConcurrentLinkedQueue<ServiceBusReceivedMessageContext>();
    private final AtomicLong remaining = new AtomicLong();
    private final long requested;
    private final Object currentWorkLock = new Object();
    private Disposable currentTimeoutOperation;
    private SynchronousReceiveWork currentWork;
    private boolean subscriberInitialized;
    private volatile Subscription subscription;
    private static final AtomicReferenceFieldUpdater<SynchronousMessageSubscriber, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(SynchronousMessageSubscriber.class, Subscription.class, "subscription");

    SynchronousMessageSubscriber(long prefetch, SynchronousReceiveWork initialWork) {
        this.workQueue.add(initialWork);
        this.requested = (long)initialWork.getNumberOfEvents() > prefetch ? (long)initialWork.getNumberOfEvents() : prefetch;
    }

    protected void hookOnSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            this.subscription = subscription;
            this.remaining.addAndGet(this.requested);
            subscription.request(this.requested);
            this.subscriberInitialized = true;
            this.drain();
        } else {
            this.logger.error("Already subscribed once.");
        }
    }

    protected void hookOnNext(ServiceBusReceivedMessageContext message) {
        this.bufferMessages.add(message);
        this.drain();
    }

    void queueWork(SynchronousReceiveWork work) {
        this.logger.info("[{}] Pending: {}, Scheduling receive timeout task '{}'.", new Object[]{work.getId(), work.getNumberOfEvents(), work.getTimeout()});
        this.workQueue.add(work);
        if (this.subscriberInitialized) {
            this.drain();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drain() {
        int decremented;
        if (!this.wip.compareAndSet(0, 1)) {
            return;
        }
        try {
            this.drainQueue();
            decremented = this.wip.decrementAndGet();
            if (decremented == 0) return;
        }
        catch (Throwable throwable) {
            int decremented2 = this.wip.decrementAndGet();
            if (decremented2 == 0) throw throwable;
            this.logger.warning("There should be 0, but was: {}", new Object[]{decremented2});
            throw throwable;
        }
        this.logger.warning("There should be 0, but was: {}", new Object[]{decremented});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        if (this.isTerminated()) {
            return;
        }
        Object object = this.currentWorkLock;
        synchronized (object) {
            if (this.currentWork != null && this.currentWork.isTerminal()) {
                this.workQueue.remove(this.currentWork);
                if (this.currentTimeoutOperation != null && !this.currentTimeoutOperation.isDisposed()) {
                    this.currentTimeoutOperation.dispose();
                }
                this.currentTimeoutOperation = null;
            }
            while (!((this.currentWork = this.workQueue.peek()) == null || this.currentWork.isProcessingStarted() && this.bufferMessages.size() <= 0)) {
                if (this.currentWork.isTerminal()) {
                    this.workQueue.remove(this.currentWork);
                    if (this.currentTimeoutOperation == null || this.currentTimeoutOperation.isDisposed()) continue;
                    this.currentTimeoutOperation.dispose();
                    continue;
                }
                if (!this.currentWork.isProcessingStarted()) {
                    this.currentTimeoutOperation = this.getTimeoutOperation(this.currentWork);
                    this.currentWork.startedProcessing();
                }
                while (this.bufferMessages.size() > 0 && !this.currentWork.isTerminal()) {
                    this.currentWork.next(this.bufferMessages.poll());
                    this.remaining.decrementAndGet();
                }
                if (this.currentWork.isTerminal()) {
                    if (this.currentWork.getError() == null) {
                        this.currentWork.complete();
                    }
                    this.workQueue.remove(this.currentWork);
                    if (this.currentTimeoutOperation != null && !this.currentTimeoutOperation.isDisposed()) {
                        this.currentTimeoutOperation.dispose();
                    }
                    this.logger.verbose("The work [{}] is complete.", new Object[]{this.currentWork.getId()});
                    continue;
                }
                long creditToAdd = (long)this.currentWork.getRemaining() - (this.remaining.get() + (long)this.bufferMessages.size());
                if (creditToAdd <= 0L) continue;
                this.remaining.addAndGet(creditToAdd);
                this.subscription.request(creditToAdd);
                this.logger.verbose("Requesting [{}] from upstream for work [{}].", new Object[]{creditToAdd, this.currentWork.getId()});
            }
        }
    }

    private Disposable getTimeoutOperation(SynchronousReceiveWork work) {
        Duration timeout = work.getTimeout();
        return Mono.delay((Duration)timeout).thenReturn((Object)work).subscribe(l -> {
            Object object = this.currentWorkLock;
            synchronized (object) {
                if (this.currentWork == work) {
                    work.timeout();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookOnError(Throwable throwable) {
        this.logger.error("[{}] Errors occurred upstream", new Object[]{this.currentWork.getId(), throwable});
        Object object = this.currentWorkLock;
        synchronized (object) {
            this.currentWork.error(throwable);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookOnCancel() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        Object object = this.currentWorkLock;
        synchronized (object) {
            if (this.currentWork != null) {
                this.currentWork.complete();
            }
            if (this.currentTimeoutOperation != null && !this.currentTimeoutOperation.isDisposed()) {
                this.currentTimeoutOperation.dispose();
            }
            this.currentTimeoutOperation = null;
        }
        this.subscription.cancel();
    }

    private boolean isTerminated() {
        return this.isDisposed.get();
    }

    int getWorkQueueSize() {
        return this.workQueue.size();
    }

    long getRequested() {
        return this.requested;
    }

    boolean isSubscriberInitialized() {
        return this.subscriberInitialized;
    }
}

