/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.FluxSink;

class SynchronousReceiveWork {
    private final ClientLogger logger = new ClientLogger(SynchronousReceiveWork.class);
    private final long id;
    private final AtomicInteger remaining;
    private final int numberToReceive;
    private final Duration timeout;
    private final FluxSink<ServiceBusReceivedMessageContext> emitter;
    private boolean workTimedOut = false;
    private boolean processingStarted;
    private volatile Throwable error = null;

    SynchronousReceiveWork(long id, int numberToReceive, Duration timeout, FluxSink<ServiceBusReceivedMessageContext> emitter) {
        this.id = id;
        this.remaining = new AtomicInteger(numberToReceive);
        this.numberToReceive = numberToReceive;
        this.timeout = timeout;
        this.emitter = emitter;
    }

    long getId() {
        return this.id;
    }

    Duration getTimeout() {
        return this.timeout;
    }

    int getNumberOfEvents() {
        return this.numberToReceive;
    }

    int getRemaining() {
        return this.remaining.get();
    }

    boolean isTerminal() {
        return this.emitter.isCancelled() || this.remaining.get() == 0 || this.error != null || this.workTimedOut;
    }

    void next(ServiceBusReceivedMessageContext message) {
        try {
            this.emitter.next((Object)message);
            this.remaining.decrementAndGet();
        }
        catch (Exception e) {
            this.logger.warning("Exception occurred while publishing downstream.", new Object[]{e});
            this.error(e);
        }
    }

    void complete() {
        this.logger.info("[{}]: Completing task.", new Object[]{this.id});
        this.emitter.complete();
    }

    void timeout() {
        this.logger.info("[{}]: Work timeout occurred. Completing the work.", new Object[]{this.id});
        this.emitter.complete();
        this.workTimedOut = true;
    }

    void error(Throwable error) {
        this.error = error;
        this.emitter.error(error);
    }

    Throwable getError() {
        return this.error;
    }

    void startedProcessing() {
        this.processingStarted = true;
    }

    boolean isProcessingStarted() {
        return this.processingStarted;
    }
}

