/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class MessageLockContainer
implements AutoCloseable {
    private final ClientLogger logger = new ClientLogger(MessageLockContainer.class);
    private final ConcurrentHashMap<String, Instant> lockTokens = new ConcurrentHashMap();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final Disposable cleanupOperation;

    public MessageLockContainer(Duration cleanupInterval) {
        this.cleanupOperation = Flux.interval((Duration)cleanupInterval).subscribe(e -> {
            if (this.lockTokens.isEmpty()) {
                return;
            }
            Instant now = Instant.now();
            this.lockTokens.entrySet().removeIf(entry -> {
                boolean isExpired;
                Instant expiration = (Instant)entry.getValue();
                boolean bl = isExpired = expiration != null && expiration.isBefore(now);
                if (isExpired) {
                    this.logger.info("lockToken[{}]. expiration[{}]. Removing expired entry. ", new Object[]{entry.getKey(), expiration, e});
                }
                return isExpired;
            });
        });
    }

    public Instant addOrUpdate(String lockToken, Instant lockTokenExpiration) {
        if (this.isDisposed.get()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot perform operations on a disposed set."));
        }
        return this.lockTokens.compute(lockToken, (key, existing) -> {
            if (existing == null) {
                return lockTokenExpiration;
            }
            return existing.isBefore(lockTokenExpiration) ? lockTokenExpiration : existing;
        });
    }

    public boolean contains(String lockToken) {
        if (this.isDisposed.get()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot perform operations on a disposed set."));
        }
        Instant value = this.lockTokens.getOrDefault(lockToken, Instant.MIN);
        return value.isAfter(Instant.now());
    }

    public void remove(String lockToken) {
        this.lockTokens.remove(lockToken);
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.lockTokens.clear();
        this.cleanupOperation.dispose();
    }
}

