/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.ServiceBusErrorCondition;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public final class MessageUtils {
    static final UUID ZERO_LOCK_TOKEN = new UUID(0L, 0L);
    static final int LOCK_TOKEN_SIZE = 16;
    private static final Symbol DEAD_LETTER_OPERATION = Symbol.getSymbol((String)"com.microsoft:dead-letter");
    private static final String DEAD_LETTER_REASON = "DeadLetterReason";
    private static final String DEAD_LETTER_ERROR_DESCRIPTION = "DeadLetterErrorDescription";
    private static final long EPOCH_IN_DOT_NET_TICKS = 621355968000000000L;
    private static final int GUID_SIZE = 16;

    private MessageUtils() {
    }

    public static Duration adjustServerTimeout(Duration clientTimeout) {
        return clientTimeout.minusMillis(1000L);
    }

    static UUID convertDotNetBytesToUUID(byte[] dotNetBytes) {
        if (dotNetBytes == null || dotNetBytes.length != 16) {
            return ZERO_LOCK_TOKEN;
        }
        byte[] reOrderedBytes = MessageUtils.reorderBytes(dotNetBytes);
        ByteBuffer buffer = ByteBuffer.wrap(reOrderedBytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    static byte[] convertUUIDToDotNetBytes(UUID uuid) {
        if (uuid == null || uuid.equals(ZERO_LOCK_TOKEN)) {
            return new byte[16];
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] javaBytes = buffer.array();
        return MessageUtils.reorderBytes(javaBytes);
    }

    static Instant convertDotNetTicksToInstant(long dotNetTicks) {
        long ticksFromEpoch = dotNetTicks - 621355968000000000L;
        long millisecondsFromEpoch = Double.valueOf((double)ticksFromEpoch * 1.0E-4).longValue();
        long fractionTicks = ticksFromEpoch % 10000L;
        return Instant.ofEpochMilli(millisecondsFromEpoch).plusNanos(fractionTicks * 100L);
    }

    public static DeliveryState getDeliveryState(DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        Accepted state;
        boolean hasTransaction = transactionContext != null && transactionContext.getTransactionId() != null;
        switch (dispositionStatus) {
            case COMPLETED: {
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)Accepted.getInstance());
                    break;
                }
                state = Accepted.getInstance();
                break;
            }
            case SUSPENDED: {
                Rejected rejected = new Rejected();
                ErrorCondition error = new ErrorCondition(DEAD_LETTER_OPERATION, null);
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterReason)) {
                    errorInfo.put(DEAD_LETTER_REASON, deadLetterReason);
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterErrorDescription)) {
                    errorInfo.put(DEAD_LETTER_ERROR_DESCRIPTION, deadLetterErrorDescription);
                }
                if (propertiesToModify != null) {
                    errorInfo.putAll(propertiesToModify);
                }
                error.setInfo(errorInfo);
                rejected.setError(error);
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)rejected);
                    break;
                }
                state = rejected;
                break;
            }
            case ABANDONED: {
                Modified outcome = new Modified();
                if (propertiesToModify != null) {
                    outcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)outcome);
                    break;
                }
                state = outcome;
                break;
            }
            case DEFERRED: {
                Modified deferredOutcome = new Modified();
                deferredOutcome.setUndeliverableHere(Boolean.valueOf(true));
                if (propertiesToModify != null) {
                    deferredOutcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)deferredOutcome);
                    break;
                }
                state = deferredOutcome;
                break;
            }
            default: {
                state = null;
            }
        }
        return state;
    }

    static Throwable toException(ErrorCondition errorCondition, AmqpErrorContext errorContext) {
        Symbol condition = errorCondition.getCondition();
        String description = errorCondition.getDescription();
        try {
            return ExceptionUtil.toException((String)condition.toString(), (String)description, (AmqpErrorContext)errorContext);
        }
        catch (IllegalArgumentException ignored) {
            ServiceBusErrorCondition error = ServiceBusErrorCondition.fromString(condition.toString());
            return MessageUtils.toException(error, description, errorContext);
        }
    }

    static Throwable toException(ServiceBusErrorCondition errorCondition, String description, AmqpErrorContext errorContext) {
        boolean isTransient = errorCondition.isTransient();
        String message = String.format("condition[%s]: %s", errorCondition.toString(), description);
        return new AmqpException(isTransient, message, errorContext);
    }

    private static byte[] reorderBytes(byte[] javaBytes) {
        byte[] reorderedBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    int indexInReorderedBytes = 3;
                    break;
                }
                case 1: {
                    int indexInReorderedBytes = 2;
                    break;
                }
                case 2: {
                    int indexInReorderedBytes = 1;
                    break;
                }
                case 3: {
                    int indexInReorderedBytes = 0;
                    break;
                }
                case 4: {
                    int indexInReorderedBytes = 5;
                    break;
                }
                case 5: {
                    int indexInReorderedBytes = 4;
                    break;
                }
                case 6: {
                    int indexInReorderedBytes = 7;
                    break;
                }
                case 7: {
                    int indexInReorderedBytes = 6;
                    break;
                }
                default: {
                    int indexInReorderedBytes = i;
                }
            }
            reorderedBytes[indexInReorderedBytes] = javaBytes[i];
        }
        return reorderedBytes;
    }

    private static TransactionalState getTransactionState(ByteBuffer transactionId, Outcome outcome) {
        TransactionalState transactionalState = new TransactionalState();
        transactionalState.setTxnId(new Binary(transactionId.array()));
        transactionalState.setOutcome(outcome);
        return transactionalState;
    }
}

