/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Messages {
    private static final ClientLogger LOGGER = new ClientLogger(Messages.class);
    private static Properties properties;
    public static final String MESSAGES_PROPERTIES_PATH = "azure-messaging-servicebus.properties";
    public static final String CLASS_NOT_A_SUPPORTED_TYPE;
    public static final String INVALID_OPERATION_DISPOSED_RECEIVER;
    public static final String INVALID_LOCK_TOKEN_STRING;
    public static final String MESSAGE_NOT_OF_TYPE;
    public static final String REQUEST_VALUE_NOT_VALID;

    private static synchronized Properties getProperties() {
        if (properties != null) {
            return properties;
        }
        properties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(MESSAGES_PROPERTIES_PATH);){
            if (inputStream != null) {
                properties.load(inputStream);
            } else {
                LOGGER.error("Message properties [{}] not found", new Object[]{MESSAGES_PROPERTIES_PATH});
            }
        }
        catch (IOException exception) {
            LOGGER.error("Error loading message properties [{}]", new Object[]{MESSAGES_PROPERTIES_PATH, exception});
        }
        return properties;
    }

    public static String getMessage(String key) {
        return String.valueOf(Messages.getProperties().getOrDefault((Object)key, key));
    }

    static {
        CLASS_NOT_A_SUPPORTED_TYPE = Messages.getMessage("CLASS_NOT_A_SUPPORTED_TYPE");
        INVALID_OPERATION_DISPOSED_RECEIVER = Messages.getMessage("INVALID_OPERATION_DISPOSED_RECEIVER");
        INVALID_LOCK_TOKEN_STRING = Messages.getMessage("INVALID_LOCK_TOKEN_STRING");
        MESSAGE_NOT_OF_TYPE = Messages.getMessage("MESSAGE_NOT_OF_TYPE");
        REQUEST_VALUE_NOT_VALID = Messages.getMessage("REQUEST_VALUE_NOT_VALID");
    }
}

