/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.ExpandableStringEnum;
import java.util.HashSet;
import java.util.Set;

class ServiceBusErrorCondition
extends ExpandableStringEnum<ServiceBusErrorCondition> {
    private static final String VENDOR = "com.microsoft";
    private static final Set<ServiceBusErrorCondition> NON_TRANSIENT_ERRORS;
    static final ServiceBusErrorCondition OPERATION_CANCELLED;
    static final ServiceBusErrorCondition MESSAGE_LOCK_LOST;
    static final ServiceBusErrorCondition SESSION_LOCK_LOST;
    static final ServiceBusErrorCondition SESSION_CANNOT_BE_LOCKED_ERROR;
    static final ServiceBusErrorCondition MESSAGE_NOT_FOUND;
    static final ServiceBusErrorCondition ENTITY_ALREADY_EXISTS;

    ServiceBusErrorCondition() {
    }

    static ServiceBusErrorCondition fromString(String condition) {
        return (ServiceBusErrorCondition)ServiceBusErrorCondition.fromString((String)("com.microsoft:" + condition), ServiceBusErrorCondition.class);
    }

    boolean isTransient() {
        return !NON_TRANSIENT_ERRORS.contains((Object)this);
    }

    static {
        OPERATION_CANCELLED = ServiceBusErrorCondition.fromString("operation-cancelled");
        MESSAGE_LOCK_LOST = ServiceBusErrorCondition.fromString("message-lock-lost");
        SESSION_LOCK_LOST = ServiceBusErrorCondition.fromString("session-lock-lost");
        SESSION_CANNOT_BE_LOCKED_ERROR = ServiceBusErrorCondition.fromString("session-cannot-be-locked");
        MESSAGE_NOT_FOUND = ServiceBusErrorCondition.fromString("message-not-found");
        ENTITY_ALREADY_EXISTS = ServiceBusErrorCondition.fromString("entity-already-exists");
        NON_TRANSIENT_ERRORS = new HashSet<ServiceBusErrorCondition>();
        NON_TRANSIENT_ERRORS.add(OPERATION_CANCELLED);
        NON_TRANSIENT_ERRORS.add(MESSAGE_LOCK_LOST);
        NON_TRANSIENT_ERRORS.add(SESSION_LOCK_LOST);
        NON_TRANSIENT_ERRORS.add(SESSION_CANNOT_BE_LOCKED_ERROR);
        NON_TRANSIENT_ERRORS.add(MESSAGE_NOT_FOUND);
        NON_TRANSIENT_ERRORS.add(ENTITY_ALREADY_EXISTS);
    }
}

