/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.QueuesImpl;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class ServiceBusManagementClientImpl {
    private final ServiceBusManagementClientService service;
    private String endpoint;
    private String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final QueuesImpl queues;

    public String getEndpoint() {
        return this.endpoint;
    }

    ServiceBusManagementClientImpl setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    ServiceBusManagementClientImpl setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public QueuesImpl getQueues() {
        return this.queues;
    }

    ServiceBusManagementClientImpl() {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build());
    }

    ServiceBusManagementClientImpl(HttpPipeline httpPipeline) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter());
    }

    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.queues = new QueuesImpl(this);
        this.service = (ServiceBusManagementClientService)RestProxy.create(ServiceBusManagementClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)serializerAdapter);
    }

    public Mono<Response<Object>> listEntitiesWithResponseAsync(String entityType, Integer skip, Integer top, Context context) {
        return this.service.listEntities(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface ServiceBusManagementClientService {
        @Get(value="/$Resources/{entityType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> listEntities(@HostParam(value="endpoint") String var1, @PathParam(value="entityType") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, Context var6);
    }
}

