/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import reactor.core.publisher.Mono;

public class ServiceBusTokenCredentialHttpPolicy
implements HttpPipelinePolicy {
    private final TokenCredential tokenCredential;

    public ServiceBusTokenCredentialHttpPolicy(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String url = context.getHttpRequest().getUrl().toString();
        return this.tokenCredential.getToken(new TokenRequestContext().addScopes(new String[]{url})).flatMap(token -> {
            context.getHttpRequest().getHeaders().put("Authorization", token.getToken());
            return next.process();
        });
    }
}

