/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.models;

import com.azure.messaging.servicebus.models.MessageCountDetails;
import com.azure.messaging.servicebus.models.QueueDescription;
import java.time.OffsetDateTime;
import java.util.Objects;

public class QueueRuntimeInfo {
    private final String name;
    private final MessageCountDetails details;
    private final long messageCount;
    private final long sizeInBytes;
    private final OffsetDateTime accessedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;

    public QueueRuntimeInfo(QueueDescription queueDescription) {
        Objects.requireNonNull(queueDescription, "'queueDescription' cannot be null.");
        this.name = queueDescription.getName();
        this.details = queueDescription.getMessageCountDetails();
        this.messageCount = queueDescription.getMessageCount().intValue();
        this.sizeInBytes = queueDescription.getSizeInBytes().intValue();
        this.accessedAt = queueDescription.getAccessedAt();
        this.createdAt = queueDescription.getCreatedAt();
        this.updatedAt = queueDescription.getUpdatedAt();
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public MessageCountDetails getDetails() {
        return this.details;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public String getName() {
        return this.name;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

