/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class LockContainer<T>
implements AutoCloseable {
    private final ClientLogger logger = new ClientLogger(LockContainer.class);
    private final ConcurrentHashMap<String, OffsetDateTime> lockTokenExpirationMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, T> lockTokenItemMap = new ConcurrentHashMap();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final Disposable cleanupOperation;
    private final Consumer<T> onExpired;

    public LockContainer(Duration cleanupInterval) {
        this(cleanupInterval, t -> {});
    }

    public LockContainer(Duration cleanupInterval, Consumer<T> onExpired) {
        Objects.requireNonNull(cleanupInterval, "'cleanupInterval' cannot be null.");
        this.onExpired = Objects.requireNonNull(onExpired, "'onExpired' cannot be null.");
        this.cleanupOperation = Flux.interval((Duration)cleanupInterval).subscribe(e -> {
            if (this.lockTokenExpirationMap.isEmpty()) {
                return;
            }
            OffsetDateTime now = OffsetDateTime.now();
            List<String> expired = this.lockTokenExpirationMap.entrySet().stream().filter(entry -> entry.getValue() != null && ((OffsetDateTime)entry.getValue()).isBefore(now)).map(Map.Entry::getKey).collect(Collectors.toList());
            expired.forEach(this::remove);
        });
    }

    public OffsetDateTime addOrUpdate(String lockToken, OffsetDateTime lockTokenExpiration, T item) {
        if (this.isDisposed.get()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot perform operations on a disposed set."));
        }
        Objects.requireNonNull(lockToken, "'lockToken' cannot be null.");
        Objects.requireNonNull(item, "'item' cannot be null.");
        Objects.requireNonNull(lockTokenExpiration, "'lockTokenExpiration' cannot be null.");
        OffsetDateTime computed = this.lockTokenExpirationMap.compute(lockToken, (key, existing) -> {
            if (existing == null) {
                return lockTokenExpiration;
            }
            return existing.isBefore(lockTokenExpiration) ? lockTokenExpiration : existing;
        });
        this.lockTokenItemMap.put(lockToken, item);
        return computed;
    }

    public boolean containsUnexpired(String lockToken) {
        if (this.isDisposed.get()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot perform operations on a disposed set."));
        }
        OffsetDateTime value = this.lockTokenExpirationMap.getOrDefault(lockToken, OffsetDateTime.MIN);
        return value.isAfter(OffsetDateTime.now());
    }

    public void remove(String lockToken) {
        this.lockTokenExpirationMap.remove(lockToken);
        T remove = this.lockTokenItemMap.remove(lockToken);
        if (remove != null) {
            this.onExpired.accept(remove);
        }
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.cleanupOperation.dispose();
        for (String key : ((ConcurrentHashMap.CollectionView)((Object)this.lockTokenExpirationMap.keySet())).toArray(new String[0])) {
            this.remove(key);
        }
    }
}

