/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.exception.AmqpResponseCode;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RequestResponseUtils;
import com.azure.core.amqp.models.AmqpAddress;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.MessageWithLockToken;
import com.azure.messaging.servicebus.implementation.Messages;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.message.Message;

class ServiceBusMessageSerializer
implements MessageSerializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final ClientLogger logger = new ClientLogger(ServiceBusMessageSerializer.class);

    ServiceBusMessageSerializer() {
    }

    public int getSize(Message amqpMessage) {
        int size;
        Map map;
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = ServiceBusMessageSerializer.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            map = messageAnnotations.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = ServiceBusMessageSerializer.sizeof(entry.getKey()) + ServiceBusMessageSerializer.sizeof(entry.getValue());
                annotationsSize += size;
            }
        }
        if (applicationProperties != null) {
            map = applicationProperties.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = ServiceBusMessageSerializer.sizeof(entry.getKey()) + ServiceBusMessageSerializer.sizeof(entry.getValue());
                applicationPropertiesSize += size;
            }
        }
        return annotationsSize + applicationPropertiesSize + payloadSize;
    }

    public <T> Message serialize(T object) {
        String partitionKey;
        Objects.requireNonNull(object, "'object' to serialize cannot be null.");
        if (!(object instanceof ServiceBusMessage)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot serialize object that is not ServiceBusMessage. Clazz: " + object.getClass()));
        }
        ServiceBusMessage brokeredMessage = (ServiceBusMessage)object;
        Message amqpMessage = Proton.message();
        byte[] body = brokeredMessage.getBody().toBytes();
        amqpMessage.setBody((Section)new Data(new Binary(body)));
        if (brokeredMessage.getApplicationProperties() != null) {
            amqpMessage.setApplicationProperties(new ApplicationProperties(brokeredMessage.getApplicationProperties()));
        }
        if (brokeredMessage.getTimeToLive() != null) {
            amqpMessage.setTtl(brokeredMessage.getTimeToLive().toMillis());
        }
        if (amqpMessage.getProperties() == null) {
            amqpMessage.setProperties(new Properties());
        }
        amqpMessage.setMessageId((Object)brokeredMessage.getMessageId());
        amqpMessage.setContentType(brokeredMessage.getContentType());
        amqpMessage.setCorrelationId((Object)brokeredMessage.getCorrelationId());
        amqpMessage.setSubject(brokeredMessage.getSubject());
        amqpMessage.setReplyTo(brokeredMessage.getReplyTo());
        amqpMessage.setReplyToGroupId(brokeredMessage.getReplyToSessionId());
        amqpMessage.setGroupId(brokeredMessage.getSessionId());
        AmqpMessageProperties brokeredProperties = brokeredMessage.getRawAmqpMessage().getProperties();
        amqpMessage.setContentEncoding(brokeredProperties.getContentEncoding());
        if (brokeredProperties.getGroupSequence() != null) {
            amqpMessage.setGroupSequence(brokeredProperties.getGroupSequence().longValue());
        }
        amqpMessage.getProperties().setTo(brokeredMessage.getTo());
        amqpMessage.getProperties().setUserId(new Binary(brokeredProperties.getUserId()));
        if (brokeredProperties.getAbsoluteExpiryTime() != null) {
            amqpMessage.getProperties().setAbsoluteExpiryTime(Date.from(brokeredProperties.getAbsoluteExpiryTime().toInstant()));
        }
        if (brokeredProperties.getCreationTime() != null) {
            amqpMessage.getProperties().setCreationTime(Date.from(brokeredProperties.getCreationTime().toInstant()));
        }
        amqpMessage.setFooter(new Footer(brokeredMessage.getRawAmqpMessage().getFooter()));
        AmqpMessageHeader header = brokeredMessage.getRawAmqpMessage().getHeader();
        if (header.getDeliveryCount() != null) {
            amqpMessage.setDeliveryCount(header.getDeliveryCount().longValue());
        }
        if (header.getPriority() != null) {
            amqpMessage.setPriority(header.getPriority().shortValue());
        }
        if (header.isDurable() != null) {
            amqpMessage.setDurable(header.isDurable().booleanValue());
        }
        if (header.isFirstAcquirer() != null) {
            amqpMessage.setFirstAcquirer(header.isFirstAcquirer().booleanValue());
        }
        if (header.getTimeToLive() != null) {
            amqpMessage.setTtl(header.getTimeToLive().toMillis());
        }
        HashMap<Symbol, Object> messageAnnotationsMap = new HashMap<Symbol, Object>();
        if (brokeredMessage.getScheduledEnqueueTime() != null) {
            messageAnnotationsMap.put(Symbol.valueOf((String)AmqpMessageConstant.SCHEDULED_ENQUEUE_UTC_TIME_NAME.getValue()), Date.from(brokeredMessage.getScheduledEnqueueTime().toInstant()));
        }
        if ((partitionKey = brokeredMessage.getPartitionKey()) != null && !partitionKey.isEmpty()) {
            messageAnnotationsMap.put(Symbol.valueOf((String)AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue()), brokeredMessage.getPartitionKey());
        }
        amqpMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotationsMap));
        HashMap deliveryAnnotationsMap = new HashMap();
        Map deliveryAnnotations = brokeredMessage.getRawAmqpMessage().getDeliveryAnnotations();
        for (Map.Entry deliveryEntry : deliveryAnnotations.entrySet()) {
            deliveryAnnotationsMap.put(Symbol.valueOf((String)((String)deliveryEntry.getKey())), deliveryEntry.getValue());
        }
        amqpMessage.setDeliveryAnnotations(new DeliveryAnnotations(deliveryAnnotationsMap));
        return amqpMessage;
    }

    public <T> T deserialize(Message message, Class<T> clazz) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz == ServiceBusReceivedMessage.class) {
            return (T)this.deserializeMessage(message);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, clazz)));
    }

    public <T> List<T> deserializeList(Message message, Class<T> clazz) {
        if (clazz == ServiceBusReceivedMessage.class) {
            return this.deserializeListOfMessages(message);
        }
        if (clazz == OffsetDateTime.class) {
            return this.deserializeListOfOffsetDateTime(message);
        }
        if (clazz == OffsetDateTime.class) {
            return this.deserializeListOfOffsetDateTime(message);
        }
        if (clazz == Long.class) {
            return this.deserializeListOfLong(message);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, clazz)));
    }

    private List<Long> deserializeListOfLong(Message amqpMessage) {
        Map responseBody;
        Object expirationListObj;
        AmqpValue amqpValue;
        if (amqpMessage.getBody() instanceof AmqpValue && (amqpValue = (AmqpValue)amqpMessage.getBody()).getValue() instanceof Map && (expirationListObj = (responseBody = (Map)amqpValue.getValue()).get("sequence-numbers")) instanceof long[]) {
            return Arrays.stream((long[])expirationListObj).boxed().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<OffsetDateTime> deserializeListOfOffsetDateTime(Message amqpMessage) {
        Map responseBody;
        Object expirationListObj;
        AmqpValue amqpValue;
        if (amqpMessage.getBody() instanceof AmqpValue && (amqpValue = (AmqpValue)amqpMessage.getBody()).getValue() instanceof Map && (expirationListObj = (responseBody = (Map)amqpValue.getValue()).get("expirations")) instanceof Date[]) {
            return Arrays.stream((Date[])expirationListObj).map(date -> date.toInstant().atOffset(ZoneOffset.UTC)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<ServiceBusReceivedMessage> deserializeListOfMessages(Message amqpMessage) {
        ArrayList<ServiceBusReceivedMessage> messageList = new ArrayList<ServiceBusReceivedMessage>();
        AmqpResponseCode statusCode = RequestResponseUtils.getStatusCode((Message)amqpMessage);
        if (statusCode != AmqpResponseCode.OK) {
            this.logger.warning("AMQP response did not contain OK status code. Actual: {}", new Object[]{statusCode});
            return Collections.emptyList();
        }
        Object responseBodyMap = ((AmqpValue)amqpMessage.getBody()).getValue();
        if (responseBodyMap == null) {
            this.logger.warning("AMQP response did not contain a body.");
            return Collections.emptyList();
        }
        if (!(responseBodyMap instanceof Map)) {
            this.logger.warning("AMQP response body is not correct instance. Expected: {}. Actual: {}", new Object[]{Map.class, responseBodyMap.getClass()});
            return Collections.emptyList();
        }
        Object messages = ((Map)responseBodyMap).get("messages");
        if (messages == null) {
            this.logger.warning("Response body did not contain key: {}", new Object[]{"messages"});
            return Collections.emptyList();
        }
        if (!(messages instanceof Iterable)) {
            this.logger.warning("Response body contents is not the correct type. Expected: {}. Actual: {}", new Object[]{Iterable.class, messages.getClass()});
            return Collections.emptyList();
        }
        for (Object message : (Iterable)messages) {
            if (!(message instanceof Map)) {
                this.logger.warning("Message inside iterable of message is not correct type. Expected: {}. Actual: {}", new Object[]{Map.class, message.getClass()});
                continue;
            }
            Message responseMessage = Message.Factory.create();
            Binary messagePayLoad = (Binary)((Map)message).get("message");
            responseMessage.decode(messagePayLoad.getArray(), messagePayLoad.getArrayOffset(), messagePayLoad.getLength());
            ServiceBusReceivedMessage receivedMessage = this.deserializeMessage(responseMessage);
            if (((Map)message).containsKey("lock-token")) {
                receivedMessage.setLockToken((UUID)((Map)message).get("lock-token"));
            }
            messageList.add(receivedMessage);
        }
        return messageList;
    }

    private ServiceBusReceivedMessage deserializeMessage(Message amqpMessage) {
        MessageAnnotations messageAnnotations;
        Properties amqpProperties;
        Object messageId;
        byte[] bytes;
        Section body = amqpMessage.getBody();
        if (body != null) {
            if (body instanceof Data) {
                Binary messageData = ((Data)body).getValue();
                bytes = messageData.getArray();
            } else {
                this.logger.warning(String.format(Messages.MESSAGE_NOT_OF_TYPE, body.getType()));
                bytes = EMPTY_BYTE_ARRAY;
            }
        } else {
            this.logger.warning(String.format(Messages.MESSAGE_NOT_OF_TYPE, "null"));
            bytes = EMPTY_BYTE_ARRAY;
        }
        ServiceBusReceivedMessage brokeredMessage = new ServiceBusReceivedMessage(BinaryData.fromBytes((byte[])bytes));
        AmqpAnnotatedMessage brokeredAmqpAnnotatedMessage = brokeredMessage.getRawAmqpMessage();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        if (applicationProperties != null) {
            Map propertiesValue = applicationProperties.getValue();
            brokeredAmqpAnnotatedMessage.getApplicationProperties().putAll(propertiesValue);
        }
        AmqpMessageHeader brokeredHeader = brokeredAmqpAnnotatedMessage.getHeader();
        brokeredHeader.setTimeToLive(Duration.ofMillis(amqpMessage.getTtl()));
        brokeredHeader.setDeliveryCount(Long.valueOf(amqpMessage.getDeliveryCount()));
        brokeredHeader.setDurable(amqpMessage.getHeader().getDurable());
        brokeredHeader.setFirstAcquirer(amqpMessage.getHeader().getFirstAcquirer());
        brokeredHeader.setPriority(Short.valueOf(amqpMessage.getPriority()));
        Footer footer = amqpMessage.getFooter();
        if (footer != null && footer.getValue() != null) {
            Map footerValue = footer.getValue();
            this.setValues(footerValue, brokeredAmqpAnnotatedMessage.getFooter());
        }
        AmqpMessageProperties brokeredProperties = brokeredAmqpAnnotatedMessage.getProperties();
        brokeredProperties.setReplyToGroupId(amqpMessage.getReplyToGroupId());
        String replyTo = amqpMessage.getReplyTo();
        if (replyTo != null) {
            brokeredProperties.setReplyTo(new AmqpAddress(amqpMessage.getReplyTo()));
        }
        if ((messageId = amqpMessage.getMessageId()) != null) {
            brokeredProperties.setMessageId(new AmqpMessageId(messageId.toString()));
        }
        brokeredProperties.setContentType(amqpMessage.getContentType());
        Object correlationId = amqpMessage.getCorrelationId();
        if (correlationId != null) {
            brokeredProperties.setCorrelationId(new AmqpMessageId(correlationId.toString()));
        }
        if ((amqpProperties = amqpMessage.getProperties()) != null) {
            String to = amqpProperties.getTo();
            if (to != null) {
                brokeredProperties.setTo(new AmqpAddress(amqpProperties.getTo()));
            }
            if (amqpProperties.getAbsoluteExpiryTime() != null) {
                brokeredProperties.setAbsoluteExpiryTime(amqpProperties.getAbsoluteExpiryTime().toInstant().atOffset(ZoneOffset.UTC));
            }
            if (amqpProperties.getCreationTime() != null) {
                brokeredProperties.setCreationTime(amqpProperties.getCreationTime().toInstant().atOffset(ZoneOffset.UTC));
            }
        }
        brokeredProperties.setSubject(amqpMessage.getSubject());
        brokeredProperties.setGroupId(amqpMessage.getGroupId());
        brokeredProperties.setContentEncoding(amqpMessage.getContentEncoding());
        brokeredProperties.setGroupSequence(Long.valueOf(amqpMessage.getGroupSequence()));
        brokeredProperties.setUserId(amqpMessage.getUserId());
        DeliveryAnnotations deliveryAnnotations = amqpMessage.getDeliveryAnnotations();
        if (deliveryAnnotations != null) {
            this.setValues(deliveryAnnotations.getValue(), brokeredAmqpAnnotatedMessage.getDeliveryAnnotations());
        }
        if ((messageAnnotations = amqpMessage.getMessageAnnotations()) != null) {
            this.setValues(messageAnnotations.getValue(), brokeredAmqpAnnotatedMessage.getMessageAnnotations());
        }
        if (amqpMessage instanceof MessageWithLockToken) {
            brokeredMessage.setLockToken(((MessageWithLockToken)amqpMessage).getLockToken());
        }
        return brokeredMessage;
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        Section bodySection = msg.getBody();
        if (bodySection instanceof AmqpValue) {
            return ServiceBusMessageSerializer.sizeof(((AmqpValue)bodySection).getValue());
        }
        if (bodySection instanceof AmqpSequence) {
            return ServiceBusMessageSerializer.sizeof(((AmqpSequence)bodySection).getValue());
        }
        if (bodySection instanceof Data) {
            Data payloadSection = (Data)bodySection;
            Binary payloadBytes = payloadSection.getValue();
            return ServiceBusMessageSerializer.sizeof(payloadBytes);
        }
        return 0;
    }

    private void setValues(Map<Symbol, Object> sourceMap, Map<String, Object> targetMap) {
        if (sourceMap != null) {
            for (Map.Entry<Symbol, Object> entry : sourceMap.entrySet()) {
                targetMap.put(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    private static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return obj.toString().length() << 1;
        }
        if (obj instanceof Symbol) {
            return ((Symbol)obj).length() << 1;
        }
        if (obj instanceof Byte || obj instanceof UnsignedByte) {
            return 1;
        }
        if (obj instanceof Integer || obj instanceof UnsignedInteger) {
            return 4;
        }
        if (obj instanceof Long || obj instanceof UnsignedLong || obj instanceof Date) {
            return 8;
        }
        if (obj instanceof Short || obj instanceof UnsignedShort) {
            return 2;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Character) {
            return 4;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof UUID) {
            return 16;
        }
        if (obj instanceof Decimal32) {
            return 4;
        }
        if (obj instanceof Decimal64) {
            return 8;
        }
        if (obj instanceof Decimal128) {
            return 16;
        }
        if (obj instanceof Binary) {
            return ((Binary)obj).getLength();
        }
        if (obj instanceof Declare) {
            return 7;
        }
        if (obj instanceof Discharge) {
            Discharge discharge = (Discharge)obj;
            return 12 + discharge.getTxnId().getLength();
        }
        if (obj instanceof Map) {
            int size = 8;
            Map map = (Map)obj;
            for (Object value : map.keySet()) {
                size += ServiceBusMessageSerializer.sizeof(value);
            }
            for (Object value : map.values()) {
                size += ServiceBusMessageSerializer.sizeof(value);
            }
            return size;
        }
        if (obj instanceof Iterable) {
            int size = 8;
            for (Object innerObject : (Iterable)obj) {
                size += ServiceBusMessageSerializer.sizeof(innerObject);
            }
            return size;
        }
        if (obj.getClass().isArray()) {
            int size = 8;
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                size += ServiceBusMessageSerializer.sizeof(Array.get(obj, i));
            }
            return size;
        }
        throw new IllegalArgumentException(String.format(Locale.US, "Encoding Type: %s is not supported", obj.getClass()));
    }
}

