/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import java.time.Duration;
import java.util.Objects;

public final class ServiceBusSessionReceiverClient
implements AutoCloseable {
    private final ServiceBusSessionReceiverAsyncClient sessionAsyncClient;
    private final Duration operationTimeout;

    ServiceBusSessionReceiverClient(ServiceBusSessionReceiverAsyncClient asyncClient, Duration operationTimeout) {
        this.sessionAsyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.operationTimeout = operationTimeout;
    }

    public ServiceBusReceiverClient acceptNextSession() {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptNextSession().map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.operationTimeout)).block(this.operationTimeout);
    }

    public ServiceBusReceiverClient acceptSession(String sessionId) {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptSession(sessionId).map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.operationTimeout)).block(this.operationTimeout);
    }

    @Override
    public void close() {
        this.sessionAsyncClient.close();
    }
}

