/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.time.Duration;
import java.util.Objects;

public final class CreateSubscriptionOptions {
    private Duration autoDeleteOnIdle;
    private Duration defaultMessageTimeToLive;
    private boolean deadLetteringOnMessageExpiration;
    private boolean deadLetteringOnFilterEvaluationExceptions;
    private boolean enableBatchedOperations;
    private String forwardTo;
    private String forwardDeadLetteredMessagesTo;
    private EntityStatus status;
    private Duration lockDuration;
    private int maxDeliveryCount;
    private boolean requiresSession;
    private String userMetadata;

    public CreateSubscriptionOptions() {
        this.autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        this.deadLetteringOnMessageExpiration = false;
        this.deadLetteringOnFilterEvaluationExceptions = true;
        this.defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        this.enableBatchedOperations = true;
        this.lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        this.maxDeliveryCount = 10;
        this.requiresSession = false;
        this.status = EntityStatus.ACTIVE;
    }

    public CreateSubscriptionOptions(SubscriptionProperties subscription) {
        Objects.requireNonNull(subscription, "'subscription' cannot be null.");
        this.autoDeleteOnIdle = subscription.getAutoDeleteOnIdle();
        this.deadLetteringOnMessageExpiration = subscription.isDeadLetteringOnMessageExpiration();
        this.deadLetteringOnFilterEvaluationExceptions = subscription.isDeadLetteringOnFilterEvaluationExceptions();
        this.defaultMessageTimeToLive = subscription.getDefaultMessageTimeToLive();
        this.enableBatchedOperations = subscription.isBatchedOperationsEnabled();
        this.forwardTo = subscription.getForwardTo();
        this.forwardDeadLetteredMessagesTo = subscription.getForwardDeadLetteredMessagesTo();
        this.lockDuration = subscription.getLockDuration();
        this.maxDeliveryCount = subscription.getMaxDeliveryCount();
        this.requiresSession = subscription.isSessionRequired();
        this.status = subscription.getStatus();
        this.userMetadata = subscription.getUserMetadata();
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public CreateSubscriptionOptions setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public boolean isSessionRequired() {
        return this.requiresSession;
    }

    public CreateSubscriptionOptions setSessionRequired(boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public CreateSubscriptionOptions setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public CreateSubscriptionOptions setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public CreateSubscriptionOptions setEnableDeadLetteringOnFilterEvaluationExceptions(boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public CreateSubscriptionOptions setMaxDeliveryCount(int maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public CreateSubscriptionOptions setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public CreateSubscriptionOptions setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public CreateSubscriptionOptions setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public CreateSubscriptionOptions setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public CreateSubscriptionOptions setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public CreateSubscriptionOptions setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }
}

