/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class EntitiesImpl {
    private final EntitiesService service;
    private final ServiceBusManagementClientImpl client;

    EntitiesImpl(ServiceBusManagementClientImpl client) {
        this.service = (EntitiesService)RestProxy.create(EntitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<Object>> getWithResponseAsync(String entityName, Boolean enrich, Context context) {
        return this.service.get(this.client.getEndpoint(), entityName, enrich, this.client.getApiVersion(), context);
    }

    public Mono<Response<Object>> putWithResponseAsync(String entityName, Object requestBody, String ifMatch, Context context) {
        return this.service.put(this.client.getEndpoint(), entityName, this.client.getApiVersion(), ifMatch, requestBody, context);
    }

    public Mono<Response<Object>> deleteWithResponseAsync(String entityName, Context context) {
        return this.service.delete(this.client.getEndpoint(), entityName, this.client.getApiVersion(), context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface EntitiesService {
        @Get(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="enrich") Boolean var3, @QueryParam(value="api-version") String var4, Context var5);

        @Put(value="/{entityName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> put(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/atom+xml") Object var5, Context var6);

        @Delete(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, Context var4);
    }
}

