/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.models.AmqpAddress;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageBodyType;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.models.ServiceBusMessageState;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ServiceBusReceivedMessage {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusReceivedMessage.class);
    private final AmqpAnnotatedMessage amqpAnnotatedMessage;
    private UUID lockToken;
    private boolean isSettled = false;
    private Context context;

    ServiceBusReceivedMessage(BinaryData body) {
        Objects.requireNonNull(body, "'body' cannot be null.");
        this.amqpAnnotatedMessage = new AmqpAnnotatedMessage(AmqpMessageBody.fromData((byte[])body.toBytes()));
        this.context = Context.NONE;
    }

    ServiceBusReceivedMessage(AmqpMessageBody body) {
        Objects.requireNonNull(body, "'body' cannot be null.");
        this.amqpAnnotatedMessage = new AmqpAnnotatedMessage(body);
        this.context = Context.NONE;
    }

    public Map<String, Object> getApplicationProperties() {
        return this.amqpAnnotatedMessage.getApplicationProperties();
    }

    public BinaryData getBody() {
        AmqpMessageBodyType bodyType = this.amqpAnnotatedMessage.getBody().getBodyType();
        switch (bodyType) {
            case DATA: {
                byte[] payload = this.amqpAnnotatedMessage.getBody().getFirstData();
                return BinaryData.fromBytes((byte[])payload);
            }
            case SEQUENCE: 
            case VALUE: {
                throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("This body type not is supported: " + bodyType));
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Body type not valid: " + bodyType));
    }

    public String getContentType() {
        return this.amqpAnnotatedMessage.getProperties().getContentType();
    }

    public String getCorrelationId() {
        String correlationId = null;
        AmqpMessageId amqpCorrelationId = this.amqpAnnotatedMessage.getProperties().getCorrelationId();
        if (amqpCorrelationId != null) {
            correlationId = amqpCorrelationId.toString();
        }
        return correlationId;
    }

    public String getDeadLetterErrorDescription() {
        return this.getStringValue(this.amqpAnnotatedMessage.getApplicationProperties(), AmqpMessageConstant.DEAD_LETTER_DESCRIPTION_ANNOTATION_NAME.getValue());
    }

    public String getDeadLetterReason() {
        return this.getStringValue(this.amqpAnnotatedMessage.getApplicationProperties(), AmqpMessageConstant.DEAD_LETTER_REASON_ANNOTATION_NAME.getValue());
    }

    public String getDeadLetterSource() {
        return this.getStringValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.DEAD_LETTER_SOURCE_KEY_ANNOTATION_NAME.getValue());
    }

    public long getDeliveryCount() {
        return this.amqpAnnotatedMessage.getHeader().getDeliveryCount();
    }

    public long getEnqueuedSequenceNumber() {
        return this.getLongValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.ENQUEUED_SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
    }

    public OffsetDateTime getEnqueuedTime() {
        return this.getOffsetDateTimeValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
    }

    public OffsetDateTime getExpiresAt() {
        Duration timeToLive = this.getTimeToLive();
        OffsetDateTime enqueuedTime = this.getEnqueuedTime();
        return enqueuedTime != null && timeToLive != null ? enqueuedTime.plus(timeToLive) : null;
    }

    public String getLockToken() {
        return this.lockToken != null ? this.lockToken.toString() : null;
    }

    public OffsetDateTime getLockedUntil() {
        return this.getOffsetDateTimeValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.LOCKED_UNTIL_KEY_ANNOTATION_NAME.getValue());
    }

    public String getMessageId() {
        String messageId = null;
        AmqpMessageId amqpMessageId = this.amqpAnnotatedMessage.getProperties().getMessageId();
        if (amqpMessageId != null) {
            messageId = amqpMessageId.toString();
        }
        return messageId;
    }

    public String getPartitionKey() {
        return this.getStringValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
    }

    public AmqpAnnotatedMessage getRawAmqpMessage() {
        return this.amqpAnnotatedMessage;
    }

    public String getReplyTo() {
        String replyTo = null;
        AmqpAddress amqpAddress = this.amqpAnnotatedMessage.getProperties().getReplyTo();
        if (amqpAddress != null) {
            replyTo = amqpAddress.toString();
        }
        return replyTo;
    }

    public String getReplyToSessionId() {
        return this.amqpAnnotatedMessage.getProperties().getReplyToGroupId();
    }

    public OffsetDateTime getScheduledEnqueueTime() {
        return this.getOffsetDateTimeValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.SCHEDULED_ENQUEUE_UTC_TIME_NAME.getValue());
    }

    public long getSequenceNumber() {
        return this.getLongValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
    }

    public String getSessionId() {
        return this.getRawAmqpMessage().getProperties().getGroupId();
    }

    public ServiceBusMessageState getState() {
        Object value = this.amqpAnnotatedMessage.getMessageAnnotations().get(AmqpMessageConstant.MESSAGE_STATE_ANNOTATION_NAME.getValue());
        if (value instanceof Integer) {
            return ServiceBusMessageState.fromValue((Integer)value);
        }
        return ServiceBusMessageState.ACTIVE;
    }

    public String getSubject() {
        return this.amqpAnnotatedMessage.getProperties().getSubject();
    }

    public Duration getTimeToLive() {
        return this.amqpAnnotatedMessage.getHeader().getTimeToLive();
    }

    public String getTo() {
        String to = null;
        AmqpAddress amqpAddress = this.amqpAnnotatedMessage.getProperties().getTo();
        if (amqpAddress != null) {
            to = amqpAddress.toString();
        }
        return to;
    }

    ServiceBusReceivedMessage addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }

    boolean isSettled() {
        return this.isSettled;
    }

    void setCorrelationId(String correlationId) {
        AmqpMessageId id = null;
        if (correlationId != null) {
            id = new AmqpMessageId(correlationId);
        }
        this.amqpAnnotatedMessage.getProperties().setCorrelationId(id);
    }

    void setContentType(String contentType) {
        this.amqpAnnotatedMessage.getProperties().setContentType(contentType);
    }

    void setDeadLetterErrorDescription(String deadLetterErrorDescription) {
        this.amqpAnnotatedMessage.getApplicationProperties().put(AmqpMessageConstant.DEAD_LETTER_DESCRIPTION_ANNOTATION_NAME.getValue(), deadLetterErrorDescription);
    }

    void setDeadLetterReason(String deadLetterReason) {
        this.amqpAnnotatedMessage.getApplicationProperties().put(AmqpMessageConstant.DEAD_LETTER_REASON_ANNOTATION_NAME.getValue(), deadLetterReason);
    }

    void setDeadLetterSource(String deadLetterSource) {
        this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.DEAD_LETTER_SOURCE_KEY_ANNOTATION_NAME.getValue(), deadLetterSource);
    }

    void setDeliveryCount(long deliveryCount) {
        this.amqpAnnotatedMessage.getHeader().setDeliveryCount(Long.valueOf(deliveryCount));
    }

    void setEnqueuedSequenceNumber(long enqueuedSequenceNumber) {
        this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.ENQUEUED_SEQUENCE_NUMBER_ANNOTATION_NAME.getValue(), enqueuedSequenceNumber);
    }

    void setEnqueuedTime(OffsetDateTime enqueuedTime) {
        this.setValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME, enqueuedTime);
    }

    void setIsSettled() {
        this.isSettled = true;
    }

    void setLockToken(UUID lockToken) {
        this.lockToken = lockToken;
    }

    void setLockedUntil(OffsetDateTime lockedUntil) {
        this.setValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.LOCKED_UNTIL_KEY_ANNOTATION_NAME, lockedUntil);
    }

    void setMessageId(String messageId) {
        AmqpMessageId id = null;
        if (messageId != null) {
            id = new AmqpMessageId(messageId);
        }
        this.amqpAnnotatedMessage.getProperties().setMessageId(id);
    }

    void setPartitionKey(String partitionKey) {
        this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue(), partitionKey);
    }

    void setScheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
        this.setValue(this.amqpAnnotatedMessage.getMessageAnnotations(), AmqpMessageConstant.SCHEDULED_ENQUEUE_UTC_TIME_NAME, scheduledEnqueueTime);
    }

    void setSequenceNumber(long sequenceNumber) {
        this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue(), sequenceNumber);
    }

    void setSessionId(String sessionId) {
        this.amqpAnnotatedMessage.getProperties().setGroupId(sessionId);
    }

    void setSubject(String subject) {
        this.amqpAnnotatedMessage.getProperties().setSubject(subject);
    }

    void setTimeToLive(Duration timeToLive) {
        this.amqpAnnotatedMessage.getHeader().setTimeToLive(timeToLive);
    }

    void setReplyTo(String replyTo) {
        AmqpAddress replyToAddress = null;
        if (replyTo != null) {
            replyToAddress = new AmqpAddress(replyTo);
        }
        this.amqpAnnotatedMessage.getProperties().setReplyTo(replyToAddress);
    }

    void setReplyToSessionId(String replyToSessionId) {
        this.amqpAnnotatedMessage.getProperties().setReplyToGroupId(replyToSessionId);
    }

    void setTo(String to) {
        AmqpAddress toAddress = null;
        if (to != null) {
            toAddress = new AmqpAddress(to);
        }
        this.amqpAnnotatedMessage.getProperties().setTo(toAddress);
    }

    private String getStringValue(Map<String, Object> dataMap, String key) {
        return (String)dataMap.get(key);
    }

    private long getLongValue(Map<String, Object> dataMap, String key) {
        return dataMap.containsKey(key) ? (Long)dataMap.get(key) : 0L;
    }

    private OffsetDateTime getOffsetDateTimeValue(Map<String, Object> dataMap, String key) {
        return dataMap.containsKey(key) ? ((Date)dataMap.get(key)).toInstant().atOffset(ZoneOffset.UTC) : null;
    }

    private void setValue(Map<String, Object> dataMap, AmqpMessageConstant key, OffsetDateTime value) {
        if (value != null) {
            this.amqpAnnotatedMessage.getMessageAnnotations().put(key.getValue(), new Date(value.toInstant().toEpochMilli()));
        }
    }
}

