// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.util.ArrayList;
import java.util.List;

/** The CorrelationFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("CorrelationFilter")
@JacksonXmlRootElement(localName = "CorrelationFilter")
@Fluent
public final class CorrelationFilterImpl extends RuleFilterImpl {
    /*
     * The correlationId property.
     */
    @JacksonXmlProperty(
            localName = "CorrelationId",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String correlationId;

    /*
     * The messageId property.
     */
    @JacksonXmlProperty(
            localName = "MessageId",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String messageId;

    /*
     * The to property.
     */
    @JacksonXmlProperty(
            localName = "To",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String to;

    /*
     * The replyTo property.
     */
    @JacksonXmlProperty(
            localName = "ReplyTo",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String replyTo;

    /*
     * The label property.
     */
    @JacksonXmlProperty(
            localName = "Label",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String label;

    /*
     * The sessionId property.
     */
    @JacksonXmlProperty(
            localName = "SessionId",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String sessionId;

    /*
     * The replyToSessionId property.
     */
    @JacksonXmlProperty(
            localName = "ReplyToSessionId",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String replyToSessionId;

    /*
     * The contentType property.
     */
    @JacksonXmlProperty(
            localName = "ContentType",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private String contentType;

    private static final class PropertiesWrapper {
        @JacksonXmlProperty(localName = "KeyValueOfstringanyType", namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
        private final List<KeyValueImpl> items;

        @JsonCreator
        private PropertiesWrapper(@JacksonXmlProperty(localName = "KeyValueOfstringanyType", namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect") List<KeyValueImpl> items) {
            this.items = items;
        }
    }

    /*
     * The properties property.
     */
    @JacksonXmlProperty(
            localName = "Properties",
            namespace = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect")
    private PropertiesWrapper properties;

    /**
     * Get the correlationId property: The correlationId property.
     *
     * @return the correlationId value.
     */
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: The correlationId property.
     *
     * @param correlationId the correlationId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the messageId property: The messageId property.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The messageId property.
     *
     * @param messageId the messageId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the to property: The to property.
     *
     * @return the to value.
     */
    public String getTo() {
        return this.to;
    }

    /**
     * Set the to property: The to property.
     *
     * @param to the to value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setTo(String to) {
        this.to = to;
        return this;
    }

    /**
     * Get the replyTo property: The replyTo property.
     *
     * @return the replyTo value.
     */
    public String getReplyTo() {
        return this.replyTo;
    }

    /**
     * Set the replyTo property: The replyTo property.
     *
     * @param replyTo the replyTo value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    /**
     * Get the label property: The label property.
     *
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: The label property.
     *
     * @param label the label value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the sessionId property: The sessionId property.
     *
     * @return the sessionId value.
     */
    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * Set the sessionId property: The sessionId property.
     *
     * @param sessionId the sessionId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    /**
     * Get the replyToSessionId property: The replyToSessionId property.
     *
     * @return the replyToSessionId value.
     */
    public String getReplyToSessionId() {
        return this.replyToSessionId;
    }

    /**
     * Set the replyToSessionId property: The replyToSessionId property.
     *
     * @param replyToSessionId the replyToSessionId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setReplyToSessionId(String replyToSessionId) {
        this.replyToSessionId = replyToSessionId;
        return this;
    }

    /**
     * Get the contentType property: The contentType property.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The contentType property.
     *
     * @param contentType the contentType value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the properties property: The properties property.
     *
     * @return the properties value.
     */
    public List<KeyValueImpl> getProperties() {
        if (this.properties == null) {
            this.properties = new PropertiesWrapper(new ArrayList<KeyValueImpl>());
        }
        return this.properties.items;
    }

    /**
     * Set the properties property: The properties property.
     *
     * @param properties the properties value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setProperties(List<KeyValueImpl> properties) {
        this.properties = new PropertiesWrapper(properties);
        return this;
    }
}
