/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.implementation.NamespacesImpl;
import com.azure.messaging.servicebus.implementation.RulesImpl;
import com.azure.messaging.servicebus.implementation.SubscriptionsImpl;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class ServiceBusManagementClientImpl {
    private final ServiceBusManagementClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final EntitiesImpl entities;
    private final SubscriptionsImpl subscriptions;
    private final RulesImpl rules;
    private final NamespacesImpl namespaces;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EntitiesImpl getEntities() {
        return this.entities;
    }

    public SubscriptionsImpl getSubscriptions() {
        return this.subscriptions;
    }

    public RulesImpl getRules() {
        return this.rules;
    }

    public NamespacesImpl getNamespaces() {
        return this.namespaces;
    }

    ServiceBusManagementClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.serializerAdapter = serializerAdapter;
        this.entities = new EntitiesImpl(this);
        this.subscriptions = new SubscriptionsImpl(this);
        this.rules = new RulesImpl(this);
        this.namespaces = new NamespacesImpl(this);
        this.service = (ServiceBusManagementClientService)RestProxy.create(ServiceBusManagementClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> listSubscriptionsWithResponseAsync(String topicName, Integer skip, Integer top, Context context) {
        return this.service.listSubscriptions(this.getEndpoint(), topicName, skip, top, this.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> listRulesWithResponseAsync(String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        return this.service.listRules(this.getEndpoint(), topicName, subscriptionName, skip, top, this.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> listEntitiesWithResponseAsync(String entityType, Integer skip, Integer top, Context context) {
        return this.service.listEntities(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface ServiceBusManagementClientService {
        @Get(value="/{topicName}/subscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> listSubscriptions(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, Context var6);

        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> listRules(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, Context var7);

        @Get(value="/$Resources/{entityType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> listEntities(@HostParam(value="endpoint") String var1, @PathParam(value="entityType") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, Context var6);
    }
}

