/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.RuleActionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescription;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescription;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeed;
import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class EntityHelper {
    private static final ClientLogger LOGGER = new ClientLogger(EntityHelper.class);
    public static final String CONTENT_TYPE = "application/xml";
    public static final String QUEUES_ENTITY_TYPE = "queues";
    public static final String TOPICS_ENTITY_TYPE = "topics";
    public static final int NUMBER_OF_ELEMENTS = 100;
    private static QueueAccessor queueAccessor;
    private static SubscriptionAccessor subscriptionAccessor;
    private static TopicAccessor topicAccessor;
    private static RuleAccessor ruleAccessor;

    public static QueueDescription getQueueDescription(CreateQueueOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        QueueDescription description = new QueueDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        if (options.getMaxMessageSizeInKilobytes() != 0L) {
            description.setMaxMessageSizeInKilobytes(options.getMaxMessageSizeInKilobytes());
        }
        return description;
    }

    public static SubscriptionDescription getSubscriptionDescription(CreateSubscriptionOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return new SubscriptionDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnFilterEvaluationExceptions(options.isDeadLetteringOnFilterEvaluationExceptions()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
    }

    public static TopicDescription getTopicDescription(CreateTopicOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        TopicDescription description = new TopicDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setSupportOrdering(options.isSupportOrdering()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        if (options.getMaxMessageSizeInKilobytes() != 0L) {
            description.setMaxMessageSizeInKilobytes(options.getMaxMessageSizeInKilobytes());
        }
        return description;
    }

    public static QueueDescription toImplementation(QueueProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        List<AuthorizationRuleImpl> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return queueAccessor.toImplementation(properties, rules);
    }

    public static RuleActionImpl toImplementation(RuleAction properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleDescription toImplementation(RuleProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleFilterImpl toImplementation(RuleFilter properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static SubscriptionDescription toImplementation(SubscriptionProperties description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toImplementation(description);
    }

    public static TopicDescription toImplementation(TopicProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        List<AuthorizationRuleImpl> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return topicAccessor.toImplementation(properties, rules);
    }

    public static QueueProperties toModel(QueueDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        return queueAccessor.toModel(description);
    }

    public static RuleAction toModel(RuleActionImpl description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static RuleFilter toModel(RuleFilterImpl description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static RuleProperties toModel(RuleDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static SubscriptionProperties toModel(SubscriptionDescription options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toModel(options);
    }

    public static TopicProperties toModel(TopicDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        return topicAccessor.toModel(description);
    }

    public static void setQueueAccessor(QueueAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (queueAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'accessor' is already set."));
        }
        queueAccessor = accessor;
    }

    public static void setQueueName(QueueProperties queueProperties, String name) {
        if (queueAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        queueAccessor.setName(queueProperties, name);
    }

    public static void setRuleAccessor(RuleAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (ruleAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' is already set."));
        }
        ruleAccessor = accessor;
    }

    public static void setSubscriptionAccessor(SubscriptionAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (subscriptionAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' is already set."));
        }
        subscriptionAccessor = accessor;
    }

    public static void setSubscriptionName(SubscriptionProperties subscription, String subscriptionName) {
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setSubscriptionName(subscription, subscriptionName);
    }

    public static void setTopicAccessor(TopicAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (topicAccessor != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' is already set."));
        }
        topicAccessor = accessor;
    }

    public static void setTopicName(SubscriptionProperties subscription, String topicName) {
        if (subscriptionAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setTopicName(subscription, topicName);
    }

    public static void setTopicName(TopicProperties topicProperties, String topicName) {
        if (topicAccessor == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        topicAccessor.setName(topicProperties, topicName);
    }

    private static List<AuthorizationRuleImpl> toImplementation(List<AuthorizationRule> rules) {
        return rules.stream().map(rule -> {
            AuthorizationRuleImpl implementation = new AuthorizationRuleImpl().setClaimType(rule.getClaimType()).setClaimValue(rule.getClaimValue()).setCreatedTime(rule.getCreatedAt()).setKeyName(rule.getKeyName()).setModifiedTime(rule.getModifiedAt()).setPrimaryKey(rule.getPrimaryKey()).setSecondaryKey(rule.getSecondaryKey()).setRights(rule.getAccessRights());
            if (rule instanceof SharedAccessAuthorizationRule) {
                implementation.setType("SharedAccessAuthorizationRule");
            } else {
                String className = rule.getClass().getName();
                LOGGER.warning("AuthorizationRule type '{}' is unknown.", new Object[]{className});
                implementation.setType(className);
            }
            return implementation;
        }).collect(Collectors.toList());
    }

    public static void addSupplementaryAuthHeader(String headerName, String entity, Context context) {
        context.getData((Object)"azure-http-headers-key").ifPresent(headers -> {
            if (headers instanceof HttpHeaders) {
                HttpHeaders customHttpHeaders = (HttpHeaders)headers;
                customHttpHeaders.add(headerName, entity);
            }
        });
    }

    public static CreateQueueBody getCreateQueueBody(QueueDescription createQueueOptions) {
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(createQueueOptions);
        return new CreateQueueBody().setContent(content);
    }

    public static CreateTopicBody getUpdateTopicBody(TopicProperties topic) {
        TopicDescription implementation = EntityHelper.toImplementation(topic);
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(implementation);
        return new CreateTopicBody().setContent(content);
    }

    public static CreateTopicBody getCreateTopicBody(TopicDescription topicOptions) {
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(topicOptions);
        return new CreateTopicBody().setContent(content);
    }

    public static CreateRuleBody getUpdateRuleBody(RuleProperties rule) {
        RuleDescription implementation = EntityHelper.toImplementation(rule);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(implementation);
        return new CreateRuleBody().setContent(content);
    }

    public static CreateSubscriptionBody getUpdateSubscriptionBody(SubscriptionProperties subscription) {
        SubscriptionDescription implementation = EntityHelper.toImplementation(subscription);
        CreateSubscriptionBodyContent content = new CreateSubscriptionBodyContent().setType(CONTENT_TYPE).setSubscriptionDescription(implementation);
        return new CreateSubscriptionBody().setContent(content);
    }

    public static CreateSubscriptionBody getCreateSubscriptionBody(SubscriptionDescription subscriptionDescription) {
        CreateSubscriptionBodyContent content = new CreateSubscriptionBodyContent().setType(CONTENT_TYPE).setSubscriptionDescription(subscriptionDescription);
        return new CreateSubscriptionBody().setContent(content);
    }

    public static CreateRuleBody getCreateRuleBody(String ruleName, CreateRuleOptions ruleOptions) {
        RuleActionImpl action = ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null;
        RuleFilterImpl filter = ruleOptions.getFilter() != null ? EntityHelper.toImplementation(ruleOptions.getFilter()) : null;
        RuleDescription rule = new RuleDescription().setAction(action).setFilter(filter).setName(ruleName);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(rule);
        return new CreateRuleBody().setContent(content);
    }

    public static List<TopicProperties> getTopics(TopicDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getTopicDescription() != null).map(EntityHelper::getTopicProperties).collect(Collectors.toList());
    }

    public static List<QueueProperties> getQueues(QueueDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getQueueDescription() != null).map(EntityHelper::getQueueProperties).collect(Collectors.toList());
    }

    public static QueueProperties getQueueProperties(QueueDescriptionEntry e) {
        String queueName = EntityHelper.getTitleValue(e.getTitle());
        QueueProperties queueProperties = EntityHelper.toModel(e.getContent().getQueueDescription());
        EntityHelper.setQueueName(queueProperties, queueName);
        return queueProperties;
    }

    public static List<RuleProperties> getRules(RuleDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getRuleDescription() != null).map(e -> EntityHelper.toModel(e.getContent().getRuleDescription())).collect(Collectors.toList());
    }

    public static List<SubscriptionProperties> getSubscriptions(String topicName, SubscriptionDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getSubscriptionDescription() != null).map(e -> EntityHelper.getSubscriptionProperties(topicName, e)).collect(Collectors.toList());
    }

    public static SubscriptionProperties getSubscriptionProperties(String topicName, SubscriptionDescriptionEntry entry) {
        SubscriptionProperties subscription = EntityHelper.toModel(entry.getContent().getSubscriptionDescription());
        String subscriptionName = EntityHelper.getTitleValue(entry.getTitle());
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return subscription;
    }

    public static TopicProperties getTopicProperties(TopicDescriptionEntry entry) {
        TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
        String topicName = EntityHelper.getTitleValue(entry.getTitle());
        EntityHelper.setTopicName(result, topicName);
        return result;
    }

    public static SimpleResponse<SubscriptionProperties> getSubscriptionPropertiesSimpleResponse(String topicName, Response<Object> response, SubscriptionDescriptionEntry entry) {
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        SubscriptionProperties subscription = EntityHelper.getSubscriptionProperties(topicName, entry);
        String subscriptionName = EntityHelper.getTitleValue(entry.getTitle());
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)subscription);
    }

    public static SimpleResponse<RuleProperties> getRulePropertiesSimpleResponse(Response<Object> response, RuleDescriptionEntry entry) {
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        RuleDescription description = entry.getContent().getRuleDescription();
        RuleProperties result = EntityHelper.toModel(description);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    public static String getTitleValue(Object responseTitle) {
        if (!(responseTitle instanceof Map)) {
            return null;
        }
        try {
            Map map = (Map)responseTitle;
            return (String)map.get("");
        }
        catch (ClassCastException error) {
            LOGGER.warning("Unable to cast to Map<String,String>. Title: {}", new Object[]{responseTitle, error});
            return null;
        }
    }

    public static void validateQueueName(String queueName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
    }

    public static void validateRuleName(String ruleName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)ruleName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'ruleName' cannot be null or empty."));
        }
    }

    public static void validateTopicName(String topicName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
    }

    public static void validateSubscriptionName(String subscriptionName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
    }

    public static Context getTracingContext(Context context) {
        context = context == null ? Context.NONE : context;
        return context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
    }

    public static <TResult, TFeed> FeedPage<TResult> extractPage(Response<TFeed> response, List<TResult> entities, List<ResponseLink> responseLinks) throws MalformedURLException, UnsupportedEncodingException {
        Optional<ResponseLink> nextLink = responseLinks.stream().filter(link -> link.getRel().equalsIgnoreCase("next")).findFirst();
        if (!nextLink.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
        }
        URL url = new URL(nextLink.get().getHref());
        String decode = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.toString());
        Optional<Integer> skipParameter = Arrays.stream(decode.split("&amp;|&")).map(part -> part.split("=", 2)).filter(parts -> parts[0].equalsIgnoreCase("$skip") && ((String[])parts).length == 2).map(parts -> Integer.valueOf(parts[1])).findFirst();
        if (skipParameter.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities, skipParameter.get());
        }
        LOGGER.warning("There should have been a skip parameter for the next page.");
        return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
    }

    static {
        try {
            Class.forName(QueueProperties.class.getName(), true, QueueProperties.class.getClassLoader());
            Class.forName(SubscriptionProperties.class.getName(), true, SubscriptionProperties.class.getClassLoader());
            Class.forName(TopicProperties.class.getName(), true, TopicProperties.class.getClassLoader());
            Class.forName(RuleProperties.class.getName(), true, RuleProperties.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static interface QueueAccessor {
        public QueueDescription toImplementation(QueueProperties var1, List<AuthorizationRuleImpl> var2);

        public QueueProperties toModel(QueueDescription var1);

        public void setName(QueueProperties var1, String var2);
    }

    public static interface RuleAccessor {
        public RuleProperties toModel(RuleDescription var1);

        public RuleAction toModel(RuleActionImpl var1);

        public RuleFilter toModel(RuleFilterImpl var1);

        public RuleDescription toImplementation(RuleProperties var1);

        public RuleActionImpl toImplementation(RuleAction var1);

        public RuleFilterImpl toImplementation(RuleFilter var1);
    }

    public static interface SubscriptionAccessor {
        public SubscriptionProperties toModel(SubscriptionDescription var1);

        public SubscriptionDescription toImplementation(SubscriptionProperties var1);

        public void setTopicName(SubscriptionProperties var1, String var2);

        public void setSubscriptionName(SubscriptionProperties var1, String var2);
    }

    public static interface TopicAccessor {
        public TopicDescription toImplementation(TopicProperties var1, List<AuthorizationRuleImpl> var2);

        public TopicProperties toModel(TopicDescription var1);

        public void setName(TopicProperties var1, String var2);
    }

    public static final class FeedPage<T>
    implements PagedResponse<T> {
        private final int statusCode;
        private final HttpHeaders header;
        private final HttpRequest request;
        private final IterableStream<T> entries;
        private final String continuationToken;

        public FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = null;
        }

        public FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries, int skip) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = String.valueOf(skip);
        }

        public IterableStream<T> getElements() {
            return this.entries;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.header;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void close() {
        }
    }

    public static final class EntityNotFoundHttpResponse<T>
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;

        public EntityNotFoundHttpResponse(Response<T> response) {
            super(response.getRequest());
            this.headers = response.getHeaders();
            this.statusCode = response.getStatusCode();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    }
}

