/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import java.time.OffsetDateTime;
import java.util.Objects;

public class QueueRuntimeProperties {
    private final String name;
    private final long messageCount;
    private final long sizeInBytes;
    private final OffsetDateTime accessedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final int activeMessageCount;
    private final int deadLetterMessageCount;
    private final int scheduledMessageCount;
    private final int transferDeadLetterMessageCount;
    private final int transferMessageCount;

    public QueueRuntimeProperties(QueueProperties queueProperties) {
        Objects.requireNonNull(queueProperties, "'queueProperties' cannot be null.");
        this.name = queueProperties.getName();
        this.messageCount = queueProperties.getMessageCount().intValue();
        this.sizeInBytes = queueProperties.getSizeInBytes().intValue();
        this.accessedAt = queueProperties.getAccessedAt();
        this.createdAt = queueProperties.getCreatedAt();
        this.updatedAt = queueProperties.getUpdatedAt();
        MessageCountDetails details = queueProperties.getMessageCountDetails();
        this.activeMessageCount = details != null ? details.getActiveMessageCount() : 0;
        this.deadLetterMessageCount = details != null ? details.getDeadLetterMessageCount() : 0;
        this.scheduledMessageCount = details != null ? details.getScheduledMessageCount() : 0;
        this.transferDeadLetterMessageCount = details != null ? details.getTransferDeadLetterMessageCount() : 0;
        this.transferMessageCount = details != null ? details.getTransferMessageCount() : 0;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public int getActiveMessageCount() {
        return this.activeMessageCount;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public int getDeadLetterMessageCount() {
        return this.deadLetterMessageCount;
    }

    public long getTotalMessageCount() {
        return this.messageCount;
    }

    public String getName() {
        return this.name;
    }

    public int getScheduledMessageCount() {
        return this.scheduledMessageCount;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getTransferDeadLetterMessageCount() {
        return this.transferDeadLetterMessageCount;
    }

    public int getTransferMessageCount() {
        return this.transferMessageCount;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

