/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import java.time.Duration;
import org.apache.qpid.proton.amqp.Symbol;

public class ServiceBusConstants {
    public static final String AZURE_ACTIVE_DIRECTORY_SCOPE = "https://servicebus.azure.net/.default";
    public static final Duration OPERATION_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration TOKEN_VALIDITY = Duration.ofMinutes(20L);
    public static final String AZ_TRACING_NAMESPACE_VALUE = "Microsoft.ServiceBus";
    public static final String SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME = "ServiceBusSupplementaryAuthorization";
    public static final String SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME = "ServiceBusDlqSupplementaryAuthorization";
    public static final Duration MAX_DURATION = Duration.parse("P10675199DT2H48M5.4775807S");
    public static final Duration DEFAULT_LOCK_DURATION = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_DUPLICATE_DETECTION_DURATION = Duration.ofSeconds(60L);
    public static final int DEFAULT_MAX_DELIVERY_COUNT = 10;
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    public static final int DEFAULT_TOPIC_SIZE = 1024;
    public static final Duration MAX_RENEWAL_BUFFER_DURATION = Duration.ofSeconds(10L);
    public static final String LOCK_TOKEN_KEY = "lockToken";
    public static final String WORK_ID_KEY = "workId";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String MESSAGE_ID_LOGGING_KEY = "messageId";
    public static final String ENTITY_TYPE_KEY = "entityType";
    public static final String SEQUENCE_NUMBER_KEY = "sequenceNumber";
    public static final String DELIVERY_STATE_KEY = "deliveryState";
    public static final String NUMBER_OF_REQUESTED_MESSAGES_KEY = "requested";
    public static final String DISPOSITION_STATUS_KEY = "dispositionStatus";
    public static final String URI_NAME = "com.microsoft:uri";
    public static final String DURATION_NAME = "com.microsoft:timespan";
    public static final String OFFSETDATETIME_NAME = "com.microsoft:datetime-offset";
    public static final Symbol URI_SYMBOL = Symbol.valueOf((String)"com.microsoft:uri");
    public static final Symbol DURATION_SYMBOL = Symbol.valueOf((String)"com.microsoft:timespan");
    public static final Symbol OFFSETDATETIME_SYMBOL = Symbol.valueOf((String)"com.microsoft:datetime-offset");
    public static final Long EPOCH_TICKS = 621355968000000000L;
    public static final Long TICK_PER_SECOND = 10000000L;
    public static final Long NANO_PER_SECOND = 1000000000L;
    public static final Long TIME_LENGTH_DELTA = NANO_PER_SECOND / TICK_PER_SECOND;
}

