/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusMeter;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.publisher.Mono;

public class ServiceBusReceiverInstrumentation {
    private final ServiceBusMeter meter;
    private final ServiceBusTracer tracer;
    private final boolean isSync;

    public ServiceBusReceiverInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityPath, String subscriptionName, boolean isSync) {
        this.tracer = new ServiceBusTracer(tracer, fullyQualifiedName, entityPath);
        this.meter = new ServiceBusMeter(meter, fullyQualifiedName, entityPath, subscriptionName);
        this.isSync = isSync;
    }

    public AutoCloseable startTrackingSettlementSequenceNumber() {
        return this.meter.isSettlementEnabled() ? this.meter.trackSettlementSequenceNumber() : null;
    }

    public Context instrumentProcess(String name, ServiceBusReceivedMessage message, Context parent) {
        if (!this.tracer.isEnabled() && !this.meter.isConsumerLagEnabled()) {
            return parent;
        }
        Context span = this.tracer.isEnabled() && !this.isSync ? this.tracer.startProcessSpan(name, message, parent) : parent;
        this.meter.reportConsumerLag(message.getEnqueuedTime(), span);
        return span;
    }

    public <T> Mono<T> instrumentSettlement(Mono<T> publisher, ServiceBusReceivedMessage message, Context messageContext, DispositionStatus status) {
        if (this.tracer.isEnabled() || this.meter.isSettlementEnabled()) {
            AtomicLong startTime = new AtomicLong();
            return publisher.doOnEach(signal -> {
                Context span = (Context)signal.getContextView().getOrDefault((Object)"otel-context-key", (Object)Context.NONE);
                this.meter.reportSettlement(startTime.get(), message.getSequenceNumber(), status, signal.getThrowable(), span);
                this.tracer.endSpan(signal.getThrowable(), span, null);
            }).contextWrite(ctx -> {
                startTime.set(Instant.now().toEpochMilli());
                return ctx.put((Object)"otel-context-key", (Object)this.tracer.startSpanWithLink(ServiceBusReceiverInstrumentation.getSettlementSpanName(status), message, messageContext, Context.NONE));
            });
        }
        return publisher;
    }

    public ServiceBusTracer getTracer() {
        return this.tracer;
    }

    private static String getSettlementSpanName(DispositionStatus status) {
        switch (status) {
            case COMPLETED: {
                return "ServiceBus.complete";
            }
            case ABANDONED: {
                return "ServiceBus.abandon";
            }
            case DEFERRED: {
                return "ServiceBus.defer";
            }
            case SUSPENDED: {
                return "ServiceBus.deadLetter";
            }
            case RELEASED: {
                return "ServiceBus.release";
            }
        }
        return "ServiceBus.unknown";
    }
}

