/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.RulesImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBody;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeed;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.QueueRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.administration.models.TopicRuntimeProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=ServiceBusAdministrationClientBuilder.class)
public final class ServiceBusAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusAdministrationClient.class);
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private final ServiceBusManagementClientImpl managementClient;
    private final EntitiesImpl entityClient;
    private final ServiceBusManagementSerializer serializer;
    private final RulesImpl rulesClient;

    ServiceBusAdministrationClient(ServiceBusManagementClientImpl managementClient, ServiceBusManagementSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        this.managementClient = Objects.requireNonNull(managementClient, "'managementClient' cannot be null.");
        this.entityClient = managementClient.getEntities();
        this.rulesClient = managementClient.getRules();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName) {
        return this.createQueue(queueName, new CreateQueueOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName, CreateQueueOptions queueOptions) {
        return (QueueProperties)this.createQueueWithResponse(queueName, queueOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> createQueueWithResponse(String queueName, CreateQueueOptions queueOptions, Context context) {
        String forwardDlq;
        EntityHelper.validateQueueName(queueName);
        if (queueOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'queueOptions' cannot be null."));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = ServiceBusAdministrationClient.enableSyncContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(queueOptions.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            queueOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(queueOptions.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            queueOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        CreateQueueBody createEntity = EntityHelper.getCreateQueueBody(EntityHelper.getQueueDescription(queueOptions));
        return this.deserializeQueue(this.entityClient.putSyncWithResponse(queueName, createEntity, null, contextWithHeaders));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String subscriptionName, String ruleName) {
        return this.createRule(topicName, ruleName, subscriptionName, new CreateRuleOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String ruleName, String subscriptionName, CreateRuleOptions ruleOptions) {
        return (RuleProperties)this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        EntityHelper.validateTopicName(topicName);
        EntityHelper.validateSubscriptionName(subscriptionName);
        EntityHelper.validateRuleName(ruleName);
        if (ruleOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'ruleOptions' cannot be null."));
        }
        CreateRuleBody createEntity = EntityHelper.getCreateRuleBody(ruleName, ruleOptions);
        return this.deserializeRule(this.managementClient.getRules().putSyncWithResponse(topicName, subscriptionName, ruleName, createEntity, null, ServiceBusAdministrationClient.enableSyncContext(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName) {
        return this.createSubscription(topicName, subscriptionName, new CreateSubscriptionOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return (SubscriptionProperties)this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions) {
        return (SubscriptionProperties)this.createSubscriptionWithResponse(topicName, subscriptionName, ruleName, subscriptionOptions, ruleOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions, Context context) {
        String forwardDlq;
        EntityHelper.validateTopicName(topicName);
        EntityHelper.validateSubscriptionName(subscriptionName);
        if (subscriptionOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'subscriptionOptions' cannot be null."));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = ServiceBusAdministrationClient.enableSyncContext(EntityHelper.getTracingContext(context).addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(subscriptionOptions.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            subscriptionOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscriptionOptions.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            subscriptionOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        CreateSubscriptionBody createEntity = EntityHelper.getCreateSubscriptionBody(EntityHelper.getSubscriptionDescription(subscriptionOptions));
        return this.deserializeSubscription(topicName, this.managementClient.getSubscriptions().putSyncWithResponse(topicName, subscriptionName, createEntity, null, contextWithHeaders));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> createSubscriptionWithResponse(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions, Context context) {
        if (ruleOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'CreateRuleOptions' cannot be null."));
        }
        Objects.requireNonNull(ruleOptions.getFilter(), "'RuleFilter' cannot be null.");
        RuleDescription rule = new RuleDescription().setAction(ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null).setFilter(EntityHelper.toImplementation(ruleOptions.getFilter())).setName(ruleName);
        subscriptionOptions.setDefaultRule(EntityHelper.toModel(rule));
        return this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName) {
        return this.createTopic(topicName, new CreateTopicOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName, CreateTopicOptions topicOptions) {
        return (TopicProperties)this.createTopicWithResponse(topicName, topicOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions, Context context) {
        EntityHelper.validateTopicName(topicName);
        if (topicOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'topicOptions' cannot be null."));
        }
        CreateTopicBody createEntity = EntityHelper.getCreateTopicBody(EntityHelper.getTopicDescription(topicOptions));
        return this.deserializeTopic(this.entityClient.putSyncWithResponse(topicName, createEntity, null, ServiceBusAdministrationClient.enableSyncContext(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteQueue(String queueName) {
        this.deleteQueueWithResponse(queueName, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteQueueWithResponse(String queueName, Context context) {
        EntityHelper.validateQueueName(queueName);
        Response<Object> response = this.entityClient.deleteSyncWithResponse(queueName, ServiceBusAdministrationClient.enableSyncContext(context));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRule(String topicName, String subscriptionName, String ruleName) {
        this.deleteRuleWithResponse(topicName, subscriptionName, ruleName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        EntityHelper.validateTopicName(topicName);
        EntityHelper.validateSubscriptionName(subscriptionName);
        EntityHelper.validateRuleName(ruleName);
        Response<Object> response = this.rulesClient.deleteSyncWithResponse(topicName, subscriptionName, ruleName, ServiceBusAdministrationClient.enableSyncContext(context));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubscription(String topicName, String subscriptionName) {
        this.deleteSubscriptionWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        EntityHelper.validateSubscriptionName(subscriptionName);
        EntityHelper.validateTopicName(topicName);
        Response<Object> response = this.managementClient.getSubscriptions().deleteSyncWithResponse(topicName, subscriptionName, ServiceBusAdministrationClient.enableSyncContext(context));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTopic(String topicName) {
        this.deleteTopicWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTopicWithResponse(String topicName, Context context) {
        EntityHelper.validateTopicName(topicName);
        Response<Object> response = this.entityClient.deleteSyncWithResponse(topicName, ServiceBusAdministrationClient.enableSyncContext(context));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties getQueue(String queueName) {
        return (QueueProperties)this.getQueueWithResponse(queueName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> getQueueWithResponse(String queueName, Context context) {
        Response<QueueProperties> response = this.getQueueInternal(queueName, context);
        if (response.getValue() == null) {
            EntityHelper.EntityNotFoundHttpResponse<QueueProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<QueueProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Queue '%s' does not exist.", queueName), notFoundResponse));
        }
        return response;
    }

    private Response<QueueProperties> getQueueInternal(String queueName, Context context) {
        EntityHelper.validateQueueName(queueName);
        Response<Object> response = this.entityClient.getSyncWithResponse(queueName, true, ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeQueue(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getQueueExists(String queueName) {
        Boolean exists = (Boolean)this.getQueueExistsWithResponse(queueName, null).getValue();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getQueueExistsWithResponse(String queueName, Context context) {
        Response<QueueProperties> queueWithResponse = this.getQueueInternal(queueName, context);
        return this.getEntityExistsWithResponse(queueWithResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueRuntimeProperties getQueueRuntimeProperties(String queueName) {
        return (QueueRuntimeProperties)this.getQueueRuntimePropertiesWithResponse(queueName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueRuntimeProperties> getQueueRuntimePropertiesWithResponse(String queueName, Context context) {
        Response<QueueProperties> response = this.getQueueWithResponse(queueName, context);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new QueueRuntimeProperties((QueueProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceProperties getNamespaceProperties() {
        return (NamespaceProperties)this.getNamespacePropertiesWithResponse(null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceProperties> getNamespacePropertiesWithResponse(Context context) {
        Response<NamespacePropertiesEntry> response = this.managementClient.getNamespaces().getSyncWithResponse(ServiceBusAdministrationClient.enableSyncContext(context));
        NamespacePropertiesEntry entry = (NamespacePropertiesEntry)response.getValue();
        if (entry == null || entry.getContent() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("There was no content inside namespace response. Entry: " + response));
        }
        NamespaceProperties namespaceProperties = entry.getContent().getNamespaceProperties();
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)namespaceProperties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties getRule(String topicName, String subscriptionName, String ruleName) {
        return (RuleProperties)this.getRuleWithResponse(topicName, subscriptionName, ruleName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> getRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        Response<Object> objectResponse = this.rulesClient.getSyncWithResponse(topicName, subscriptionName, ruleName, true, ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeRule(objectResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties getSubscription(String topicName, String subscriptionName) {
        return (SubscriptionProperties)this.getSubscriptionWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> getSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        return this.getSubscriptionInternal(topicName, subscriptionName, context);
    }

    private Response<SubscriptionProperties> getSubscriptionInternal(String topicName, String subscriptionName, Context context) {
        EntityHelper.validateTopicName(topicName);
        EntityHelper.validateSubscriptionName(subscriptionName);
        Response<Object> response = this.managementClient.getSubscriptions().getSyncWithResponse(topicName, subscriptionName, true, ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeSubscription(topicName, response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getSubscriptionExists(String topicName, String subscriptionName) {
        Boolean exists = (Boolean)this.getSubscriptionExistsWithResponse(topicName, subscriptionName, null).getValue();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getSubscriptionExistsWithResponse(String topicName, String subscriptionName, Context context) {
        Response<SubscriptionProperties> subscriptionWithResponse = this.getSubscriptionInternal(topicName, subscriptionName, context);
        return this.getEntityExistsWithResponse(subscriptionWithResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionRuntimeProperties getSubscriptionRuntimeProperties(String topicName, String subscriptionName) {
        return (SubscriptionRuntimeProperties)this.getSubscriptionRuntimePropertiesWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionRuntimeProperties> getSubscriptionRuntimePropertiesWithResponse(String topicName, String subscriptionName, Context context) {
        Response<SubscriptionProperties> response = this.getSubscriptionWithResponse(topicName, subscriptionName, context);
        if (response.getValue() == null) {
            EntityHelper.EntityNotFoundHttpResponse<SubscriptionProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<SubscriptionProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Subscription '%s' in topic '%s' does not exist.", topicName, subscriptionName), notFoundResponse));
        }
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new SubscriptionRuntimeProperties((SubscriptionProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties getTopic(String topicName) {
        return (TopicProperties)this.getTopicWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> getTopicWithResponse(String topicName, Context context) {
        Response<TopicProperties> response = this.getTopicInternal(topicName, context);
        if (response.getValue() == null) {
            EntityHelper.EntityNotFoundHttpResponse<TopicProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<TopicProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
        }
        return response;
    }

    private Response<TopicProperties> getTopicInternal(String topicName, Context context) {
        EntityHelper.validateTopicName(topicName);
        Response<Object> response = this.entityClient.getSyncWithResponse(topicName, true, ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeTopic(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getTopicExists(String topicName) {
        Boolean exists = (Boolean)this.getTopicExistsWithResponse(topicName, null).getValue();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getTopicExistsWithResponse(String topicName, Context context) {
        Response<TopicProperties> topicWithResponse = this.getTopicInternal(topicName, context);
        return this.getEntityExistsWithResponse(topicWithResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicRuntimeProperties getTopicRuntimeProperties(String topicName) {
        return (TopicRuntimeProperties)this.getTopicRuntimePropertiesWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicRuntimeProperties> getTopicRuntimePropertiesWithResponse(String topicName, Context context) {
        Response<TopicProperties> response = this.getTopicWithResponse(topicName, context);
        if (response.getValue() == null) {
            EntityHelper.EntityNotFoundHttpResponse<TopicProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<TopicProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
        }
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new TopicRuntimeProperties((TopicProperties)response.getValue()));
    }

    private <T> Response<Boolean> getEntityExistsWithResponse(Response<T> getEntityOperation) {
        boolean exists = getEntityOperation.getValue() != null;
        return new SimpleResponse(getEntityOperation.getRequest(), getEntityOperation.getStatusCode(), getEntityOperation.getHeaders(), (Object)exists);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues() {
        return this.listQueues(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues(Context context) {
        return new PagedIterable(() -> this.listQueues(0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listQueues(skip, context);
        });
    }

    private PagedResponse<QueueProperties> listQueues(int skip, Context context) {
        Response<Object> response = this.managementClient.listEntitiesSyncWithResponse("queues", skip, 100, ServiceBusAdministrationClient.enableSyncContext(context));
        QueueDescriptionFeed feed = this.deserialize(response.getValue(), QueueDescriptionFeed.class);
        if (feed == null) {
            LOGGER.warning("Could not deserialize QueueDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<QueueProperties> entities = EntityHelper.getQueues(feed);
        try {
            return EntityHelper.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleProperties> listRules(String topicName, String subscriptionName) {
        return this.listRules(topicName, subscriptionName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleProperties> listRules(String topicName, String subscriptionName, Context context) {
        return new PagedIterable(() -> this.listRules(topicName, subscriptionName, 0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listRules(topicName, subscriptionName, skip, context);
        });
    }

    private PagedResponse<RuleProperties> listRules(String topicName, String subscriptionName, int skip, Context context) {
        Response<Object> response = this.managementClient.listRulesSyncWithResponse(topicName, subscriptionName, skip, 100, ServiceBusAdministrationClient.enableSyncContext(context));
        RuleDescriptionFeed feed = this.deserialize(response.getValue(), RuleDescriptionFeed.class);
        if (feed == null) {
            LOGGER.warning("Could not deserialize RuleDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<RuleProperties> entities = EntityHelper.getRules(feed);
        try {
            return EntityHelper.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName) {
        return this.listSubscriptions(topicName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName, Context context) {
        return new PagedIterable(() -> this.listSubscriptions(topicName, 0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listSubscriptions(topicName, skip, context);
        });
    }

    private PagedResponse<SubscriptionProperties> listSubscriptions(String topicName, int skip, Context context) {
        Response<Object> response = this.managementClient.listSubscriptionsSyncWithResponse(topicName, skip, 100, ServiceBusAdministrationClient.enableSyncContext(context));
        SubscriptionDescriptionFeed feed = this.deserialize(response.getValue(), SubscriptionDescriptionFeed.class);
        if (feed == null) {
            LOGGER.warning("Could not deserialize SubscriptionDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<SubscriptionProperties> entities = EntityHelper.getSubscriptions(topicName, feed);
        try {
            return EntityHelper.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<SubscriptionDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics() {
        return this.listTopics(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics(Context context) {
        return new PagedIterable(() -> this.listTopics(0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listTopics(skip, context);
        });
    }

    private PagedResponse<TopicProperties> listTopics(int skip, Context context) {
        Response<Object> response = this.managementClient.listEntitiesSyncWithResponse("topics", skip, 100, ServiceBusAdministrationClient.enableSyncContext(context));
        TopicDescriptionFeed feed = this.deserialize(response.getValue(), TopicDescriptionFeed.class);
        if (feed == null) {
            LOGGER.warning("Could not deserialize TopicDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<TopicProperties> entities = EntityHelper.getTopics(feed);
        try {
            return EntityHelper.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<TopicDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties updateQueue(QueueProperties queue) {
        return (QueueProperties)this.updateQueueWithResponse(queue, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> updateQueueWithResponse(QueueProperties queue, Context context) {
        String forwardDlq;
        if (queue == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = ServiceBusAdministrationClient.enableSyncContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(queue.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            queue.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(queue.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            queue.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        CreateQueueBody createEntity = EntityHelper.getCreateQueueBody(EntityHelper.toImplementation(queue));
        Response<Object> response = this.entityClient.putSyncWithResponse(queue.getName(), createEntity, "*", contextWithHeaders);
        return this.deserializeQueue(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties updateRule(String topicName, String subscriptionName, RuleProperties rule) {
        return (RuleProperties)this.updateRuleWithResponse(topicName, subscriptionName, rule, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule, Context context) {
        if (rule == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'rule' cannot be null"));
        }
        Response<Object> response = this.managementClient.getRules().putSyncWithResponse(topicName, subscriptionName, rule.getName(), EntityHelper.getUpdateRuleBody(rule), "*", ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeRule(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties updateSubscription(SubscriptionProperties subscription) {
        return (SubscriptionProperties)this.updateSubscriptionWithResponse(subscription, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> updateSubscriptionWithResponse(SubscriptionProperties subscription, Context context) {
        String forwardDlq;
        if (subscription == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'subscription' cannot be null"));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = ServiceBusAdministrationClient.enableSyncContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(subscription.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            subscription.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscription.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            subscription.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        String topicName = subscription.getTopicName();
        CreateSubscriptionBody createEntity = EntityHelper.getUpdateSubscriptionBody(subscription);
        Response<Object> response = this.managementClient.getSubscriptions().putSyncWithResponse(topicName, subscription.getSubscriptionName(), createEntity, "*", contextWithHeaders);
        return this.deserializeSubscription(topicName, response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties updateTopic(TopicProperties topic) {
        return (TopicProperties)this.updateTopicWithResponse(topic, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> updateTopicWithResponse(TopicProperties topic, Context context) {
        if (topic == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'topic' cannot be null"));
        }
        CreateTopicBody createEntity = EntityHelper.getUpdateTopicBody(topic);
        Response<Object> response = this.entityClient.putSyncWithResponse(topic.getName(), createEntity, "*", ServiceBusAdministrationClient.enableSyncContext(context));
        return this.deserializeTopic(response);
    }

    private Response<QueueProperties> deserializeQueue(Response<Object> response) {
        TopicDescriptionEntry entryTopic;
        QueueDescriptionEntry entry = this.deserialize(response.getValue(), QueueDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getQueueDescription() == null && (entryTopic = this.deserialize(response.getValue(), TopicDescriptionEntry.class)) != null && entryTopic.getContent() != null && entryTopic.getContent().getTopicDescription() != null) {
            LOGGER.warning("'{}' is not a queue, it is a topic.", new Object[]{entryTopic.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        QueueProperties result = EntityHelper.getQueueProperties(entry);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private Response<RuleProperties> deserializeRule(Response<Object> response) {
        RuleDescriptionEntry entry = this.deserialize(response.getValue(), RuleDescriptionEntry.class);
        return EntityHelper.getRulePropertiesSimpleResponse(response, entry);
    }

    private Response<SubscriptionProperties> deserializeSubscription(String topicName, Response<Object> response) {
        SubscriptionDescriptionEntry entry = this.deserialize(response.getValue(), SubscriptionDescriptionEntry.class);
        return EntityHelper.getSubscriptionPropertiesSimpleResponse(topicName, response, entry);
    }

    private Response<TopicProperties> deserializeTopic(Response<Object> response) {
        QueueDescriptionEntry entryQueue;
        TopicDescriptionEntry entry = this.deserialize(response.getValue(), TopicDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getTopicDescription() == null && (entryQueue = this.deserialize(response.getValue(), QueueDescriptionEntry.class)) != null && entryQueue.getContent() != null && entryQueue.getContent().getQueueDescription() != null) {
            LOGGER.warning("'{}' is not a topic, it is a queue.", new Object[]{entryQueue.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        TopicProperties result = EntityHelper.getTopicProperties(entry);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private static Context enableSyncContext(Context context) {
        return EntityHelper.getTracingContext(context).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    private <T> T deserialize(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String contents = String.valueOf(object);
        if (contents.isEmpty()) {
            return null;
        }
        try {
            return this.serializer.deserialize(contents, clazz);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("Exception while deserializing. Body: [%s]. Class: %s", contents, clazz), e));
        }
    }

    private String getAbsoluteUrlFromEntity(String entity) {
        try {
            URL url = new URL(entity);
            return url.toString();
        }
        catch (MalformedURLException url) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setHost(this.managementClient.getEndpoint());
            urlBuilder.setPath(entity);
            try {
                URL url2 = urlBuilder.toUrl();
                return url2.toString();
            }
            catch (MalformedURLException ex) {
                LOGGER.error("Failed to construct URL using the endpoint:'{}' and entity:'{}'", new Object[]{this.managementClient.getEndpoint(), entity});
                LOGGER.logThrowableAsError((Throwable)ex);
                return null;
            }
        }
    }

    private String getForwardDlqEntity(String forwardDlqToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardDlqToEntity)) {
            EntityHelper.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardDlqToEntity);
        }
        return null;
    }

    private String getForwardToEntity(String forwardToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            EntityHelper.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardToEntity);
        }
        return null;
    }
}

