/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class Messages {
    private static Properties properties;
    public static final String MESSAGES_PROPERTIES_PATH = "azure-messaging-servicebus.properties";
    private static final ClientLogger LOGGER;
    public static final String CLASS_NOT_A_SUPPORTED_TYPE;
    public static final String INVALID_OPERATION_DISPOSED_RECEIVER;
    public static final String INVALID_OPERATION_DISPOSED_SENDER;
    public static final String INVALID_OPERATION_DISPOSED_RULE_MANAGER;
    public static final String MESSAGE_NOT_OF_TYPE;
    public static final String REQUEST_VALUE_NOT_VALID;
    public static final String PROCESS_SPAN_SCOPE_TYPE_ERROR;
    public static final String MESSAGE_PROCESSOR_RUN_END;

    private static synchronized Properties getProperties() {
        if (properties != null) {
            return properties;
        }
        properties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(MESSAGES_PROPERTIES_PATH);){
            if (inputStream != null) {
                properties.load(inputStream);
            } else {
                LOGGER.error("Message properties not found");
            }
        }
        catch (IOException exception) {
            LOGGER.error("Error loading message properties", new Object[]{exception});
        }
        return properties;
    }

    private static ClientLogger initializeLogger() {
        HashMap<String, String> loggingContext = new HashMap<String, String>(1);
        loggingContext.put("propertiesPath", MESSAGES_PROPERTIES_PATH);
        return new ClientLogger(Messages.class, loggingContext);
    }

    public static String getMessage(String key) {
        return String.valueOf(Messages.getProperties().getOrDefault((Object)key, key));
    }

    static {
        LOGGER = Messages.initializeLogger();
        CLASS_NOT_A_SUPPORTED_TYPE = Messages.getMessage("CLASS_NOT_A_SUPPORTED_TYPE");
        INVALID_OPERATION_DISPOSED_RECEIVER = Messages.getMessage("INVALID_OPERATION_DISPOSED_RECEIVER");
        INVALID_OPERATION_DISPOSED_SENDER = Messages.getMessage("INVALID_OPERATION_DISPOSED_SENDER");
        INVALID_OPERATION_DISPOSED_RULE_MANAGER = Messages.getMessage("INVALID_OPERATION_DISPOSED_RULE_MANAGER");
        MESSAGE_NOT_OF_TYPE = Messages.getMessage("MESSAGE_NOT_OF_TYPE");
        REQUEST_VALUE_NOT_VALID = Messages.getMessage("REQUEST_VALUE_NOT_VALID");
        PROCESS_SPAN_SCOPE_TYPE_ERROR = Messages.getMessage("PROCESS_SPAN_SCOPE_TYPE_ERROR");
        MESSAGE_PROCESSOR_RUN_END = Messages.getMessage("MESSAGE_PROCESSOR_RUN_END");
    }
}

