// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.time.OffsetDateTime;

/** The TopicDescriptionEntry model. */
@JacksonXmlRootElement(localName = "entry", namespace = "http://www.w3.org/2005/Atom")
@Fluent
public final class TopicDescriptionEntry {
    /*
     * Base URL for the query.
     */
    @JacksonXmlProperty(localName = "base", isAttribute = true)
    private String base;

    /*
     * The URL of the GET request
     */
    @JacksonXmlProperty(localName = "id", namespace = "http://www.w3.org/2005/Atom")
    private String id;

    /*
     * The name of the topic
     */
    @JsonProperty(value = "title")
    private Object title;

    /*
     * The timestamp for when this topic was published
     */
    @JacksonXmlProperty(localName = "published", namespace = "http://www.w3.org/2005/Atom")
    private OffsetDateTime published;

    /*
     * The timestamp for when this topic was last updated
     */
    @JacksonXmlProperty(localName = "updated", namespace = "http://www.w3.org/2005/Atom")
    private OffsetDateTime updated;

    /*
     * The author that created this resource
     */
    @JacksonXmlProperty(localName = "author", namespace = "http://www.w3.org/2005/Atom")
    private ResponseAuthor author;

    /*
     * The URL for the HTTP request
     */
    @JacksonXmlProperty(localName = "link", namespace = "http://www.w3.org/2005/Atom")
    private ResponseLink link;

    /*
     * The TopicDescription
     */
    @JacksonXmlProperty(localName = "content", namespace = "http://www.w3.org/2005/Atom")
    private TopicDescriptionEntryContent content;

    /**
     * Get the base property: Base URL for the query.
     *
     * @return the base value.
     */
    public String getBase() {
        return this.base;
    }

    /**
     * Set the base property: Base URL for the query.
     *
     * @param base the base value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setBase(String base) {
        this.base = base;
        return this;
    }

    /**
     * Get the id property: The URL of the GET request.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: The URL of the GET request.
     *
     * @param id the id value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the title property: The name of the topic.
     *
     * @return the title value.
     */
    public Object getTitle() {
        return this.title;
    }

    /**
     * Set the title property: The name of the topic.
     *
     * @param title the title value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setTitle(Object title) {
        this.title = title;
        return this;
    }

    /**
     * Get the published property: The timestamp for when this topic was published.
     *
     * @return the published value.
     */
    public OffsetDateTime getPublished() {
        return this.published;
    }

    /**
     * Set the published property: The timestamp for when this topic was published.
     *
     * @param published the published value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setPublished(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    /**
     * Get the updated property: The timestamp for when this topic was last updated.
     *
     * @return the updated value.
     */
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    /**
     * Set the updated property: The timestamp for when this topic was last updated.
     *
     * @param updated the updated value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    /**
     * Get the author property: The author that created this resource.
     *
     * @return the author value.
     */
    public ResponseAuthor getAuthor() {
        return this.author;
    }

    /**
     * Set the author property: The author that created this resource.
     *
     * @param author the author value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setAuthor(ResponseAuthor author) {
        this.author = author;
        return this;
    }

    /**
     * Get the link property: The URL for the HTTP request.
     *
     * @return the link value.
     */
    public ResponseLink getLink() {
        return this.link;
    }

    /**
     * Set the link property: The URL for the HTTP request.
     *
     * @param link the link value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setLink(ResponseLink link) {
        this.link = link;
        return this;
    }

    /**
     * Get the content property: The TopicDescription.
     *
     * @return the content value.
     */
    public TopicDescriptionEntryContent getContent() {
        return this.content;
    }

    /**
     * Set the content property: The TopicDescription.
     *
     * @param content the content value to set.
     * @return the TopicDescriptionEntry object itself.
     */
    public TopicDescriptionEntry setContent(TopicDescriptionEntryContent content) {
        this.content = content;
        return this;
    }
}
