/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionManager;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusReceiveLink;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusReceiverInstrumentation;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusClientBuilder.class, isAsync=true)
public final class ServiceBusSessionReceiverAsyncClient
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusSessionReceiverAsyncClient.class);
    private final String fullyQualifiedNamespace;
    private final String entityPath;
    private final MessagingEntityType entityType;
    private final ReceiverOptions receiverOptions;
    private final ServiceBusConnectionProcessor connectionProcessor;
    private final ServiceBusReceiverInstrumentation instrumentation;
    private final ServiceBusTracer tracer;
    private final MessageSerializer messageSerializer;
    private final Runnable onClientClose;
    private final ServiceBusSessionManager unNamedSessionManager;
    private final String identifier;

    ServiceBusSessionReceiverAsyncClient(String fullyQualifiedNamespace, String entityPath, MessagingEntityType entityType, ReceiverOptions receiverOptions, ServiceBusConnectionProcessor connectionProcessor, ServiceBusReceiverInstrumentation instrumentation, MessageSerializer messageSerializer, Runnable onClientClose, String identifier) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "'entityType' cannot be null.");
        this.receiverOptions = Objects.requireNonNull(receiverOptions, "'receiveOptions cannot be null.'");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.instrumentation = Objects.requireNonNull(instrumentation, "'instrumentation' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.unNamedSessionManager = new ServiceBusSessionManager(entityPath, entityType, connectionProcessor, messageSerializer, receiverOptions, identifier);
        this.identifier = identifier;
        this.tracer = instrumentation.getTracer();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServiceBusReceiverAsyncClient> acceptNextSession() {
        return this.tracer.traceMono("ServiceBus.acceptNextSession", this.unNamedSessionManager.getActiveLink().flatMap(receiveLink -> receiveLink.getSessionId().map(sessionId -> {
            ReceiverOptions newReceiverOptions = new ReceiverOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), (String)sessionId, null);
            ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionProcessor, this.messageSerializer, newReceiverOptions, (ServiceBusReceiveLink)receiveLink, this.identifier);
            return new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, this.instrumentation, this.messageSerializer, () -> {}, sessionSpecificManager);
        })));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServiceBusReceiverAsyncClient> acceptSession(String sessionId) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'sessionId' cannot be null"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be empty"));
        }
        ReceiverOptions newReceiverOptions = new ReceiverOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), sessionId, null);
        ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionProcessor, this.messageSerializer, newReceiverOptions, this.identifier);
        return this.tracer.traceMono("ServiceBus.acceptSession", sessionSpecificManager.getActiveLink().map(receiveLink -> new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, this.instrumentation, this.messageSerializer, () -> {}, sessionSpecificManager)));
    }

    @Override
    public void close() {
        this.unNamedSessionManager.close();
        this.onClientClose.run();
    }
}

