/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.RulesImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBody;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementError;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeed;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.QueueRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.administration.models.TopicRuntimeProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusAdministrationClientBuilder.class, isAsync=true)
public final class ServiceBusAdministrationAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusAdministrationAsyncClient.class);
    private final ServiceBusManagementClientImpl managementClient;
    private final EntitiesImpl entityClient;
    private final ServiceBusManagementSerializer serializer;
    private final RulesImpl rulesClient;

    ServiceBusAdministrationAsyncClient(ServiceBusManagementClientImpl managementClient, ServiceBusManagementSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        this.managementClient = Objects.requireNonNull(managementClient, "'managementClient' cannot be null.");
        this.entityClient = managementClient.getEntities();
        this.rulesClient = managementClient.getRules();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> createQueue(String queueName) {
        try {
            return this.createQueue(queueName, new CreateQueueOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> createQueue(String queueName, CreateQueueOptions queueOptions) {
        return this.createQueueWithResponse(queueName, queueOptions).map(response -> (QueueProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> createQueueWithResponse(String queueName, CreateQueueOptions queueOptions) {
        return FluxUtil.withContext(context -> this.createQueueWithResponse(queueName, queueOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> createRule(String topicName, String subscriptionName, String ruleName) {
        try {
            return this.createRule(topicName, subscriptionName, ruleName, new CreateRuleOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> createRule(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions) {
        return this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions).map(response -> (RuleProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions) {
        return FluxUtil.withContext(context -> this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> createSubscription(String topicName, String subscriptionName) {
        try {
            return this.createSubscription(topicName, subscriptionName, new CreateSubscriptionOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> createSubscription(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions).map(response -> (SubscriptionProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return FluxUtil.withContext(context -> this.createSubscriptionWithResponse(topicName, subscriptionName, null, subscriptionOptions, null, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> createTopic(String topicName) {
        try {
            return this.createTopic(topicName, new CreateTopicOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> createTopic(String topicName, CreateTopicOptions topicOptions) {
        return this.createTopicWithResponse(topicName, topicOptions).map(response -> (TopicProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions) {
        return FluxUtil.withContext(context -> this.createTopicWithResponse(topicName, topicOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteQueue(String queueName) {
        return this.deleteQueueWithResponse(queueName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.deleteQueueWithResponse(queueName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRule(String topicName, String subscriptionName, String ruleName) {
        return this.deleteRuleWithResponse(topicName, subscriptionName, ruleName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName) {
        return FluxUtil.withContext(context -> this.deleteRuleWithResponse(topicName, subscriptionName, ruleName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSubscription(String topicName, String subscriptionName) {
        return this.deleteSubscriptionWithResponse(topicName, subscriptionName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSubscriptionWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.deleteSubscriptionWithResponse(topicName, subscriptionName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTopic(String topicName) {
        return this.deleteTopicWithResponse(topicName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTopicWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.deleteTopicWithResponse(topicName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> getQueue(String queueName) {
        return this.getQueueWithResponse(queueName).map(response -> (QueueProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> getQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueWithResponse(queueName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getQueueExists(String queueName) {
        return this.getQueueExistsWithResponse(queueName).map(response -> (Boolean)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getQueueExistsWithResponse(String queueName) {
        return this.getEntityExistsWithResponse(this.getQueueWithResponse(queueName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueRuntimeProperties> getQueueRuntimeProperties(String queueName) {
        return this.getQueueRuntimePropertiesWithResponse(queueName).map(response -> (QueueRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueRuntimeProperties>> getQueueRuntimePropertiesWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueWithResponse(queueName, (Context)context, QueueRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NamespaceProperties> getNamespaceProperties() {
        return this.getNamespacePropertiesWithResponse().map(response -> (NamespaceProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NamespaceProperties>> getNamespacePropertiesWithResponse() {
        return FluxUtil.withContext(this::getNamespacePropertiesWithResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> getRule(String topicName, String subscriptionName, String ruleName) {
        return this.getRuleWithResponse(topicName, subscriptionName, ruleName).map(response -> (RuleProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> getRuleWithResponse(String topicName, String subscriptionName, String ruleName) {
        return FluxUtil.withContext(context -> this.getRuleWithResponse(topicName, subscriptionName, ruleName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> getSubscription(String topicName, String subscriptionName) {
        return this.getSubscriptionWithResponse(topicName, subscriptionName).map(response -> (SubscriptionProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> getSubscriptionWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.getSubscriptionWithResponse(topicName, subscriptionName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getSubscriptionExists(String topicName, String subscriptionName) {
        return this.getSubscriptionExistsWithResponse(topicName, subscriptionName).map(response -> (Boolean)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getSubscriptionExistsWithResponse(String topicName, String subscriptionName) {
        return this.getEntityExistsWithResponse(this.getSubscriptionWithResponse(topicName, subscriptionName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionRuntimeProperties> getSubscriptionRuntimeProperties(String topicName, String subscriptionName) {
        return this.getSubscriptionRuntimePropertiesWithResponse(topicName, subscriptionName).map(response -> (SubscriptionRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionRuntimeProperties>> getSubscriptionRuntimePropertiesWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.getSubscriptionWithResponse(topicName, subscriptionName, (Context)context, SubscriptionRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> getTopic(String topicName) {
        return this.getTopicWithResponse(topicName).map(response -> (TopicProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> getTopicWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.getTopicWithResponse(topicName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getTopicExists(String topicName) {
        return this.getTopicExistsWithResponse(topicName).map(response -> (Boolean)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getTopicExistsWithResponse(String topicName) {
        return this.getEntityExistsWithResponse(this.getTopicWithResponse(topicName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicRuntimeProperties> getTopicRuntimeProperties(String topicName) {
        return this.getTopicRuntimePropertiesWithResponse(topicName).map(response -> (TopicRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicRuntimeProperties>> getTopicRuntimePropertiesWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.getTopicWithResponse(topicName, (Context)context, TopicRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueProperties> listQueues() {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listQueuesFirstPage((Context)context)), token -> FluxUtil.withContext(context -> this.listQueuesNextPage((String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RuleProperties> listRules(String topicName, String subscriptionName) {
        if (topicName == null) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRulesFirstPage(topicName, subscriptionName, (Context)context)), token -> FluxUtil.withContext(context -> this.listRulesNextPage(topicName, subscriptionName, (String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SubscriptionProperties> listSubscriptions(String topicName) {
        if (topicName == null) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSubscriptionsFirstPage(topicName, (Context)context)), token -> FluxUtil.withContext(context -> this.listSubscriptionsNextPage(topicName, (String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TopicProperties> listTopics() {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listTopicsFirstPage((Context)context)), token -> FluxUtil.withContext(context -> this.listTopicsNextPage((String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> updateQueue(QueueProperties queue) {
        return this.updateQueueWithResponse(queue).map(response -> (QueueProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> updateQueueWithResponse(QueueProperties queue) {
        return FluxUtil.withContext(context -> this.updateQueueWithResponse(queue, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> updateRule(String topicName, String subscriptionName, RuleProperties rule) {
        return this.updateRuleWithResponse(topicName, subscriptionName, rule).map(response -> (RuleProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule) {
        return FluxUtil.withContext(context -> this.updateRuleWithResponse(topicName, subscriptionName, rule, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> updateSubscription(SubscriptionProperties subscription) {
        return this.updateSubscriptionWithResponse(subscription).map(response -> (SubscriptionProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> updateSubscriptionWithResponse(SubscriptionProperties subscription) {
        return FluxUtil.withContext(context -> this.updateSubscriptionWithResponse(subscription, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> updateTopic(TopicProperties topic) {
        return this.updateTopicWithResponse(topic).map(response -> (TopicProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> updateTopicWithResponse(TopicProperties topic) {
        return FluxUtil.withContext(context -> this.updateTopicWithResponse(topic, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> createSubscription(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions) {
        return this.createSubscriptionWithResponse(topicName, subscriptionName, ruleName, subscriptionOptions, ruleOptions).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> createSubscriptionWithResponse(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions) {
        return FluxUtil.withContext(context -> this.createSubscriptionWithResponse(topicName, subscriptionName, ruleName, subscriptionOptions, ruleOptions, (Context)context));
    }

    Mono<Response<QueueProperties>> createQueueWithResponse(String queueName, CreateQueueOptions createQueueOptions, Context context) {
        String forwardDlq;
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
        if (createQueueOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createQueueOptions' cannot be null."));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = EntityHelper.getTracingContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(createQueueOptions.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            createQueueOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(createQueueOptions.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            createQueueOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        CreateQueueBody createEntity = EntityHelper.getCreateQueueBody(EntityHelper.getQueueDescription(createQueueOptions));
        try {
            return this.entityClient.putWithResponseAsync(queueName, createEntity, null, contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeQueue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)ruleName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be null or empty."));
        }
        if (ruleOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'ruleOptions' cannot be null."));
        }
        CreateRuleBody createEntity = EntityHelper.getCreateRuleBody(ruleName, ruleOptions);
        try {
            return this.managementClient.getRules().putWithResponseAsync(topicName, subscriptionName, ruleName, createEntity, null, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeRule);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<SubscriptionProperties>> createSubscriptionWithResponse(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions, Context context) {
        String forwardDlq;
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
        if (subscriptionOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'subscriptionOptions' cannot be null."));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = EntityHelper.getTracingContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(subscriptionOptions.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            subscriptionOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscriptionOptions.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            subscriptionOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        if (ruleOptions != null) {
            if (ruleOptions.getFilter() == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'RuleFilter' cannot be null."));
            }
            RuleDescription rule = new RuleDescription().setAction(ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null).setFilter(EntityHelper.toImplementation(ruleOptions.getFilter())).setName(ruleName);
            subscriptionOptions.setDefaultRule(EntityHelper.toModel(rule));
        }
        CreateSubscriptionBody createEntity = EntityHelper.getCreateSubscriptionBody(EntityHelper.getSubscriptionDescription(subscriptionOptions));
        try {
            return this.managementClient.getSubscriptions().putWithResponseAsync(topicName, subscriptionName, createEntity, null, contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeSubscription(topicName, (Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<TopicProperties>> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (topicOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'topicOptions' cannot be null."));
        }
        CreateTopicBody createEntity = EntityHelper.getCreateTopicBody(EntityHelper.getTopicDescription(topicOptions));
        try {
            return this.entityClient.putWithResponseAsync(topicName, createEntity, null, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeTopic);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteQueueWithResponse(String queueName, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
        try {
            return this.entityClient.deleteWithResponseAsync(queueName, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)ruleName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be null or empty."));
        }
        try {
            return this.rulesClient.deleteWithResponseAsync(topicName, subscriptionName, ruleName, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
        try {
            return this.managementClient.getSubscriptions().deleteWithResponseAsync(topicName, subscriptionName, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteTopicWithResponse(String topicName, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        try {
            return this.entityClient.deleteWithResponseAsync(topicName, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    <T> Mono<Response<Boolean>> getEntityExistsWithResponse(Mono<Response<T>> getEntityOperation) {
        return getEntityOperation.map(response -> {
            boolean exists = response.getValue() != null;
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)exists);
        }).onErrorResume(ResourceNotFoundException.class, exception -> {
            HttpResponse response = exception.getResponse();
            SimpleResponse result = new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            return Mono.just((Object)result);
        });
    }

    <T> Mono<Response<T>> getQueueWithResponse(String queueName, Context context, Function<QueueProperties, T> mapper) {
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
        try {
            return this.entityClient.getWithResponseAsync(queueName, true, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<QueueProperties> deserialize = this.deserializeQueue((Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityHelper.EntityNotFoundHttpResponse<QueueProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<QueueProperties>(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Queue '%s' does not exist.", queueName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((QueueProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> getRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        try {
            return this.rulesClient.getWithResponseAsync(topicName, subscriptionName, ruleName, true, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeRule);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    <T> Mono<Response<T>> getSubscriptionWithResponse(String topicName, String subscriptionName, Context context, Function<SubscriptionProperties, T> mapper) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
        try {
            return this.managementClient.getSubscriptions().getWithResponseAsync(topicName, subscriptionName, true, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<SubscriptionProperties> deserialize = this.deserializeSubscription(topicName, (Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityHelper.EntityNotFoundHttpResponse<SubscriptionProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<SubscriptionProperties>(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Subscription '%s' in topic '%s' does not exist.", topicName, subscriptionName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((SubscriptionProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<NamespaceProperties>> getNamespacePropertiesWithResponse(Context context) {
        return this.managementClient.getNamespaces().getWithResponseAsync(context).handle((response, sink) -> {
            NamespacePropertiesEntry entry = (NamespacePropertiesEntry)response.getValue();
            if (entry == null || entry.getContent() == null) {
                sink.error((Throwable)new AzureException("There was no content inside namespace response. Entry: " + response));
                return;
            }
            NamespaceProperties namespaceProperties = entry.getContent().getNamespaceProperties();
            SimpleResponse result = new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)namespaceProperties);
            sink.next((Object)result);
        });
    }

    <T> Mono<Response<T>> getTopicWithResponse(String topicName, Context context, Function<TopicProperties, T> mapper) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
        try {
            return this.entityClient.getWithResponseAsync(topicName, true, EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<TopicProperties> deserialize = this.deserializeTopic((Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityHelper.EntityNotFoundHttpResponse<TopicProperties> notFoundResponse = new EntityHelper.EntityNotFoundHttpResponse<TopicProperties>(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((TopicProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<PagedResponse<QueueProperties>> listQueuesFirstPage(Context context) {
        try {
            return this.listQueues(0, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<QueueProperties>> listQueuesNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            int skip = Integer.parseInt(continuationToken);
            return this.listQueues(skip, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<RuleProperties>> listRulesFirstPage(String topicName, String subscriptionName, Context context) {
        try {
            return this.listRules(topicName, subscriptionName, 0, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<RuleProperties>> listRulesNextPage(String topicName, String subscriptionName, String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            int skip = Integer.parseInt(continuationToken);
            return this.listRules(topicName, subscriptionName, skip, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<SubscriptionProperties>> listSubscriptionsFirstPage(String topicName, Context context) {
        try {
            return this.listSubscriptions(topicName, 0, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<SubscriptionProperties>> listSubscriptionsNextPage(String topicName, String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            int skip = Integer.parseInt(continuationToken);
            return this.listSubscriptions(topicName, skip, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<TopicProperties>> listTopicsFirstPage(Context context) {
        try {
            return this.listTopics(0, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<TopicProperties>> listTopicsNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            int skip = Integer.parseInt(continuationToken);
            return this.listTopics(skip, EntityHelper.getTracingContext(context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<Response<QueueProperties>> updateQueueWithResponse(QueueProperties queue, Context context) {
        String forwardDlq;
        if (queue == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = EntityHelper.getTracingContext(context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders()));
        String forwardTo = this.getForwardToEntity(queue.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            queue.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(queue.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            queue.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        CreateQueueBody createEntity = EntityHelper.getCreateQueueBody(EntityHelper.toImplementation(queue));
        try {
            return this.entityClient.putWithResponseAsync(queue.getName(), createEntity, "*", contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeQueue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule, Context context) {
        if (rule == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'rule' cannot be null"));
        }
        CreateRuleBody ruleBody = EntityHelper.getUpdateRuleBody(rule);
        try {
            return this.managementClient.getRules().putWithResponseAsync(topicName, subscriptionName, rule.getName(), ruleBody, "*", EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeRule);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<SubscriptionProperties>> updateSubscriptionWithResponse(SubscriptionProperties subscription, Context context) {
        String forwardDlq;
        if (subscription == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'subscription' cannot be null"));
        }
        context = context == null ? Context.NONE : context;
        Context contextWithHeaders = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
        String forwardTo = this.getForwardToEntity(subscription.getForwardTo(), contextWithHeaders);
        if (forwardTo != null) {
            subscription.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscription.getForwardDeadLetteredMessagesTo(), contextWithHeaders)) != null) {
            subscription.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        String topicName = subscription.getTopicName();
        String subscriptionName = subscription.getSubscriptionName();
        CreateSubscriptionBody createEntity = EntityHelper.getCreateSubscriptionBody(EntityHelper.toImplementation(subscription));
        try {
            return this.managementClient.getSubscriptions().putWithResponseAsync(topicName, subscriptionName, createEntity, "*", contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeSubscription(topicName, (Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<TopicProperties>> updateTopicWithResponse(TopicProperties topic, Context context) {
        if (topic == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'topic' cannot be null"));
        }
        CreateTopicBody createEntity = EntityHelper.getUpdateTopicBody(topic);
        try {
            return this.entityClient.putWithResponseAsync(topic.getName(), createEntity, "*", EntityHelper.getTracingContext(context)).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeTopic);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private <T> T deserialize(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String contents = String.valueOf(object);
        if (contents.isEmpty()) {
            return null;
        }
        try {
            return this.serializer.deserialize(contents, clazz);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("Exception while deserializing. Body: [%s]. Class: %s", contents, clazz), e));
        }
    }

    private <T> Response<T> deserialize(Response<Object> response, Class<T> clazz) {
        T deserialize = this.deserialize(response.getValue(), clazz);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), deserialize);
    }

    private Response<QueueProperties> deserializeQueue(Response<Object> response) {
        TopicDescriptionEntry entryTopic;
        QueueDescriptionEntry entry = this.deserialize(response.getValue(), QueueDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getQueueDescription() == null && (entryTopic = this.deserialize(response.getValue(), TopicDescriptionEntry.class)) != null && entryTopic.getContent() != null && entryTopic.getContent().getTopicDescription() != null) {
            LOGGER.warning("'{}' is not a queue, it is a topic.", new Object[]{entryTopic.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        QueueProperties result = EntityHelper.toModel(entry.getContent().getQueueDescription());
        String queueName = EntityHelper.getTitleValue(entry.getTitle());
        EntityHelper.setQueueName(result, queueName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private Response<RuleProperties> deserializeRule(Response<Object> response) {
        RuleDescriptionEntry entry = this.deserialize(response.getValue(), RuleDescriptionEntry.class);
        return EntityHelper.getRulePropertiesSimpleResponse(response, entry);
    }

    private Response<SubscriptionProperties> deserializeSubscription(String topicName, Response<Object> response) {
        SubscriptionDescriptionEntry entry = this.deserialize(response.getValue(), SubscriptionDescriptionEntry.class);
        return EntityHelper.getSubscriptionPropertiesSimpleResponse(topicName, response, entry);
    }

    private Response<TopicProperties> deserializeTopic(Response<Object> response) {
        QueueDescriptionEntry entryQueue;
        TopicDescriptionEntry entry = this.deserialize(response.getValue(), TopicDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            LOGGER.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getTopicDescription() == null && (entryQueue = this.deserialize(response.getValue(), QueueDescriptionEntry.class)) != null && entryQueue.getContent() != null && entryQueue.getContent().getQueueDescription() != null) {
            LOGGER.warning("'{}' is not a topic, it is a queue.", new Object[]{entryQueue.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
        String topicName = EntityHelper.getTitleValue(entry.getTitle());
        EntityHelper.setTopicName(result, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private Mono<PagedResponse<QueueProperties>> listQueues(int skip, Context context) {
        return this.managementClient.listEntitiesWithResponseAsync("queues", skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<QueueDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, QueueDescriptionFeed.class);
            QueueDescriptionFeed feed = (QueueDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                LOGGER.warning("Could not deserialize QueueDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List<QueueProperties> entities = EntityHelper.getQueues(feed);
            try {
                return Mono.just(EntityHelper.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<QueueDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<RuleProperties>> listRules(String topicName, String subscriptionName, int skip, Context context) {
        return this.managementClient.listRulesWithResponseAsync(topicName, subscriptionName, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<RuleDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, RuleDescriptionFeed.class);
            RuleDescriptionFeed feed = (RuleDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                LOGGER.warning("Could not deserialize RuleDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List<RuleProperties> entities = EntityHelper.getRules(feed);
            try {
                return Mono.just(EntityHelper.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<SubscriptionProperties>> listSubscriptions(String topicName, int skip, Context context) {
        return this.managementClient.listSubscriptionsWithResponseAsync(topicName, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<SubscriptionDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, SubscriptionDescriptionFeed.class);
            SubscriptionDescriptionFeed feed = (SubscriptionDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                LOGGER.warning("Could not deserialize SubscriptionDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List<SubscriptionProperties> entities = EntityHelper.getSubscriptions(topicName, feed);
            try {
                return Mono.just(EntityHelper.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<SubscriptionDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<TopicProperties>> listTopics(int skip, Context context) {
        return this.managementClient.listEntitiesWithResponseAsync("topics", skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<TopicDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, TopicDescriptionFeed.class);
            TopicDescriptionFeed feed = (TopicDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                LOGGER.warning("Could not deserialize TopicDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List<TopicProperties> entities = EntityHelper.getTopics(feed);
            try {
                return Mono.just(EntityHelper.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<TopicDescription>", error));
            }
        });
    }

    private String getAbsoluteUrlFromEntity(String entity) {
        try {
            URL url = new URL(entity);
            return url.toString();
        }
        catch (MalformedURLException url) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setHost(this.managementClient.getEndpoint());
            urlBuilder.setPath(entity);
            try {
                URL url2 = urlBuilder.toUrl();
                return url2.toString();
            }
            catch (MalformedURLException ex) {
                LOGGER.error("Failed to construct URL using the endpoint:'{}' and entity:'{}'", new Object[]{this.managementClient.getEndpoint(), entity});
                LOGGER.logThrowableAsError((Throwable)ex);
                return null;
            }
        }
    }

    private static Throwable mapException(Throwable exception) {
        if (!(exception instanceof ServiceBusManagementErrorException)) {
            return exception;
        }
        ServiceBusManagementErrorException managementError = (ServiceBusManagementErrorException)((Object)exception);
        ServiceBusManagementError error = managementError.getValue();
        HttpResponse errorHttpResponse = managementError.getResponse();
        int statusCode = error != null && error.getCode() != null ? error.getCode().intValue() : errorHttpResponse.getStatusCode();
        String errorDetail = error != null && error.getDetail() != null ? error.getDetail() : managementError.getMessage();
        switch (statusCode) {
            case 401: {
                return new ClientAuthenticationException(errorDetail, managementError.getResponse(), exception);
            }
            case 404: {
                return new ResourceNotFoundException(errorDetail, managementError.getResponse(), exception);
            }
            case 409: {
                return new ResourceExistsException(errorDetail, managementError.getResponse(), exception);
            }
            case 412: {
                return new ResourceModifiedException(errorDetail, managementError.getResponse(), exception);
            }
        }
        return new HttpResponseException(errorDetail, managementError.getResponse(), exception);
    }

    private String getForwardDlqEntity(String forwardDlqToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardDlqToEntity)) {
            EntityHelper.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardDlqToEntity);
        }
        return null;
    }

    private String getForwardToEntity(String forwardToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            EntityHelper.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardToEntity);
        }
        return null;
    }
}

