/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.CorrelationFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.EmptyRuleActionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.FalseFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.KeyValueImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleActionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SqlFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SqlRuleActionImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TrueFilterImpl;
import com.azure.messaging.servicebus.administration.models.CorrelationRuleFilter;
import com.azure.messaging.servicebus.administration.models.EmptyRuleAction;
import com.azure.messaging.servicebus.administration.models.FalseRuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.SqlRuleAction;
import com.azure.messaging.servicebus.administration.models.SqlRuleFilter;
import com.azure.messaging.servicebus.administration.models.TrueRuleFilter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RuleProperties {
    private final String name;
    private RuleFilter filter;
    private RuleAction action;

    RuleProperties(String name, RuleFilter filter, RuleAction action) {
        this.name = name;
        this.filter = filter;
        this.action = action;
    }

    public RuleFilter getFilter() {
        return this.filter;
    }

    public RuleProperties setFilter(RuleFilter filter) {
        this.filter = Objects.requireNonNull(filter, "'filter' cannot be null.");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RuleAction getAction() {
        return this.action;
    }

    public RuleProperties setAction(RuleAction action) {
        this.action = action;
        return this;
    }

    static {
        EntityHelper.setRuleAccessor(new EntityHelper.RuleAccessor(){
            private final EmptyRuleActionImpl emptyRuleAction = new EmptyRuleActionImpl();
            private final SqlFilterImpl trueFilter = new TrueFilterImpl().setSqlExpression("1=1");
            private final SqlFilterImpl falseFilter = new FalseFilterImpl().setSqlExpression("1=0");

            @Override
            public RuleProperties toModel(RuleDescription description) {
                RuleFilter filter = description.getFilter() != null ? this.toModel(description.getFilter()) : null;
                RuleAction action = description.getAction() != null ? this.toModel(description.getAction()) : null;
                return new RuleProperties(description.getName(), filter, action);
            }

            @Override
            public RuleAction toModel(RuleActionImpl implementation) {
                if (implementation instanceof EmptyRuleActionImpl) {
                    return EmptyRuleAction.getInstance();
                }
                if (implementation instanceof SqlRuleActionImpl) {
                    SqlRuleActionImpl action = (SqlRuleActionImpl)implementation;
                    SqlRuleAction returned = new SqlRuleAction(action.getSqlExpression(), action.getCompatibilityLevel(), action.isRequiresPreprocessing());
                    if (action.getParameters() != null) {
                        for (KeyValueImpl parameter : action.getParameters()) {
                            returned.getParameters().put(parameter.getKey(), parameter.getValue());
                        }
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public RuleFilter toModel(RuleFilterImpl implementation) {
                if (implementation instanceof TrueFilterImpl) {
                    return TrueRuleFilter.getInstance();
                }
                if (implementation instanceof FalseFilterImpl) {
                    return FalseRuleFilter.getInstance();
                }
                if (implementation instanceof CorrelationFilterImpl) {
                    CorrelationFilterImpl filter = (CorrelationFilterImpl)implementation;
                    CorrelationRuleFilter returned = new CorrelationRuleFilter().setContentType(filter.getContentType()).setCorrelationId(filter.getCorrelationId()).setLabel(filter.getLabel()).setMessageId(filter.getMessageId()).setTo(filter.getTo()).setSessionId(filter.getSessionId()).setReplyTo(filter.getReplyTo()).setReplyToSessionId(filter.getReplyToSessionId());
                    if (filter.getProperties() != null) {
                        filter.getProperties().forEach(keyValue -> returned.getProperties().put(keyValue.getKey(), keyValue.getValue()));
                    }
                    return returned;
                }
                if (implementation instanceof SqlFilterImpl) {
                    SqlFilterImpl filter = (SqlFilterImpl)implementation;
                    SqlRuleFilter returned = new SqlRuleFilter(filter.getSqlExpression(), filter.getCompatibilityLevel(), filter.isRequiresPreprocessing());
                    if (filter.getParameters() != null) {
                        filter.getParameters().forEach(keyValue -> returned.getParameters().put(keyValue.getKey(), keyValue.getValue()));
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public RuleDescription toImplementation(RuleProperties ruleProperties) {
                RuleFilterImpl filter = ruleProperties.getFilter() != null ? this.toImplementation(ruleProperties.getFilter()) : null;
                RuleActionImpl action = ruleProperties.getAction() != null ? this.toImplementation(ruleProperties.getAction()) : null;
                return new RuleDescription().setName(ruleProperties.getName()).setAction(action).setFilter(filter);
            }

            @Override
            public RuleActionImpl toImplementation(RuleAction model) {
                if (model instanceof EmptyRuleAction) {
                    return this.emptyRuleAction;
                }
                if (model instanceof SqlRuleAction) {
                    SqlRuleAction action = (SqlRuleAction)model;
                    SqlRuleActionImpl returned = new SqlRuleActionImpl().setSqlExpression(action.getSqlExpression()).setCompatibilityLevel(action.getCompatibilityLevel()).setRequiresPreprocessing(action.isPreprocessingRequired());
                    if (!action.getParameters().isEmpty()) {
                        List<KeyValueImpl> parameters = action.getParameters().entrySet().stream().map(entry -> new KeyValueImpl().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setParameters(parameters);
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public RuleFilterImpl toImplementation(RuleFilter model) {
                if (model instanceof TrueRuleFilter) {
                    return this.trueFilter;
                }
                if (model instanceof FalseRuleFilter) {
                    return this.falseFilter;
                }
                if (model instanceof CorrelationRuleFilter) {
                    CorrelationRuleFilter filter = (CorrelationRuleFilter)model;
                    CorrelationFilterImpl returned = new CorrelationFilterImpl().setContentType(filter.getContentType()).setCorrelationId(filter.getCorrelationId()).setLabel(filter.getLabel()).setMessageId(filter.getMessageId()).setTo(filter.getTo()).setSessionId(filter.getSessionId()).setReplyTo(filter.getReplyTo()).setReplyToSessionId(filter.getReplyToSessionId());
                    if (!filter.getProperties().isEmpty()) {
                        List<KeyValueImpl> parameters = filter.getProperties().entrySet().stream().map(entry -> new KeyValueImpl().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setProperties(parameters);
                    }
                    return returned;
                }
                if (model instanceof SqlRuleFilter) {
                    SqlRuleFilter filter = (SqlRuleFilter)model;
                    SqlFilterImpl returned = new SqlFilterImpl().setSqlExpression(filter.getSqlExpression()).setCompatibilityLevel(filter.getCompatibilityLevel()).setRequiresPreprocessing(filter.isPreprocessingRequired());
                    if (!filter.getParameters().isEmpty()) {
                        List<KeyValueImpl> parameters = filter.getParameters().entrySet().stream().map(entry -> new KeyValueImpl().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setParameters(parameters);
                    }
                    return returned;
                }
                return null;
            }
        });
    }
}

