// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** The QueueDescriptionResponse model. */
@JacksonXmlRootElement(localName = "entry", namespace = "http://www.w3.org/2005/Atom")
@Fluent
public final class QueueDescriptionResponse {
    /*
     * The URL of the GET request
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The name of the queue
     */
    @JsonProperty(value = "title")
    private String title;

    /*
     * The timestamp for when this queue was published
     */
    @JsonProperty(value = "published")
    private String published;

    /*
     * The timestamp for when this queue was last updated
     */
    @JsonProperty(value = "updated")
    private String updated;

    /*
     * The author that created this resource
     */
    @JsonProperty(value = "author")
    private ResponseAuthor author;

    /*
     * The URL for the HTTP request
     */
    @JacksonXmlProperty(localName = "link", namespace = "http://www.w3.org/2005/Atom")
    private ResponseLink link;

    /*
     * Contents of a Queue_Get response
     */
    @JsonProperty(value = "content")
    private QueueDescriptionResponseContent content;

    /**
     * Get the id property: The URL of the GET request.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: The URL of the GET request.
     *
     * @param id the id value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the title property: The name of the queue.
     *
     * @return the title value.
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * Set the title property: The name of the queue.
     *
     * @param title the title value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the published property: The timestamp for when this queue was published.
     *
     * @return the published value.
     */
    public String getPublished() {
        return this.published;
    }

    /**
     * Set the published property: The timestamp for when this queue was published.
     *
     * @param published the published value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setPublished(String published) {
        this.published = published;
        return this;
    }

    /**
     * Get the updated property: The timestamp for when this queue was last updated.
     *
     * @return the updated value.
     */
    public String getUpdated() {
        return this.updated;
    }

    /**
     * Set the updated property: The timestamp for when this queue was last updated.
     *
     * @param updated the updated value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setUpdated(String updated) {
        this.updated = updated;
        return this;
    }

    /**
     * Get the author property: The author that created this resource.
     *
     * @return the author value.
     */
    public ResponseAuthor getAuthor() {
        return this.author;
    }

    /**
     * Set the author property: The author that created this resource.
     *
     * @param author the author value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setAuthor(ResponseAuthor author) {
        this.author = author;
        return this;
    }

    /**
     * Get the link property: The URL for the HTTP request.
     *
     * @return the link value.
     */
    public ResponseLink getLink() {
        return this.link;
    }

    /**
     * Set the link property: The URL for the HTTP request.
     *
     * @param link the link value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setLink(ResponseLink link) {
        this.link = link;
        return this;
    }

    /**
     * Get the content property: Contents of a Queue_Get response.
     *
     * @return the content value.
     */
    public QueueDescriptionResponseContent getContent() {
        return this.content;
    }

    /**
     * Set the content property: Contents of a Queue_Get response.
     *
     * @param content the content value to set.
     * @return the QueueDescriptionResponse object itself.
     */
    public QueueDescriptionResponse setContent(QueueDescriptionResponseContent content) {
        this.content = content;
        return this;
    }
}
