/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import java.time.Duration;

class ReceiverOptions {
    private final ServiceBusReceiveMode receiveMode;
    private final int prefetchCount;
    private final boolean enableAutoComplete;
    private final String sessionId;
    private final Integer maxConcurrentSessions;
    private final Duration maxLockRenewDuration;

    ReceiverOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete) {
        this(receiveMode, prefetchCount, maxLockRenewDuration, enableAutoComplete, null, null);
    }

    ReceiverOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete, String sessionId, Integer maxConcurrentSessions) {
        this.receiveMode = receiveMode;
        this.prefetchCount = prefetchCount;
        this.enableAutoComplete = enableAutoComplete;
        this.sessionId = sessionId;
        this.maxConcurrentSessions = maxConcurrentSessions;
        this.maxLockRenewDuration = maxLockRenewDuration;
    }

    Duration getMaxLockRenewDuration() {
        return this.maxLockRenewDuration;
    }

    ServiceBusReceiveMode getReceiveMode() {
        return this.receiveMode;
    }

    String getSessionId() {
        return this.sessionId;
    }

    int getPrefetchCount() {
        return this.prefetchCount;
    }

    boolean isAutoLockRenewEnabled() {
        return this.maxLockRenewDuration != null && !this.maxLockRenewDuration.isZero() && !this.maxLockRenewDuration.isNegative();
    }

    public boolean isRollingSessionReceiver() {
        return this.maxConcurrentSessions != null && this.maxConcurrentSessions > 0 && this.sessionId == null;
    }

    public Integer getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public boolean isEnableAutoComplete() {
        return this.enableAutoComplete;
    }
}

