/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpClientOptions;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.client.traits.AmqpTrait;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.models.CbsAuthorizationType;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.annotation.ServiceClientProtocol;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusMessageSerializer;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusRuleManagerAsyncClient;
import com.azure.messaging.servicebus.ServiceBusRuleManagerClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.ServiceBusSenderInstrumentation;
import com.azure.messaging.servicebus.ServiceBusSessionManager;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusProcessorClientOptions;
import com.azure.messaging.servicebus.implementation.ServiceBusReactorAmqpConnection;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusReceiverInstrumentation;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.qpid.proton.engine.SslDomain;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@ServiceClientBuilder(serviceClients={ServiceBusReceiverAsyncClient.class, ServiceBusSenderAsyncClient.class, ServiceBusSenderClient.class, ServiceBusReceiverClient.class, ServiceBusProcessorClient.class}, protocol=ServiceClientProtocol.AMQP)
public final class ServiceBusClientBuilder
implements TokenCredentialTrait<ServiceBusClientBuilder>,
AzureNamedKeyCredentialTrait<ServiceBusClientBuilder>,
ConnectionStringTrait<ServiceBusClientBuilder>,
AzureSasCredentialTrait<ServiceBusClientBuilder>,
AmqpTrait<ServiceBusClientBuilder>,
ConfigurationTrait<ServiceBusClientBuilder> {
    private static final AmqpRetryOptions DEFAULT_RETRY = new AmqpRetryOptions().setTryTimeout(ServiceBusConstants.OPERATION_TIMEOUT);
    private static final String SERVICE_BUS_PROPERTIES_FILE = "azure-messaging-servicebus.properties";
    private static final String SUBSCRIPTION_ENTITY_PATH_FORMAT = "%s/subscriptions/%s";
    private static final String DEAD_LETTER_QUEUE_NAME_SUFFIX = "/$deadletterqueue";
    private static final String TRANSFER_DEAD_LETTER_QUEUE_NAME_SUFFIX = "/$Transfer/$deadletterqueue";
    private static final int DEFAULT_PREFETCH_COUNT = 0;
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String LIBRARY_NAME;
    private static final String LIBRARY_VERSION;
    private static final Pattern HOST_PORT_PATTERN;
    private static final Duration MAX_LOCK_RENEW_DEFAULT_DURATION;
    private static final ClientLogger LOGGER;
    private final Object connectionLock = new Object();
    private final MessageSerializer messageSerializer = new ServiceBusMessageSerializer();
    private ClientOptions clientOptions;
    private Configuration configuration;
    private ServiceBusConnectionProcessor sharedConnection;
    private String connectionStringEntityName;
    private TokenCredential credentials;
    private String fullyQualifiedNamespace;
    private ProxyOptions proxyOptions;
    private AmqpRetryOptions retryOptions;
    private Scheduler scheduler;
    private AmqpTransportType transport = AmqpTransportType.AMQP;
    private SslDomain.VerifyMode verifyMode;
    private boolean crossEntityTransactions;
    private URL customEndpointAddress;
    private final AtomicInteger openClients = new AtomicInteger();

    public ServiceBusClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ServiceBusClientBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    private String getAndValidateFullyQualifiedNamespace() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this.fullyQualifiedNamespace;
    }

    public ServiceBusClientBuilder customEndpointAddress(String customEndpointAddress) {
        if (customEndpointAddress == null) {
            this.customEndpointAddress = null;
            return this;
        }
        try {
            this.customEndpointAddress = new URL(customEndpointAddress);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("(%s) : is not a valid URL,", customEndpointAddress), e));
        }
        return this;
    }

    public ServiceBusClientBuilder connectionString(String connectionString) {
        TokenCredential tokenCredential;
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        try {
            tokenCredential = this.getTokenCredential(properties);
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Could not create the ServiceBusSharedKeyCredential.", (Throwable)e));
        }
        this.fullyQualifiedNamespace = properties.getEndpoint().getHost();
        String entityPath = properties.getEntityPath();
        if (!CoreUtils.isNullOrEmpty((CharSequence)entityPath)) {
            LOGGER.atInfo().addKeyValue("entityPath", entityPath).log("Setting entity from connection string.");
            this.connectionStringEntityName = entityPath;
        }
        return this.credential(properties.getEndpoint().getHost(), tokenCredential);
    }

    public ServiceBusClientBuilder enableCrossEntityTransactions() {
        this.crossEntityTransactions = true;
        return this;
    }

    private TokenCredential getTokenCredential(ConnectionStringProperties properties) {
        ServiceBusSharedKeyCredential tokenCredential = properties.getSharedAccessSignature() == null ? new ServiceBusSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ServiceBusConstants.TOKEN_VALIDITY) : new ServiceBusSharedKeyCredential(properties.getSharedAccessSignature());
        return tokenCredential;
    }

    public ServiceBusClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, TokenCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    public ServiceBusClientBuilder credential(TokenCredential credential) {
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, AzureNamedKeyCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        this.credentials = new ServiceBusSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ServiceBusConstants.TOKEN_VALIDITY);
        return this;
    }

    public ServiceBusClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new ServiceBusSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ServiceBusConstants.TOKEN_VALIDITY);
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, AzureSasCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        this.credentials = new ServiceBusSharedKeyCredential(credential.getSignature());
        return this;
    }

    public ServiceBusClientBuilder credential(AzureSasCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new ServiceBusSharedKeyCredential(credential.getSignature());
        return this;
    }

    public ServiceBusClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    ServiceBusClientBuilder verifyMode(SslDomain.VerifyMode verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public ServiceBusClientBuilder retryOptions(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    ServiceBusClientBuilder scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ServiceBusClientBuilder transportType(AmqpTransportType transportType) {
        this.transport = transportType;
        return this;
    }

    public ServiceBusSenderClientBuilder sender() {
        return new ServiceBusSenderClientBuilder();
    }

    public ServiceBusReceiverClientBuilder receiver() {
        return new ServiceBusReceiverClientBuilder();
    }

    public ServiceBusSessionReceiverClientBuilder sessionReceiver() {
        return new ServiceBusSessionReceiverClientBuilder();
    }

    public ServiceBusProcessorClientBuilder processor() {
        return new ServiceBusProcessorClientBuilder();
    }

    public ServiceBusSessionProcessorClientBuilder sessionProcessor() {
        return new ServiceBusSessionProcessorClientBuilder();
    }

    public ServiceBusRuleManagerBuilder ruleManager() {
        return new ServiceBusRuleManagerBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientClose() {
        Object object = this.connectionLock;
        synchronized (object) {
            int numberOfOpenClients = this.openClients.decrementAndGet();
            LOGGER.atInfo().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("Closing a dependent client.");
            if (numberOfOpenClients > 0) {
                return;
            }
            if (numberOfOpenClients < 0) {
                LOGGER.atWarning().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("There should not be less than 0 clients.");
            }
            LOGGER.info("No more open clients, closing shared connection.");
            if (this.sharedConnection != null) {
                this.sharedConnection.dispose();
                this.sharedConnection = null;
            } else {
                LOGGER.warning("Shared ServiceBusConnectionProcessor was already disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBusConnectionProcessor getOrCreateConnectionProcessor(MessageSerializer serializer) {
        if (this.retryOptions == null) {
            this.retryOptions = DEFAULT_RETRY;
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.boundedElastic();
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.sharedConnection == null) {
                ConnectionOptions connectionOptions = this.getConnectionOptions();
                Flux connectionFlux = Mono.fromCallable(() -> {
                    String connectionId = StringUtil.getRandomString((String)"MF");
                    ReactorProvider provider = new ReactorProvider();
                    ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider);
                    AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getAuthorizationScope());
                    return new ServiceBusReactorAmqpConnection(connectionId, connectionOptions, provider, handlerProvider, (TokenManagerProvider)tokenManagerProvider, serializer, this.crossEntityTransactions);
                }).repeat();
                this.sharedConnection = (ServiceBusConnectionProcessor)connectionFlux.subscribeWith((Subscriber)new ServiceBusConnectionProcessor(connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getRetry()));
            }
        }
        int numberOfOpenClients = this.openClients.incrementAndGet();
        LOGGER.info("# of open clients with shared connection: {}", new Object[]{numberOfOpenClients});
        return this.sharedConnection;
    }

    private ConnectionOptions getConnectionOptions() {
        ClientOptions options;
        Configuration configuration = this.configuration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        if (this.credentials == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials have not been set. They can be set using: connectionString(String), connectionString(String, String), or credentials(String, String, TokenCredential)"));
        }
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured() && this.transport != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot use a proxy when TransportType is not AMQP Web Sockets. Use the setter 'transportType(AmqpTransportType.AMQP_WEB_SOCKETS)' to enable Web Sockets mode."));
        }
        if (this.proxyOptions == null) {
            this.proxyOptions = ProxyOptions.fromConfiguration((Configuration)this.configuration);
        }
        CbsAuthorizationType authorizationType = this.credentials instanceof ServiceBusSharedKeyCredential ? CbsAuthorizationType.SHARED_ACCESS_SIGNATURE : CbsAuthorizationType.JSON_WEB_TOKEN;
        SslDomain.VerifyMode verificationMode = this.verifyMode != null ? this.verifyMode : SslDomain.VerifyMode.VERIFY_PEER_NAME;
        ClientOptions clientOptions = options = this.clientOptions != null ? this.clientOptions : new ClientOptions();
        if (this.customEndpointAddress == null) {
            return new ConnectionOptions(this.getAndValidateFullyQualifiedNamespace(), this.credentials, authorizationType, "https://servicebus.azure.net/.default", this.transport, this.retryOptions, this.proxyOptions, this.scheduler, options, verificationMode, LIBRARY_NAME, LIBRARY_VERSION);
        }
        return new ConnectionOptions(this.getAndValidateFullyQualifiedNamespace(), this.credentials, authorizationType, "https://servicebus.azure.net/.default", this.transport, this.retryOptions, this.proxyOptions, this.scheduler, options, verificationMode, LIBRARY_NAME, LIBRARY_VERSION, this.customEndpointAddress.getHost(), this.customEndpointAddress.getPort());
    }

    private static boolean isNullOrEmpty(String item) {
        return item == null || item.isEmpty();
    }

    private static MessagingEntityType validateEntityPaths(String connectionStringEntityName, String topicName, String queueName) {
        MessagingEntityType entityType;
        boolean hasConnectionStringEntity;
        boolean hasTopicName = !ServiceBusClientBuilder.isNullOrEmpty(topicName);
        boolean hasQueueName = !ServiceBusClientBuilder.isNullOrEmpty(queueName);
        boolean bl = hasConnectionStringEntity = !ServiceBusClientBuilder.isNullOrEmpty(connectionStringEntityName);
        if (!(hasConnectionStringEntity || hasQueueName || hasTopicName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot build client without setting either a queueName or topicName."));
        }
        if (hasQueueName && hasTopicName) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Cannot build client with both queueName (%s) and topicName (%s) set.", queueName, topicName)));
        }
        if (hasQueueName) {
            if (hasConnectionStringEntity && !queueName.equals(connectionStringEntityName)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("queueName (%s) is different than the connectionString's EntityPath (%s).", queueName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.QUEUE;
        } else if (hasTopicName) {
            if (hasConnectionStringEntity && !topicName.equals(connectionStringEntityName)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) is different than the connectionString's EntityPath (%s).", topicName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.SUBSCRIPTION;
        } else {
            entityType = MessagingEntityType.UNKNOWN;
        }
        return entityType;
    }

    private static String getEntityPath(MessagingEntityType entityType, String queueName, String topicName, String subscriptionName, SubQueue subQueue) {
        String entityPath;
        switch (entityType) {
            case QUEUE: {
                entityPath = queueName;
                break;
            }
            case SUBSCRIPTION: {
                if (ServiceBusClientBuilder.isNullOrEmpty(subscriptionName)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) must have a subscriptionName associated with it.", topicName)));
                }
                entityPath = String.format(Locale.ROOT, SUBSCRIPTION_ENTITY_PATH_FORMAT, topicName, subscriptionName);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
            }
        }
        if (subQueue == null) {
            return entityPath;
        }
        switch (subQueue) {
            case NONE: {
                break;
            }
            case TRANSFER_DEAD_LETTER_QUEUE: {
                entityPath = entityPath + TRANSFER_DEAD_LETTER_QUEUE_NAME_SUFFIX;
                break;
            }
            case DEAD_LETTER_QUEUE: {
                entityPath = entityPath + DEAD_LETTER_QUEUE_NAME_SUFFIX;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unsupported value of subqueue type: " + (Object)((Object)subQueue)));
            }
        }
        return entityPath;
    }

    private void validateAndThrow(int prefetchCount) {
        if (prefetchCount < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("prefetchCount (%s) cannot be less than 0.", prefetchCount)));
        }
    }

    private void validateAndThrow(Duration maxLockRenewalDuration) {
        if (maxLockRenewalDuration != null && maxLockRenewalDuration.isNegative()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxLockRenewalDuration' cannot be negative."));
        }
    }

    private Meter createMeter() {
        return MeterProvider.getDefaultProvider().createMeter(LIBRARY_NAME, LIBRARY_VERSION, this.clientOptions == null ? null : this.clientOptions.getMetricsOptions());
    }

    private Tracer createTracer() {
        return TracerProvider.getDefaultProvider().createTracer(LIBRARY_NAME, LIBRARY_VERSION, "Microsoft.ServiceBus", this.clientOptions == null ? null : this.clientOptions.getTracingOptions());
    }

    static /* synthetic */ Duration access$1900() {
        return MAX_LOCK_RENEW_DEFAULT_DURATION;
    }

    static {
        HOST_PORT_PATTERN = Pattern.compile("^[^:]+:\\d+");
        MAX_LOCK_RENEW_DEFAULT_DURATION = Duration.ofMinutes(5L);
        LOGGER = new ClientLogger(ServiceBusClientBuilder.class);
        Map properties = CoreUtils.getProperties((String)SERVICE_BUS_PROPERTIES_FILE);
        LIBRARY_NAME = properties.getOrDefault(NAME_KEY, UNKNOWN);
        LIBRARY_VERSION = properties.getOrDefault(VERSION_KEY, UNKNOWN);
    }

    @ServiceClientBuilder(serviceClients={ServiceBusSenderClient.class, ServiceBusSenderAsyncClient.class})
    public final class ServiceBusSenderClientBuilder {
        private String queueName;
        private String topicName;

        private ServiceBusSenderClientBuilder() {
        }

        public ServiceBusSenderClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSenderClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusSenderAsyncClient buildAsyncClient() {
            String clientOptionIdentifier;
            String entityName;
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            switch (entityType) {
                case QUEUE: {
                    entityName = this.queueName;
                    break;
                }
                case SUBSCRIPTION: {
                    entityName = this.topicName;
                    break;
                }
                case UNKNOWN: {
                    entityName = ServiceBusClientBuilder.this.connectionStringEntityName;
                    break;
                }
                default: {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
                }
            }
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusSenderInstrumentation instrumentation = new ServiceBusSenderInstrumentation(ServiceBusClientBuilder.this.createTracer(), ServiceBusClientBuilder.this.createMeter(), connectionProcessor.getFullyQualifiedNamespace(), entityName);
            return new ServiceBusSenderAsyncClient(entityName, entityType, connectionProcessor, ServiceBusClientBuilder.this.retryOptions, instrumentation, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, null, clientIdentifier);
        }

        public ServiceBusSenderClient buildClient() {
            return new ServiceBusSenderClient(this.buildAsyncClient(), MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusReceiverClientBuilder {
        private boolean enableAutoComplete = true;
        private int prefetchCount = 0;
        private String queueName;
        private SubQueue subQueue;
        private ServiceBusReceiveMode receiveMode = ServiceBusReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewDuration = ServiceBusClientBuilder.access$1900();

        private ServiceBusReceiverClientBuilder() {
        }

        public ServiceBusReceiverClientBuilder disableAutoComplete() {
            this.enableAutoComplete = false;
            return this;
        }

        public ServiceBusReceiverClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration);
            this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
            return this;
        }

        public ServiceBusReceiverClientBuilder prefetchCount(int prefetchCount) {
            ServiceBusClientBuilder.this.validateAndThrow(prefetchCount);
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusReceiverClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusReceiverClientBuilder subQueue(SubQueue subQueue) {
            this.subQueue = subQueue;
            return this;
        }

        public ServiceBusReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusReceiverAsyncClient buildAsyncClient() {
            return this.buildAsyncClient(true, false);
        }

        public ServiceBusReceiverClient buildClient() {
            boolean isPrefetchDisabled = this.prefetchCount == 0;
            return new ServiceBusReceiverClient(this.buildAsyncClient(false, true), isPrefetchDisabled, MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }

        ServiceBusReceiverAsyncClient buildAsyncClient(boolean isAutoCompleteAllowed, boolean syncConsumer) {
            String clientOptionIdentifier;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, this.subQueue);
            if (!isAutoCompleteAllowed && this.enableAutoComplete) {
                LOGGER.warning("'enableAutoComplete' is not supported in synchronous client except through callback receive.");
                this.enableAutoComplete = false;
            } else if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            ReceiverOptions receiverOptions = new ReceiverOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.this.createTracer(), ServiceBusClientBuilder.this.createMeter(), connectionProcessor.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, syncConsumer);
            return new ServiceBusReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, instrumentation, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, clientIdentifier);
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusSessionReceiverClientBuilder {
        private boolean enableAutoComplete = true;
        private Integer maxConcurrentSessions = null;
        private int prefetchCount = 0;
        private String queueName;
        private ServiceBusReceiveMode receiveMode = ServiceBusReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewDuration = ServiceBusClientBuilder.access$1900();
        private SubQueue subQueue = SubQueue.NONE;

        private ServiceBusSessionReceiverClientBuilder() {
        }

        public ServiceBusSessionReceiverClientBuilder disableAutoComplete() {
            this.enableAutoComplete = false;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration);
            this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
            return this;
        }

        ServiceBusSessionReceiverClientBuilder maxConcurrentSessions(int maxConcurrentSessions) {
            if (maxConcurrentSessions < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("maxConcurrentSessions cannot be less than 1."));
            }
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder prefetchCount(int prefetchCount) {
            ServiceBusClientBuilder.this.validateAndThrow(prefetchCount);
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder subQueue(SubQueue subQueue) {
            this.subQueue = subQueue;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        ServiceBusReceiverAsyncClient buildAsyncClientForProcessor() {
            String clientOptionIdentifier;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, this.subQueue);
            if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            ReceiverOptions receiverOptions = new ReceiverOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete, null, this.maxConcurrentSessions);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusSessionManager sessionManager = new ServiceBusSessionManager(entityPath, entityType, connectionProcessor, ServiceBusClientBuilder.this.messageSerializer, receiverOptions, clientIdentifier);
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.this.createTracer(), ServiceBusClientBuilder.this.createMeter(), connectionProcessor.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, false);
            return new ServiceBusReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, ServiceBusConstants.OPERATION_TIMEOUT, instrumentation, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, sessionManager);
        }

        public ServiceBusSessionReceiverAsyncClient buildAsyncClient() {
            return this.buildAsyncClient(true, false);
        }

        public ServiceBusSessionReceiverClient buildClient() {
            boolean isPrefetchDisabled = this.prefetchCount == 0;
            return new ServiceBusSessionReceiverClient(this.buildAsyncClient(false, true), isPrefetchDisabled, MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }

        private ServiceBusSessionReceiverAsyncClient buildAsyncClient(boolean isAutoCompleteAllowed, boolean syncConsumer) {
            String clientOptionIdentifier;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, SubQueue.NONE);
            if (!isAutoCompleteAllowed && this.enableAutoComplete) {
                LOGGER.warning("'enableAutoComplete' is not supported in synchronous client except through callback receive.");
                this.enableAutoComplete = false;
            } else if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            ReceiverOptions receiverOptions = new ReceiverOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete, null, this.maxConcurrentSessions);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.this.createTracer(), ServiceBusClientBuilder.this.createMeter(), connectionProcessor.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, syncConsumer);
            return new ServiceBusSessionReceiverAsyncClient(connectionProcessor.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionProcessor, instrumentation, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, clientIdentifier);
        }
    }

    public final class ServiceBusProcessorClientBuilder {
        private final ServiceBusReceiverClientBuilder serviceBusReceiverClientBuilder;
        private final ServiceBusProcessorClientOptions processorClientOptions;
        private Consumer<ServiceBusReceivedMessageContext> processMessage;
        private Consumer<ServiceBusErrorContext> processError;

        private ServiceBusProcessorClientBuilder() {
            this.serviceBusReceiverClientBuilder = new ServiceBusReceiverClientBuilder();
            this.processorClientOptions = new ServiceBusProcessorClientOptions().setMaxConcurrentCalls(1);
        }

        public ServiceBusProcessorClientBuilder prefetchCount(int prefetchCount) {
            this.serviceBusReceiverClientBuilder.prefetchCount(prefetchCount);
            return this;
        }

        public ServiceBusProcessorClientBuilder queueName(String queueName) {
            this.serviceBusReceiverClientBuilder.queueName(queueName);
            return this;
        }

        public ServiceBusProcessorClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.serviceBusReceiverClientBuilder.receiveMode(receiveMode);
            return this;
        }

        public ServiceBusProcessorClientBuilder subQueue(SubQueue subQueue) {
            this.serviceBusReceiverClientBuilder.subQueue(subQueue);
            return this;
        }

        public ServiceBusProcessorClientBuilder subscriptionName(String subscriptionName) {
            this.serviceBusReceiverClientBuilder.subscriptionName(subscriptionName);
            return this;
        }

        public ServiceBusProcessorClientBuilder topicName(String topicName) {
            this.serviceBusReceiverClientBuilder.topicName(topicName);
            return this;
        }

        public ServiceBusProcessorClientBuilder processMessage(Consumer<ServiceBusReceivedMessageContext> processMessage) {
            this.processMessage = processMessage;
            return this;
        }

        public ServiceBusProcessorClientBuilder processError(Consumer<ServiceBusErrorContext> processError) {
            this.processError = processError;
            return this;
        }

        public ServiceBusProcessorClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration);
            this.serviceBusReceiverClientBuilder.maxAutoLockRenewDuration(maxAutoLockRenewDuration);
            return this;
        }

        public ServiceBusProcessorClientBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentCalls' cannot be less than 1"));
            }
            this.processorClientOptions.setMaxConcurrentCalls(maxConcurrentCalls);
            return this;
        }

        public ServiceBusProcessorClientBuilder disableAutoComplete() {
            this.serviceBusReceiverClientBuilder.disableAutoComplete();
            this.processorClientOptions.setDisableAutoComplete(true);
            return this;
        }

        public ServiceBusProcessorClient buildProcessorClient() {
            return new ServiceBusProcessorClient(this.serviceBusReceiverClientBuilder, this.serviceBusReceiverClientBuilder.queueName, this.serviceBusReceiverClientBuilder.topicName, this.serviceBusReceiverClientBuilder.subscriptionName, Objects.requireNonNull(this.processMessage, "'processMessage' cannot be null"), Objects.requireNonNull(this.processError, "'processError' cannot be null"), this.processorClientOptions);
        }
    }

    public final class ServiceBusSessionProcessorClientBuilder {
        private final ServiceBusProcessorClientOptions processorClientOptions;
        private final ServiceBusSessionReceiverClientBuilder sessionReceiverClientBuilder;
        private Consumer<ServiceBusReceivedMessageContext> processMessage;
        private Consumer<ServiceBusErrorContext> processError;

        private ServiceBusSessionProcessorClientBuilder() {
            this.sessionReceiverClientBuilder = new ServiceBusSessionReceiverClientBuilder();
            this.processorClientOptions = new ServiceBusProcessorClientOptions().setMaxConcurrentCalls(1);
            this.sessionReceiverClientBuilder.maxConcurrentSessions(1);
        }

        public ServiceBusSessionProcessorClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration);
            this.sessionReceiverClientBuilder.maxAutoLockRenewDuration(maxAutoLockRenewDuration);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder maxConcurrentSessions(int maxConcurrentSessions) {
            if (maxConcurrentSessions < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentSessions' cannot be less than 1"));
            }
            this.sessionReceiverClientBuilder.maxConcurrentSessions(maxConcurrentSessions);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder prefetchCount(int prefetchCount) {
            this.sessionReceiverClientBuilder.prefetchCount(prefetchCount);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder queueName(String queueName) {
            this.sessionReceiverClientBuilder.queueName(queueName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.sessionReceiverClientBuilder.receiveMode(receiveMode);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder subQueue(SubQueue subQueue) {
            this.sessionReceiverClientBuilder.subQueue(subQueue);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder subscriptionName(String subscriptionName) {
            this.sessionReceiverClientBuilder.subscriptionName(subscriptionName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder topicName(String topicName) {
            this.sessionReceiverClientBuilder.topicName(topicName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder processMessage(Consumer<ServiceBusReceivedMessageContext> processMessage) {
            this.processMessage = processMessage;
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder processError(Consumer<ServiceBusErrorContext> processError) {
            this.processError = processError;
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentCalls' cannot be less than 1"));
            }
            this.processorClientOptions.setMaxConcurrentCalls(maxConcurrentCalls);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder disableAutoComplete() {
            this.sessionReceiverClientBuilder.disableAutoComplete();
            this.processorClientOptions.setDisableAutoComplete(true);
            return this;
        }

        public ServiceBusProcessorClient buildProcessorClient() {
            return new ServiceBusProcessorClient(this.sessionReceiverClientBuilder, this.sessionReceiverClientBuilder.queueName, this.sessionReceiverClientBuilder.topicName, this.sessionReceiverClientBuilder.subscriptionName, Objects.requireNonNull(this.processMessage, "'processMessage' cannot be null"), Objects.requireNonNull(this.processError, "'processError' cannot be null"), this.processorClientOptions);
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusRuleManagerAsyncClient.class, ServiceBusRuleManagerClient.class})
    public final class ServiceBusRuleManagerBuilder {
        private String subscriptionName;
        private String topicName;

        private ServiceBusRuleManagerBuilder() {
        }

        public ServiceBusRuleManagerBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusRuleManagerBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusRuleManagerAsyncClient buildAsyncClient() {
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, null);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, null, this.topicName, this.subscriptionName, null);
            ServiceBusConnectionProcessor connectionProcessor = ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer);
            return new ServiceBusRuleManagerAsyncClient(entityPath, entityType, connectionProcessor, ServiceBusClientBuilder.this::onClientClose);
        }

        public ServiceBusRuleManagerClient buildClient() {
            return new ServiceBusRuleManagerClient(this.buildAsyncClient(), MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }
    }
}

