/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracingLink;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ServiceBusTracer {
    public static final String REACTOR_PARENT_TRACE_CONTEXT_KEY = "otel-context-key";
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusTracer.class);
    private static final String TRACEPARENT_KEY = "traceparent";
    private static final String MESSAGING_SYSTEM_ATTRIBUTE_NAME = "messaging.system";
    public static final String MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME = "messaging.servicebus.message.enqueued_time";
    public static final String MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME = "messaging.batch.message_count";
    private static final String MESSAGING_OPERATION_ATTRIBUTE_NAME = "messaging.operation";
    protected static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    protected final Tracer tracer;
    protected final String fullyQualifiedName;
    protected final String entityPath;

    public ServiceBusTracer(Tracer tracer, String fullyQualifiedName, String entityPath) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null");
    }

    public boolean isEnabled() {
        return this.tracer != null && this.tracer.isEnabled();
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context span) {
        return this.isEnabled() ? this.tracer.makeSpanCurrent(span) : NOOP_CLOSEABLE;
    }

    public <T> Mono<T> traceMono(String spanName, Mono<T> publisher) {
        if (this.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.tracer.start(spanName, this.createStartOption(SpanKind.CLIENT, null), com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    public <T> Mono<T> traceMonoWithLink(String spanName, Mono<T> publisher, ServiceBusReceivedMessage message, com.azure.core.util.Context messageContext) {
        if (this.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite(ctx -> ctx.put((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpanWithLink(spanName, null, message, messageContext, com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    public <T> Mono<T> traceScheduleMono(String spanName, Mono<T> publisher, ServiceBusMessage message, com.azure.core.util.Context messageContext) {
        return this.traceMonoWithLink(spanName, OperationName.PUBLISH, publisher, message, messageContext);
    }

    public <T> Flux<T> traceScheduleFlux(String spanName, Flux<T> publisher, List<ServiceBusMessage> batch, Function<ServiceBusMessage, com.azure.core.util.Context> getContext) {
        if (this.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.startSpanWithLinks(spanName, OperationName.PUBLISH, batch, getContext, com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(Throwable throwable, com.azure.core.util.Context span, AutoCloseable scope) {
        if (this.isEnabled()) {
            String errorCondition = null;
            if (throwable instanceof AmqpException) {
                AmqpException exception = (AmqpException)throwable;
                errorCondition = exception.getErrorCondition().getErrorCondition();
            }
            try {
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Can't close scope", new Object[]{e});
            }
            finally {
                this.tracer.end(errorCondition, throwable, span);
            }
        }
    }

    public void reportMessageSpan(ServiceBusMessage serviceBusMessage, com.azure.core.util.Context messageContext) {
        if (!this.isEnabled() || messageContext == null || messageContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        Map<String, Object> applicationProperties = serviceBusMessage.getApplicationProperties();
        String traceparent = ServiceBusTracer.getTraceparent(applicationProperties);
        if (traceparent != null) {
            return;
        }
        StartSpanOptions startOptions = this.createStartOption(SpanKind.PRODUCER, null);
        com.azure.core.util.Context eventSpanContext = this.tracer.start("ServiceBus.message", startOptions, messageContext);
        this.tracer.injectContext((key, value) -> {
            applicationProperties.put((String)key, value);
            if (TRACEPARENT_KEY.equals(key)) {
                applicationProperties.put("Diagnostic-Id", value);
            }
        }, eventSpanContext);
        this.tracer.end(null, null, eventSpanContext);
        Optional spanContext = eventSpanContext.getData((Object)"span-context");
        if (spanContext.isPresent()) {
            serviceBusMessage.addContext("span-context", spanContext.get());
        }
    }

    public Mono<ServiceBusReceivedMessage> traceManagementReceive(String spanName, Mono<ServiceBusReceivedMessage> publisher, Function<ServiceBusReceivedMessage, com.azure.core.util.Context> getMessageContext) {
        if (this.isEnabled()) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, OperationName.RECEIVE);
            return publisher.doOnEach(signal -> {
                ServiceBusReceivedMessage message;
                if (signal.hasValue() && (message = (ServiceBusReceivedMessage)signal.get()) != null) {
                    startOptions.addLink(this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), (com.azure.core.util.Context)getMessageContext.apply(message)));
                }
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = this.tracer.start(spanName, startOptions, com.azure.core.util.Context.NONE);
                    this.tracer.end(null, signal.getThrowable(), span);
                }
            }).doOnSubscribe(s -> startOptions.setStartTimestamp(Instant.now()));
        }
        return publisher;
    }

    public Flux<ServiceBusReceivedMessage> traceSyncReceive(String spanName, Flux<ServiceBusReceivedMessage> messages) {
        if (this.isEnabled()) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, OperationName.RECEIVE);
            return messages.doOnEach(signal -> {
                if (signal.hasValue()) {
                    ServiceBusReceivedMessage message = (ServiceBusReceivedMessage)signal.get();
                    if (message != null) {
                        startOptions.addLink(this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), com.azure.core.util.Context.NONE));
                    }
                } else if (signal.isOnComplete() || signal.isOnError()) {
                    int batchSize = startOptions.getLinks() == null ? 0 : startOptions.getLinks().size();
                    startOptions.setAttribute(MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME, (Object)batchSize);
                    com.azure.core.util.Context span = this.tracer.start(spanName, startOptions, com.azure.core.util.Context.NONE);
                    this.tracer.end(null, signal.getThrowable(), span);
                }
            }).doOnSubscribe(ignored -> startOptions.setStartTimestamp(Instant.now()));
        }
        return messages;
    }

    public com.azure.core.util.Context startSpanWithLinks(String spanName, OperationName operationName, List<ServiceBusMessage> batch, Function<ServiceBusMessage, com.azure.core.util.Context> getMessageContext, com.azure.core.util.Context parent) {
        if (this.isEnabled() && batch != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, operationName);
            startOptions.setAttribute(MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME, (Object)batch.size());
            for (ServiceBusMessage message : batch) {
                startOptions.addLink(this.createLink(message.getApplicationProperties(), null, getMessageContext.apply(message)));
            }
            return this.tracer.start(spanName, startOptions, parent);
        }
        return parent;
    }

    com.azure.core.util.Context startSpanWithLink(String spanName, OperationName operationName, ServiceBusReceivedMessage message, com.azure.core.util.Context messageContext, com.azure.core.util.Context parent) {
        if (this.isEnabled() && message != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, operationName);
            startOptions.addLink(this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), messageContext));
            return this.tracer.start(spanName, startOptions, parent);
        }
        return parent;
    }

    com.azure.core.util.Context startProcessSpan(String spanName, ServiceBusReceivedMessage message, com.azure.core.util.Context parent) {
        if (this.isEnabled() && message != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CONSUMER, OperationName.PROCESS).setRemoteParent(this.extractContext(message.getApplicationProperties()));
            startOptions.setAttribute(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, (Object)message.getEnqueuedTime());
            return this.tracer.start(spanName, startOptions, parent);
        }
        return parent;
    }

    private TracingLink createLink(Map<String, Object> applicationProperties, OffsetDateTime enqueuedTime, com.azure.core.util.Context eventContext) {
        Optional linkContext = eventContext.getData((Object)"span-context");
        com.azure.core.util.Context link = linkContext.isPresent() ? (linkContext.get() instanceof com.azure.core.util.Context ? (com.azure.core.util.Context)linkContext.get() : com.azure.core.util.Context.NONE) : this.extractContext(applicationProperties);
        Map<String, Long> linkAttributes = null;
        if (enqueuedTime != null) {
            linkAttributes = Collections.singletonMap(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, enqueuedTime.toEpochSecond());
        }
        return new TracingLink(link, linkAttributes);
    }

    private com.azure.core.util.Context extractContext(Map<String, Object> applicationProperties) {
        if (applicationProperties == null) {
            return com.azure.core.util.Context.NONE;
        }
        return this.tracer.extractContext(key -> {
            if (TRACEPARENT_KEY.equals(key)) {
                return ServiceBusTracer.getTraceparent(applicationProperties);
            }
            Object value = applicationProperties.get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        });
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get("Diagnostic-Id");
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get(TRACEPARENT_KEY);
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    private StartSpanOptions createStartOption(SpanKind kind, OperationName operationName) {
        StartSpanOptions startOptions = new StartSpanOptions(kind).setAttribute(MESSAGING_SYSTEM_ATTRIBUTE_NAME, (Object)"servicebus").setAttribute("entity-path", (Object)this.entityPath).setAttribute("hostname", (Object)this.fullyQualifiedName);
        if (operationName != null) {
            startOptions.setAttribute(MESSAGING_OPERATION_ATTRIBUTE_NAME, (Object)operationName.toString());
        }
        return startOptions;
    }

    private <T> Mono<T> traceMonoWithLink(String spanName, OperationName operationName, Mono<T> publisher, ServiceBusMessage message, com.azure.core.util.Context messageContext) {
        if (this.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite(ctx -> {
                StartSpanOptions startSpanOptions = this.createStartOption(SpanKind.CLIENT, operationName);
                if (message != null) {
                    this.reportMessageSpan(message, messageContext);
                    startSpanOptions.addLink(this.createLink(message.getApplicationProperties(), null, messageContext));
                }
                com.azure.core.util.Context span = this.tracer.start(spanName, startSpanOptions, com.azure.core.util.Context.NONE);
                return ctx.put((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)span);
            });
        }
        return publisher;
    }

    public static enum OperationName {
        PUBLISH("publish"),
        RECEIVE("receive"),
        SETTLE("settle"),
        PROCESS("process");

        private final String operationName;

        private OperationName(String operationName) {
            this.operationName = operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

