/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import java.util.Objects;

final class ServiceBusMessageContext {
    private final ServiceBusReceivedMessage message;
    private final String sessionId;
    private final Throwable error;

    ServiceBusMessageContext(ServiceBusReceivedMessage message) {
        this.message = Objects.requireNonNull(message, "'message' cannot be null.");
        this.sessionId = message.getSessionId();
        this.error = null;
    }

    ServiceBusMessageContext(String sessionId, Throwable error) {
        this.sessionId = Objects.requireNonNull(sessionId, "'sessionId' cannot be null.");
        this.error = Objects.requireNonNull(error, "'error' cannot be null.");
        this.message = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Throwable getThrowable() {
        return this.error;
    }

    public ServiceBusReceivedMessage getMessage() {
        return this.message;
    }

    public boolean hasError() {
        return this.error != null;
    }
}

