/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.implementation.Messages;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementNode;
import com.azure.messaging.servicebus.implementation.ServiceBusReactorAmqpConnection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusClientBuilder.class, isAsync=true)
public class ServiceBusRuleManagerAsyncClient
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusRuleManagerAsyncClient.class);
    private final String entityPath;
    private final MessagingEntityType entityType;
    private final ReactorConnectionCache<ServiceBusReactorAmqpConnection> connectionCache;
    private final Runnable onClientClose;
    private final AtomicBoolean isDisposed = new AtomicBoolean();

    ServiceBusRuleManagerAsyncClient(String entityPath, MessagingEntityType entityType, ReactorConnectionCache<ServiceBusReactorAmqpConnection> connectionCache, Runnable onClientClose) {
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "'entityType' cannot be null.");
        this.connectionCache = Objects.requireNonNull(connectionCache, "'connectionCache' cannot be null.");
        this.onClientClose = onClientClose;
    }

    public String getFullyQualifiedNamespace() {
        return this.connectionCache.getFullyQualifiedNamespace();
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public Mono<Void> createRule(String ruleName, CreateRuleOptions options) {
        if (Objects.isNull(options)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.createRuleInternal(ruleName, options);
    }

    public Flux<RuleProperties> listRules() {
        if (this.isDisposed.get()) {
            return FluxUtil.fluxError((ClientLogger)LOGGER, (RuntimeException)new IllegalStateException(String.format(Messages.INVALID_OPERATION_DISPOSED_RULE_MANAGER, "getRules")));
        }
        return this.connectionCache.get().flatMap(connection -> connection.getManagementNode(this.entityPath, this.entityType)).flatMapMany(ServiceBusManagementNode::listRules);
    }

    public Mono<Void> deleteRule(String ruleName) {
        if (this.isDisposed.get()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalStateException(String.format(Messages.INVALID_OPERATION_DISPOSED_RULE_MANAGER, "deleteRule")));
        }
        if (ruleName == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'ruleName' cannot be null."));
        }
        if (ruleName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be an empty string."));
        }
        return this.connectionCache.get().flatMap(connection -> connection.getManagementNode(this.entityPath, this.entityType)).flatMap(managementNode -> managementNode.deleteRule(ruleName));
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.onClientClose.run();
    }

    private Mono<Void> createRuleInternal(String ruleName, CreateRuleOptions options) {
        if (this.isDisposed.get()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalStateException(String.format(Messages.INVALID_OPERATION_DISPOSED_RULE_MANAGER, "createRule")));
        }
        if (ruleName == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'ruleName' cannot be null."));
        }
        if (ruleName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be an empty string."));
        }
        return this.connectionCache.get().flatMap(connection -> connection.getManagementNode(this.entityPath, this.entityType)).flatMap(managementNode -> managementNode.createRule(ruleName, options));
    }
}

